/*
 * Decompiled with CFR 0.152.
 */
package forge.game.trigger;

import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.Trigger;
import forge.util.Localizer;
import java.util.Map;

public class TriggerTaps
extends Trigger {
    public TriggerTaps(Map<String, String> params, Card host, boolean intrinsic) {
        super(params, host, intrinsic);
    }

    @Override
    public final boolean performTest(Map<AbilityKey, Object> runParams) {
        if (!this.matchesValidParam("ValidCard", runParams.get((Object)AbilityKey.Card))) {
            return false;
        }
        if (!this.matchesValidParam("ValidCause", runParams.get((Object)AbilityKey.Cause))) {
            return false;
        }
        if (!this.matchesValidParam("ValidPlayer", runParams.get((Object)AbilityKey.Player))) {
            return false;
        }
        return !this.hasParam("Attacker") || this.getParam("Attacker").equalsIgnoreCase("True") == ((Boolean)runParams.get((Object)AbilityKey.Attacker)).booleanValue();
    }

    @Override
    public final void setTriggeringObjects(SpellAbility sa, Map<AbilityKey, Object> runParams) {
        sa.setTriggeringObjectsFrom(runParams, AbilityKey.Card);
    }

    @Override
    public String getImportantStackObjects(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        sb.append(Localizer.getInstance().getMessage("lblTapped", new Object[0])).append(": ").append(sa.getTriggeringObject(AbilityKey.Card));
        return sb.toString();
    }
}

