/*
 * Decompiled with CFR 0.152.
 */
package forge.game.trigger;

import com.google.common.collect.Iterables;
import forge.game.CardTraitBase;
import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.card.CardPredicates;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.Trigger;
import forge.util.Localizer;
import java.util.Map;

public class TriggerTapAll
extends Trigger {
    public TriggerTapAll(Map<String, String> params, Card host, boolean intrinsic) {
        super(params, host, intrinsic);
    }

    @Override
    public boolean performTest(Map<AbilityKey, Object> runParams) {
        return this.matchesValidParam("ValidCards", runParams.get((Object)AbilityKey.Cards));
    }

    @Override
    public void setTriggeringObjects(SpellAbility sa, Map<AbilityKey, Object> runParams) {
        Iterable<Card> cards = (Iterable<Card>)runParams.get((Object)AbilityKey.Cards);
        if (this.hasParam("ValidCards")) {
            cards = Iterables.filter(cards, CardPredicates.restriction(this.getParam("ValidCards").split(","), this.getHostCard().getController(), this.getHostCard(), (CardTraitBase)this));
        }
        sa.setTriggeringObject(AbilityKey.Cards, cards);
    }

    @Override
    public String getImportantStackObjects(SpellAbility sa) {
        return Localizer.getInstance().getMessage("lblTapped", new Object[0]) + ": " + sa.getTriggeringObject(AbilityKey.Cards);
    }
}

