/*
 * Decompiled with CFR 0.152.
 */
package forge.game.trigger;

import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.Trigger;
import forge.util.Localizer;
import java.util.Map;

public class TriggerPayCumulativeUpkeep
extends Trigger {
    public TriggerPayCumulativeUpkeep(Map<String, String> params, Card host, boolean intrinsic) {
        super(params, host, intrinsic);
    }

    @Override
    public final boolean performTest(Map<AbilityKey, Object> runParams) {
        if (this.hasParam("Paid")) {
            Boolean paid = (Boolean)runParams.get((Object)AbilityKey.CumulativeUpkeepPaid);
            if (this.getParam("Paid").equals("True") ^ paid) {
                return false;
            }
        }
        return this.matchesValidParam("ValidCard", runParams.get((Object)AbilityKey.Card));
    }

    @Override
    public final void setTriggeringObjects(SpellAbility sa, Map<AbilityKey, Object> runParams) {
        sa.setTriggeringObjectsFrom(runParams, AbilityKey.Card, AbilityKey.PayingMana);
    }

    @Override
    public String getImportantStackObjects(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        sb.append(Localizer.getInstance().getMessage("lblMana", new Object[0])).append(": ").append(sa.getTriggeringObject(AbilityKey.PayingMana));
        return sb.toString();
    }
}

