/*
 * Decompiled with CFR 0.152.
 */
package forge.game.trigger;

import com.google.common.collect.Maps;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.Trigger;
import forge.util.Expressions;
import java.util.HashMap;
import java.util.Map;

public class TriggerLifeLostAll
extends Trigger {
    public TriggerLifeLostAll(Map<String, String> params, Card host, boolean intrinsic) {
        super(params, host, intrinsic);
    }

    @Override
    public final boolean performTest(Map<AbilityKey, Object> runParams) {
        Map<Player, Integer> testMap = this.filteredMap((Map)runParams.get((Object)AbilityKey.Map));
        return !testMap.isEmpty();
    }

    @Override
    public final void setTriggeringObjects(SpellAbility sa, Map<AbilityKey, Object> runParams) {
        Map<Player, Integer> map = this.filteredMap((Map)runParams.get((Object)AbilityKey.Map));
        sa.setTriggeringObject(AbilityKey.Map, map);
        sa.setTriggeringObject(AbilityKey.Player, map.keySet());
    }

    @Override
    public String getImportantStackObjects(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        Map map = (Map)sa.getTriggeringObject(AbilityKey.Map);
        int n = 0;
        for (Map.Entry e : map.entrySet()) {
            sb.append(e.getKey()).append(": ").append(e.getValue());
            if (map.size() <= ++n) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    private Map<Player, Integer> filteredMap(Map<Player, Integer> map) {
        HashMap<Player, Integer> passMap = Maps.newHashMap();
        for (Map.Entry<Player, Integer> e : map.entrySet()) {
            if (!this.matchesValidParam("ValidPlayer", e.getKey())) continue;
            if (this.hasParam("ValidAmountEach")) {
                String comp = this.getParam("ValidAmountEach");
                int value = AbilityUtils.calculateAmount(this.getHostCard(), comp.substring(2), this);
                if (!Expressions.compare(e.getValue(), comp.substring(0, 2), value)) continue;
            }
            passMap.put(e.getKey(), e.getValue());
        }
        return passMap;
    }
}

