/*
 * Decompiled with CFR 0.152.
 */
package forge.game.trigger;

import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.Trigger;
import forge.util.Localizer;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;

public class TriggerLandPlayed
extends Trigger {
    public TriggerLandPlayed(Map<String, String> params, Card host, boolean intrinsic) {
        super(params, host, intrinsic);
    }

    @Override
    public final void setTriggeringObjects(SpellAbility sa, Map<AbilityKey, Object> runParams) {
        sa.setTriggeringObjectsFrom(runParams, AbilityKey.Card);
    }

    @Override
    public String getImportantStackObjects(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        sb.append(Localizer.getInstance().getMessage("lblLandPlayed", new Object[0])).append(": ").append(sa.getTriggeringObject(AbilityKey.Card));
        return sb.toString();
    }

    @Override
    public final boolean performTest(Map<AbilityKey, Object> runParams) {
        Card land;
        if (this.hasParam("Origin") && !this.getParam("Origin").equals("Any")) {
            if (this.getParam("Origin") == null) {
                return false;
            }
            if (!ArrayUtils.contains(this.getParam("Origin").split(","), runParams.get((Object)AbilityKey.Origin))) {
                return false;
            }
        }
        if (!this.matchesValidParam("ValidCard", runParams.get((Object)AbilityKey.Card))) {
            return false;
        }
        if (!this.matchesValidParam("ValidSA", runParams.get((Object)AbilityKey.SpellAbility))) {
            return false;
        }
        return !this.hasParam("NotFirstLand") || (land = (Card)runParams.get((Object)AbilityKey.Card)).getController().getLandsPlayedThisTurn() >= 1;
    }
}

