/*
 * Decompiled with CFR 0.152.
 */
package forge.game.trigger;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import forge.game.CardTraitBase;
import forge.game.CardTraitPredicates;
import forge.game.Game;
import forge.game.IHasSVars;
import forge.game.ability.AbilityFactory;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardState;
import forge.game.player.Player;
import forge.game.spellability.AbilitySub;
import forge.game.spellability.SpellAbility;
import forge.game.staticability.StaticAbilityDisableTriggers;
import forge.game.staticability.StaticAbilityPanharmonicon;
import forge.game.trigger.Trigger;
import forge.game.trigger.TriggerAbilityResolves;
import forge.game.trigger.TriggerAbilityTriggered;
import forge.game.trigger.TriggerManaAdded;
import forge.game.trigger.TriggerSpellAbilityCastOrCopy;
import forge.game.trigger.TriggerTapAll;
import forge.game.trigger.TriggerTaps;
import forge.game.trigger.TriggerTapsForMana;
import forge.game.trigger.TriggerType;
import forge.game.trigger.TriggerUntapAll;
import forge.game.trigger.TriggerUntaps;
import forge.game.trigger.TriggerWaiting;
import forge.game.trigger.WrappedAbility;
import forge.game.zone.Zone;
import forge.game.zone.ZoneType;
import forge.util.FileSection;
import forge.util.Visitor;
import io.sentry.Breadcrumb;
import io.sentry.Sentry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TriggerHandler {
    private final Set<TriggerType> suppressedModes = Collections.synchronizedSet(EnumSet.noneOf(TriggerType.class));
    private boolean allSuppressed = false;
    private final List<Trigger> activeTriggers = Collections.synchronizedList(new ArrayList());
    private final List<Trigger> delayedTriggers = Collections.synchronizedList(new ArrayList());
    private final List<Trigger> thisTurnDelayedTriggers = Collections.synchronizedList(new ArrayList());
    private final ListMultimap<Player, Trigger> playerDefinedDelayedTriggers = Multimaps.synchronizedListMultimap(ArrayListMultimap.create());
    private final List<TriggerWaiting> waitingTriggers = Collections.synchronizedList(new ArrayList());
    private final Game game;

    public TriggerHandler(Game gameState) {
        this.game = gameState;
    }

    public final boolean hasDelayedTriggers() {
        return !this.delayedTriggers.isEmpty();
    }

    public final void registerDelayedTrigger(Trigger trig) {
        this.delayedTriggers.add(trig);
    }

    public final void clearDelayedTrigger() {
        this.delayedTriggers.clear();
    }

    public final void registerThisTurnDelayedTrigger(Trigger trig) {
        this.thisTurnDelayedTriggers.add(trig);
        this.delayedTriggers.add(trig);
    }

    public final void clearThisTurnDelayedTrigger() {
        this.delayedTriggers.removeAll(this.thisTurnDelayedTriggers);
        this.thisTurnDelayedTriggers.clear();
    }

    public final void clearDelayedTrigger(Card card) {
        ArrayList<Trigger> deltrigs = new ArrayList<Trigger>(this.delayedTriggers);
        for (Trigger trigger : deltrigs) {
            if (!trigger.getHostCard().equals(card)) continue;
            this.delayedTriggers.remove(trigger);
        }
    }

    public final void registerPlayerDefinedDelayedTrigger(Player player, Trigger trig) {
        this.playerDefinedDelayedTriggers.put(player, trig);
    }

    public final void clearPlayerDefinedDelayedTrigger() {
        this.playerDefinedDelayedTriggers.clear();
    }

    public final void handlePlayerDefinedDelTriggers(Player player) {
        Collection playerTriggers = this.playerDefinedDelayedTriggers.removeAll(player);
        Iterables.addAll(this.thisTurnDelayedTriggers, Iterables.filter(playerTriggers, CardTraitPredicates.hasParam("ThisTurn")));
        this.delayedTriggers.addAll(playerTriggers);
    }

    public final void suppressMode(TriggerType mode) {
        this.suppressedModes.add(mode);
    }

    public final void setSuppressAllTriggers(boolean suppress) {
        this.allSuppressed = suppress;
    }

    public final void clearSuppression(TriggerType mode) {
        this.suppressedModes.remove((Object)mode);
    }

    public boolean isTriggerSuppressed(TriggerType mode) {
        return this.allSuppressed || this.suppressedModes.contains((Object)mode);
    }

    public static Trigger parseTrigger(String trigParse, Card host, boolean intrinsic) {
        return TriggerHandler.parseTrigger(trigParse, host, intrinsic, (IHasSVars)host.getCurrentState());
    }

    public static Trigger parseTrigger(String trigParse, Card host, boolean intrinsic, IHasSVars sVarHolder) {
        try {
            Map<String, String> mapParams = TriggerHandler.parseParams(trigParse);
            return TriggerHandler.parseTrigger(mapParams, host, intrinsic, sVarHolder);
        }
        catch (Exception e) {
            String msg = "TriggerHandler:parseTrigger failed to parse";
            Breadcrumb bread = new Breadcrumb(msg);
            bread.setData("Card", host.getName());
            bread.setData("Trigger", trigParse);
            Sentry.addBreadcrumb(bread);
            throw new RuntimeException("Error in Trigger for Card: " + host.getName(), e);
        }
    }

    public static Trigger parseTrigger(Map<String, String> mapParams, Card host, boolean intrinsic, IHasSVars sVarHolder) {
        Trigger ret = null;
        try {
            TriggerType type = TriggerType.smartValueOf(mapParams.get("Mode"));
            ret = type.createTrigger(mapParams, host, intrinsic);
            if (sVarHolder != null) {
                ret.ensureAbility(sVarHolder);
                if (sVarHolder instanceof CardState) {
                    ret.setCardState((CardState)sVarHolder);
                } else if (sVarHolder instanceof CardTraitBase) {
                    ret.setCardState(((CardTraitBase)sVarHolder).getCardState());
                }
            }
        }
        catch (Exception e) {
            String msg = "TriggerHandler:parseTrigger failed to parse";
            Breadcrumb bread = new Breadcrumb(msg);
            bread.setData("Card", host.getName());
            bread.setData("Params", mapParams.toString());
            Sentry.addBreadcrumb(bread);
            throw new RuntimeException("Error in Trigger for Card: " + host.getName(), e);
        }
        return ret;
    }

    private static Map<String, String> parseParams(String trigParse) {
        if (trigParse.length() == 0) {
            throw new RuntimeException("TriggerFactory : registerTrigger -- trigParse too short");
        }
        return FileSection.parseToMap(trigParse, FileSection.DOLLAR_SIGN_KV_SEPARATOR);
    }

    public void collectTriggerForWaiting() {
        for (TriggerWaiting wt : this.waitingTriggers) {
            if (wt.getTriggers() != null) continue;
            wt.setTriggers(this.getActiveTrigger(wt.getMode(), wt.getParams()));
        }
    }

    private void buildActiveTrigger() {
        this.activeTriggers.clear();
        this.game.forEachCardInGame(new Visitor<Card>(){

            @Override
            public boolean visit(Card c) {
                for (Trigger t2 : c.getTriggers()) {
                    if (!TriggerHandler.this.isTriggerActive(t2)) continue;
                    TriggerHandler.this.activeTriggers.add(t2);
                }
                return true;
            }
        });
    }

    public final void resetActiveTriggers() {
        this.resetActiveTriggers(true);
    }

    public final void resetActiveTriggers(boolean collect) {
        if (collect) {
            this.collectTriggerForWaiting();
        }
        this.buildActiveTrigger();
    }

    public final void clearActiveTriggers(Card c, Zone zoneFrom) {
        ArrayList<Trigger> toBeRemoved = Lists.newArrayList();
        for (Trigger t2 : this.activeTriggers) {
            if (c.getId() != t2.getHostCard().getId() || c.getTriggers().contains(t2) && t2.zonesCheck(zoneFrom)) continue;
            toBeRemoved.add(t2);
        }
        this.activeTriggers.removeAll(toBeRemoved);
    }

    public final void registerActiveTrigger(Card c, boolean onlyExtrinsic) {
        for (Trigger t2 : c.getTriggers()) {
            if (onlyExtrinsic && !c.isCloned() && t2.isIntrinsic() && !TriggerType.Always.equals((Object)t2.getMode())) continue;
            this.registerOneTrigger(t2);
        }
    }

    public final void registerActiveLTBTrigger(Card c) {
        for (Trigger t2 : c.getTriggers()) {
            if (!TriggerType.Exploited.equals((Object)t2.getMode()) && !TriggerType.Destroyed.equals((Object)t2.getMode()) && !TriggerType.Sacrificed.equals((Object)t2.getMode()) && !TriggerType.SacrificedOnce.equals((Object)t2.getMode()) && (!TriggerType.ChangesZone.equals((Object)t2.getMode()) && !TriggerType.ChangesZoneAll.equals((Object)t2.getMode()) || !"Battlefield".equals(t2.getParam("Origin")))) continue;
            this.registerOneTrigger(t2);
        }
    }

    public final boolean registerOneTrigger(Trigger t2) {
        if (this.isTriggerActive(t2)) {
            this.activeTriggers.add(t2);
            return true;
        }
        return false;
    }

    public final void runTrigger(TriggerType mode, Map<AbilityKey, Object> runParams, boolean holdTrigger) {
        if (this.isTriggerSuppressed(mode)) {
            return;
        }
        if (mode == TriggerType.Always) {
            this.runStateTrigger(runParams);
        } else if ((this.game.getStack().isFrozen() || holdTrigger) && mode != TriggerType.TapsForMana && mode != TriggerType.ManaAdded) {
            this.waitingTriggers.add(new TriggerWaiting(mode, runParams));
        } else {
            this.runWaitingTrigger(new TriggerWaiting(mode, runParams));
        }
    }

    private void runStateTrigger(Map<AbilityKey, Object> runParams) {
        for (Trigger t2 : Lists.newArrayList(this.activeTriggers)) {
            if (!this.canRunTrigger(t2, TriggerType.Always, runParams)) continue;
            this.runSingleTrigger(t2, runParams);
        }
    }

    public final boolean runWaitingTriggers() {
        if (this.waitingTriggers.isEmpty()) {
            return false;
        }
        ArrayList<TriggerWaiting> waiting = new ArrayList<TriggerWaiting>(this.waitingTriggers);
        this.waitingTriggers.clear();
        boolean haveWaiting = false;
        for (TriggerWaiting wt : waiting) {
            haveWaiting |= this.runWaitingTrigger(wt);
        }
        return haveWaiting;
    }

    private boolean runWaitingTrigger(TriggerWaiting wt) {
        TriggerType mode = wt.getMode();
        Map<AbilityKey, Object> runParams = wt.getParams();
        Player playerAP = this.game.getPhaseHandler().getPlayerTurn();
        if (playerAP == null) {
            return false;
        }
        ArrayList<Trigger> delayedTriggersWorkingCopy = new ArrayList<Trigger>(this.delayedTriggers);
        boolean checkStatics = false;
        for (Trigger t2 : Lists.newArrayList(this.activeTriggers)) {
            if (!t2.isStatic() || !this.canRunTrigger(t2, mode, runParams)) continue;
            int x = 1 + StaticAbilityPanharmonicon.handlePanharmonicon(this.game, t2, runParams);
            for (int i = 0; i < x; ++i) {
                this.runSingleTrigger(t2, runParams);
            }
            checkStatics = true;
        }
        if (runParams.containsKey((Object)AbilityKey.Destination)) {
            if (runParams.get((Object)AbilityKey.Destination) instanceof String) {
                String type = (String)runParams.get((Object)AbilityKey.Destination);
                checkStatics |= type.equals("Battlefield");
            } else {
                ZoneType zone = (ZoneType)((Object)runParams.get((Object)AbilityKey.Destination));
                if (zone != null) {
                    checkStatics |= zone.equals((Object)ZoneType.Battlefield);
                }
            }
        }
        checkStatics |= this.runNonStaticTriggersForPlayer(playerAP, wt, delayedTriggersWorkingCopy);
        for (Player nap : this.game.getNonactivePlayers()) {
            checkStatics |= this.runNonStaticTriggersForPlayer(nap, wt, delayedTriggersWorkingCopy);
        }
        return checkStatics;
    }

    public void clearWaitingTriggers() {
        this.waitingTriggers.clear();
    }

    private boolean runNonStaticTriggersForPlayer(Player player, TriggerWaiting wt, List<Trigger> delayedTriggersWorkingCopy) {
        TriggerType mode = wt.getMode();
        Map<AbilityKey, Object> runParams = wt.getParams();
        boolean wasCollected = wt.getTriggers() != null;
        Iterable<Trigger> triggers = wasCollected ? wt.getTriggers() : this.activeTriggers;
        boolean checkStatics = false;
        for (Trigger t2 : triggers) {
            if (t2.isStatic() || !t2.getHostCard().getController().equals(player) || !wasCollected && !this.canRunTrigger(t2, mode, runParams) || wasCollected && !t2.checkActivationLimit()) continue;
            int x = 1 + StaticAbilityPanharmonicon.handlePanharmonicon(this.game, t2, runParams);
            for (int i = 0; i < x; ++i) {
                this.runSingleTrigger(t2, runParams, wt.getController(t2));
            }
            checkStatics = true;
        }
        for (Trigger deltrig : delayedTriggersWorkingCopy) {
            if (!deltrig.getHostCard().getController().equals(player) || !this.isTriggerActive(deltrig) || !this.canRunTrigger(deltrig, mode, runParams)) continue;
            this.delayedTriggers.remove(deltrig);
            this.runSingleTrigger(deltrig, runParams);
        }
        return checkStatics;
    }

    private boolean isTriggerActive(Trigger regtrig) {
        if (!regtrig.phasesCheck(this.game)) {
            return false;
        }
        if (TriggerType.Always.equals((Object)regtrig.getMode()) && this.game.getStack().hasStateTrigger(regtrig.getId())) {
            return false;
        }
        if (regtrig.isSuppressed()) {
            return false;
        }
        if (regtrig.getSpawningAbility() == null && !regtrig.zonesCheck(this.game.getZoneOf(regtrig.getHostCard()))) {
            return false;
        }
        for (Trigger t2 : this.activeTriggers) {
            if (regtrig.getId() != t2.getId()) continue;
            return false;
        }
        return true;
    }

    private boolean canRunTrigger(Trigger regtrig, TriggerType mode, Map<AbilityKey, Object> runParams) {
        if (regtrig.getMode() != mode) {
            return false;
        }
        if (!regtrig.checkActivationLimit()) {
            return false;
        }
        if (!regtrig.requirementsCheck(this.game)) {
            return false;
        }
        if (!regtrig.meetsRequirementsOnTriggeredObjects(this.game, runParams)) {
            return false;
        }
        if (!regtrig.performTest(runParams)) {
            return false;
        }
        if (regtrig.isSuppressed()) {
            return false;
        }
        if (TriggerType.Always.equals((Object)regtrig.getMode()) && this.game.getStack().hasStateTrigger(regtrig.getId())) {
            return false;
        }
        return regtrig.isStatic() || !StaticAbilityDisableTriggers.disabled(this.game, regtrig, runParams);
    }

    private void runSingleTrigger(Trigger regtrig, Map<AbilityKey, Object> runParams) {
        this.runSingleTrigger(regtrig, runParams, null);
    }

    private void runSingleTrigger(Trigger regtrig, Map<AbilityKey, Object> runParams, Player controller) {
        if (controller == null) {
            controller = regtrig.getHostCard().getController();
        }
        if (runParams.get((Object)AbilityKey.MergedCards) != null) {
            Card original = (Card)runParams.get((Object)AbilityKey.Card);
            CardCollection mergedCards = (CardCollection)runParams.get((Object)AbilityKey.MergedCards);
            mergedCards.set(mergedCards.indexOf(original), original);
            EnumMap<AbilityKey, Object> newParams = AbilityKey.newMap(runParams);
            if ("Battlefield".equals(regtrig.getParam("Origin"))) {
                newParams.put(AbilityKey.Card, (Object)mergedCards);
                this.runSingleTriggerInternal(regtrig, newParams, controller);
            } else {
                for (Card c : mergedCards) {
                    newParams.put(AbilityKey.Card, (Object)c);
                    this.runSingleTriggerInternal(regtrig, newParams, controller);
                }
            }
        } else {
            this.runSingleTriggerInternal(regtrig, runParams, controller);
        }
    }

    private void runSingleTriggerInternal(Trigger regtrig, Map<AbilityKey, Object> runParams, Player controller) {
        this.adjustUndoStack(regtrig, runParams);
        Card host = regtrig.getHostCard();
        SpellAbility sa = regtrig.getOverridingAbility();
        if (sa == null) {
            if (!regtrig.hasParam("Execute")) {
                sa = new SpellAbility.EmptySa(host);
            } else {
                String name = regtrig.getParam("Execute");
                if (!host.getCurrentState().hasSVar(name)) {
                    System.err.println("Warning: tried to run a trigger for card " + host + " referencing a SVar " + name + " not present on the current state " + host.getCurrentState() + ". Aborting trigger execution to prevent a crash.");
                    return;
                }
                sa = AbilityFactory.getAbility(host, name);
                regtrig.setOverridingAbility(sa);
            }
            sa.setActivatingPlayer(controller);
            if (regtrig.isIntrinsic()) {
                sa.setIntrinsic(true);
                sa.changeText();
            }
        } else {
            if (regtrig.getSpawningAbility() != null) {
                controller = regtrig.getSpawningAbility().getActivatingPlayer();
            }
            sa = sa.copy(host, controller, false, true);
        }
        sa.setTrigger(regtrig);
        sa.setSourceTrigger(regtrig.getId());
        regtrig.setTriggeringObjects(sa, runParams);
        sa.setTriggerRemembered(regtrig.getTriggerRemembered());
        if (regtrig.hasParam("TriggerController")) {
            Player p = (Player)AbilityUtils.getDefinedPlayers(host, regtrig.getParam("TriggerController"), sa).get(false);
            sa.setActivatingPlayer(p);
        }
        if (regtrig.hasParam("RememberTriggeringCard")) {
            Card triggeredCard = (Card)sa.getTriggeringObject(AbilityKey.Card);
            host.addRemembered(triggeredCard);
        }
        if (!sa.getActivatingPlayer().isInGame()) {
            return;
        }
        sa.setStackDescription(sa.toString());
        Player decider = null;
        boolean isMandatory = false;
        if (regtrig.hasParam("OptionalDecider")) {
            sa.setOptionalTrigger(true);
            decider = (Player)AbilityUtils.getDefinedPlayers(host, regtrig.getParam("OptionalDecider"), sa).get(false);
        } else if (sa instanceof AbilitySub || !sa.hasParam("Cost") || sa.getPayCosts() != null && sa.getPayCosts().isMandatory() || sa.getParam("Cost").equals("0")) {
            isMandatory = true;
        } else {
            sa.setOptionalTrigger(true);
            decider = sa.getActivatingPlayer();
        }
        WrappedAbility wrapperAbility = new WrappedAbility(regtrig, sa, decider);
        if (regtrig.isStatic()) {
            if (wrapperAbility.getActivatingPlayer().getController().playTrigger(host, wrapperAbility, isMandatory)) {
                Map<AbilityKey, Object> staticParams = AbilityKey.mapFromCard(host);
                staticParams.put(AbilityKey.SpellAbility, sa);
                this.game.getTriggerHandler().runTrigger(TriggerType.AbilityResolves, staticParams, false);
            }
        } else {
            this.game.getStack().addSimultaneousStackEntry(wrapperAbility);
            this.game.getTriggerHandler().runTrigger(TriggerType.AbilityTriggered, TriggerAbilityTriggered.getRunParams(regtrig, wrapperAbility, runParams), false);
        }
        regtrig.triggerRun();
        boolean removeBoon = host.isBoon();
        if (regtrig.hasParam("BoonAmount")) {
            int x = AbilityUtils.calculateAmount(host, regtrig.getParam("BoonAmount"), wrapperAbility);
            int y = host.getAbilityActivatedThisGame(regtrig.getOverridingAbility());
            if (y < x) {
                removeBoon = false;
            }
        }
        if (regtrig.hasParam("OneOff") && host.isImmutable() || removeBoon) {
            host.getController().getZone(ZoneType.Command).remove(host);
        }
    }

    private void adjustUndoStack(Trigger regtrig, Map<AbilityKey, Object> runParams) {
        block11: {
            block12: {
                block10: {
                    if (!(regtrig instanceof TriggerTapsForMana) && !(regtrig instanceof TriggerManaAdded)) break block10;
                    SpellAbility abMana = (SpellAbility)runParams.get((Object)AbilityKey.AbilityMana);
                    if (null == abMana || null == abMana.getManaPart()) break block11;
                    abMana.setUndoable(false);
                    break block11;
                }
                if (!(regtrig instanceof TriggerSpellAbilityCastOrCopy) && !(regtrig instanceof TriggerAbilityResolves)) break block12;
                SpellAbility abMana = (SpellAbility)runParams.get((Object)AbilityKey.SpellAbility);
                if (null == abMana || null == abMana.getManaPart()) break block11;
                abMana.setUndoable(false);
                break block11;
            }
            if (regtrig instanceof TriggerTaps || regtrig instanceof TriggerUntaps) {
                Card c = (Card)runParams.get((Object)AbilityKey.Card);
                for (SpellAbility sa : this.game.getStack().filterUndoStackByHost(c)) {
                    sa.setUndoable(false);
                }
            } else if (regtrig instanceof TriggerTapAll) {
                Iterable cards = (Iterable)runParams.get((Object)AbilityKey.Cards);
                for (Card c : cards) {
                    for (SpellAbility sa : this.game.getStack().filterUndoStackByHost(c)) {
                        sa.setUndoable(false);
                    }
                }
            } else if (regtrig instanceof TriggerUntapAll) {
                Map map = (Map)runParams.get((Object)AbilityKey.Map);
                for (Card c : Iterables.concat(map.values())) {
                    for (SpellAbility sa : this.game.getStack().filterUndoStackByHost(c)) {
                        sa.setUndoable(false);
                    }
                }
            }
        }
    }

    public List<Trigger> getActiveTrigger(TriggerType mode, Map<AbilityKey, Object> runParams) {
        ArrayList<Trigger> trigger = Lists.newArrayList();
        for (Trigger t2 : this.activeTriggers) {
            if (!this.canRunTrigger(t2, mode, runParams)) continue;
            trigger.add(t2);
        }
        return trigger;
    }

    public void onPlayerLost(Player p) {
        ArrayList<Trigger> lost = new ArrayList<Trigger>(this.delayedTriggers);
        for (Trigger t2 : lost) {
            if (!t2.getHostCard().getOwner().equals(p)) continue;
            this.delayedTriggers.remove(t2);
        }
        this.runWaitingTriggers();
    }
}

