/*
 * Decompiled with CFR 0.152.
 */
package forge.game.trigger;

import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.keyword.Keyword;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.Trigger;
import forge.util.Localizer;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;

public class TriggerExiled
extends Trigger {
    public TriggerExiled(Map<String, String> params, Card host, boolean intrinsic) {
        super(params, host, intrinsic);
    }

    @Override
    public final boolean performTest(Map<AbilityKey, Object> runParams) {
        SpellAbility cause = (SpellAbility)runParams.get((Object)AbilityKey.Cause);
        if (this.hasParam("Origin") && !this.getParam("Origin").equals("Any")) {
            if (this.getParam("Origin") == null) {
                return false;
            }
            if (!ArrayUtils.contains(this.getParam("Origin").split(","), runParams.get((Object)AbilityKey.Origin))) {
                return false;
            }
        }
        if (!this.matchesValidParam("ValidCard", runParams.get((Object)AbilityKey.Card))) {
            return false;
        }
        if (!this.matchesValidParam("ValidCause", cause)) {
            return false;
        }
        if (this.hasParam("WhileKeyword") && !this.whileKeywordCheck(this.getParam("WhileKeyword"), runParams)) {
            return false;
        }
        return !this.hasParam("Madness") || cause != null && cause.isKeyword(Keyword.MADNESS);
    }

    @Override
    public final void setTriggeringObjects(SpellAbility sa, Map<AbilityKey, Object> runParams) {
        sa.setTriggeringObjectsFrom(runParams, AbilityKey.Card);
    }

    @Override
    public String getImportantStackObjects(SpellAbility sa) {
        return Localizer.getInstance().getMessage("lblExiled", new Object[0]) + ": " + sa.getTriggeringObject(AbilityKey.Card);
    }
}

