/*
 * Decompiled with CFR 0.152.
 */
package forge.game.trigger;

import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.Trigger;
import forge.util.Localizer;
import java.util.Map;

public class TriggerExcessDamage
extends Trigger {
    public TriggerExcessDamage(Map<String, String> params, Card host, boolean intrinsic) {
        super(params, host, intrinsic);
    }

    @Override
    public final boolean performTest(Map<AbilityKey, Object> runParams) {
        if (!this.matchesValidParam("ValidTarget", runParams.get((Object)AbilityKey.DamageTarget))) {
            return false;
        }
        return !this.hasParam("CombatDamage") || this.getParam("CombatDamage").equalsIgnoreCase("True") == ((Boolean)runParams.get((Object)AbilityKey.IsCombatDamage)).booleanValue();
    }

    @Override
    public final void setTriggeringObjects(SpellAbility sa, Map<AbilityKey, Object> runParams) {
        sa.setTriggeringObject(AbilityKey.Target, runParams.get((Object)AbilityKey.DamageTarget));
        sa.setTriggeringObjectsFrom(runParams, AbilityKey.DamageAmount);
    }

    @Override
    public String getImportantStackObjects(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        sb.append(Localizer.getInstance().getMessage("lblDamaged", new Object[0])).append(": ").append(sa.getTriggeringObject(AbilityKey.Target)).append(", ");
        sb.append(Localizer.getInstance().getMessage("lblAmount", new Object[0])).append(": ").append(sa.getTriggeringObject(AbilityKey.DamageAmount));
        return sb.toString();
    }
}

