/*
 * Decompiled with CFR 0.152.
 */
package forge.game.trigger;

import forge.game.Game;
import forge.game.GameStage;
import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.Trigger;
import forge.util.Localizer;
import java.util.Map;

public class TriggerDrawn
extends Trigger {
    public TriggerDrawn(Map<String, String> params, Card host, boolean intrinsic) {
        super(params, host, intrinsic);
    }

    @Override
    public final boolean performTest(Map<AbilityKey, Object> runParams) {
        Game game = this.getHostCard().getGame();
        int number = (Integer)runParams.get((Object)AbilityKey.Number);
        if (!this.matchesValidParam("ValidCard", runParams.get((Object)AbilityKey.Card))) {
            return false;
        }
        if (!this.matchesValidParam("ValidPlayer", runParams.get((Object)AbilityKey.Player))) {
            return false;
        }
        if (this.hasParam("Number") && number != Integer.parseInt(this.getParam("Number"))) {
            return false;
        }
        if (this.hasParam("FirstCardInDrawStep")) {
            Player p = (Player)runParams.get((Object)AbilityKey.Player);
            if (this.getParam("FirstCardInDrawStep").equals("True") ? !game.getPhaseHandler().is(PhaseType.DRAW, p) || p.numDrawnThisDrawStep() > 1 : p.numDrawnThisDrawStep() == 1 && game.getPhaseHandler().is(PhaseType.DRAW, p)) {
                return false;
            }
        }
        if (game.getAge() == GameStage.Mulligan) {
            return false;
        }
        if (runParams.containsKey((Object)AbilityKey.CanReveal)) {
            boolean canReveal = (Boolean)runParams.get((Object)AbilityKey.CanReveal);
            if (this.hasParam("ForReveal") ? !canReveal : canReveal) {
                return false;
            }
        }
        return true;
    }

    @Override
    public final void setTriggeringObjects(SpellAbility sa, Map<AbilityKey, Object> runParams) {
        sa.setTriggeringObjectsFrom(runParams, AbilityKey.Card, AbilityKey.Player);
    }

    @Override
    public String getImportantStackObjects(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        sb.append(Localizer.getInstance().getMessage("lblPlayer", new Object[0])).append(": ").append(sa.getTriggeringObject(AbilityKey.Player));
        return sb.toString();
    }
}

