/*
 * Decompiled with CFR 0.152.
 */
package forge.game.trigger;

import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.Trigger;
import forge.util.Expressions;
import forge.util.Localizer;
import java.util.Map;

public class TriggerDamagePreventedOnce
extends Trigger {
    public TriggerDamagePreventedOnce(Map<String, String> params, Card host, boolean intrinsic) {
        super(params, host, intrinsic);
    }

    @Override
    public final boolean performTest(Map<AbilityKey, Object> runParams) {
        if (!this.matchesValidParam("ValidTarget", runParams.get((Object)AbilityKey.DamageTarget))) {
            return false;
        }
        if (this.hasParam("CombatDamage") && this.getParam("CombatDamage").equals("True") != ((Boolean)runParams.get((Object)AbilityKey.IsCombatDamage)).booleanValue()) {
            return false;
        }
        if (this.hasParam("DamageAmount")) {
            String fullParam = this.getParam("DamageAmount");
            String operator = fullParam.substring(0, 2);
            int operand = Integer.parseInt(fullParam.substring(2));
            int actualAmount = (Integer)runParams.get((Object)AbilityKey.DamageAmount);
            if (!Expressions.compare(actualAmount, operator, operand)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public final void setTriggeringObjects(SpellAbility sa, Map<AbilityKey, Object> runParams) {
        sa.setTriggeringObject(AbilityKey.Target, runParams.get((Object)AbilityKey.DamageTarget));
        sa.setTriggeringObjectsFrom(runParams, AbilityKey.DamageAmount);
    }

    @Override
    public String getImportantStackObjects(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        sb.append(Localizer.getInstance().getMessage("lblDamageTarget", new Object[0])).append(": ").append(sa.getTriggeringObject(AbilityKey.Target)).append(", ");
        sb.append(Localizer.getInstance().getMessage("lblAmount", new Object[0])).append(": ").append(sa.getTriggeringObject(AbilityKey.DamageAmount));
        return sb.toString();
    }
}

