/*
 * Decompiled with CFR 0.152.
 */
package forge.game.trigger;

import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.card.CardDamageMap;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.Trigger;
import forge.util.Localizer;
import java.util.Map;

public class TriggerDamageAll
extends Trigger {
    public TriggerDamageAll(Map<String, String> params, Card host, boolean intrinsic) {
        super(params, host, intrinsic);
    }

    @Override
    public boolean performTest(Map<AbilityKey, Object> runParams) {
        if (this.hasParam("CombatDamage") && this.getParam("CombatDamage").equals("True") != ((Boolean)runParams.get((Object)AbilityKey.IsCombatDamage)).booleanValue()) {
            return false;
        }
        CardDamageMap table = (CardDamageMap)runParams.get((Object)AbilityKey.DamageMap);
        return !table.filteredMap(this.getParam("ValidSource"), this.getParam("ValidTarget"), this.getHostCard(), this).isEmpty();
    }

    @Override
    public void setTriggeringObjects(SpellAbility sa, Map<AbilityKey, Object> runParams) {
        CardDamageMap table = (CardDamageMap)runParams.get((Object)AbilityKey.DamageMap);
        table = table.filteredMap(this.getParam("ValidSource"), this.getParam("ValidTarget"), this.getHostCard(), this);
        sa.setTriggeringObject(AbilityKey.DamageAmount, table.totalAmount());
        sa.setTriggeringObject(AbilityKey.Sources, table.rowKeySet());
        sa.setTriggeringObject(AbilityKey.Targets, table.columnKeySet());
    }

    @Override
    public String getImportantStackObjects(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        sb.append(Localizer.getInstance().getMessage("lblDamageSource", new Object[0])).append(": ").append(sa.getTriggeringObject(AbilityKey.Sources)).append(", ");
        sb.append(Localizer.getInstance().getMessage("lblDamaged", new Object[0])).append(": ").append(sa.getTriggeringObject(AbilityKey.Targets)).append(", ");
        sb.append(Localizer.getInstance().getMessage("lblAmount", new Object[0])).append(": ").append(sa.getTriggeringObject(AbilityKey.DamageAmount));
        return sb.toString();
    }
}

