/*
 * Decompiled with CFR 0.152.
 */
package forge.game.trigger;

import com.google.common.collect.Lists;
import forge.game.GameEntity;
import forge.game.GameEntityCounterTable;
import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.card.CounterType;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.Trigger;
import forge.util.Localizer;
import java.util.Map;

public class TriggerCounterAddedAll
extends Trigger {
    public TriggerCounterAddedAll(Map<String, String> params, Card host, boolean intrinsic) {
        super(params, host, intrinsic);
    }

    @Override
    public boolean performTest(Map<AbilityKey, Object> runParams) {
        GameEntityCounterTable table = (GameEntityCounterTable)runParams.get((Object)AbilityKey.Objects);
        return !this.filterTable(table).isEmpty();
    }

    @Override
    public void setTriggeringObjects(SpellAbility sa, Map<AbilityKey, Object> runParams) {
        GameEntityCounterTable table = (GameEntityCounterTable)runParams.get((Object)AbilityKey.Objects);
        Map<GameEntity, Integer> all = this.filterTable(table);
        int amount = 0;
        for (Integer v : all.values()) {
            amount += v.intValue();
        }
        sa.setTriggeringObject(AbilityKey.Objects, Lists.newArrayList(all.keySet()));
        sa.setTriggeringObject(AbilityKey.Amount, amount);
    }

    @Override
    public String getImportantStackObjects(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        sb.append(Localizer.getInstance().getMessage("lblAmount", new Object[0])).append(": ").append(sa.getTriggeringObject(AbilityKey.Amount));
        return sb.toString();
    }

    private Map<GameEntity, Integer> filterTable(GameEntityCounterTable table) {
        CounterType counterType = CounterType.getType(this.getParam("CounterType"));
        String valid = this.getParam("Valid");
        return table.filterTable(counterType, valid, this.getHostCard(), this);
    }
}

