/*
 * Decompiled with CFR 0.152.
 */
package forge.game.trigger;

import com.google.common.collect.Iterables;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardUtil;
import forge.game.card.CardZoneTable;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.Trigger;
import forge.game.zone.ZoneType;
import forge.util.Expressions;
import forge.util.Localizer;
import java.util.List;
import java.util.Map;

public class TriggerChangesZoneAll
extends Trigger {
    public TriggerChangesZoneAll(Map<String, String> params, Card host, boolean intrinsic) {
        super(params, host, intrinsic);
    }

    @Override
    public boolean performTest(Map<AbilityKey, Object> runParams) {
        CardZoneTable table = (CardZoneTable)runParams.get((Object)AbilityKey.Cards);
        if (Iterables.contains(this.getActiveZone(), (Object)ZoneType.Battlefield) && "Graveyard".equals(this.getParam("Origin")) && !table.getLastStateBattlefield().contains(this.getHostCard())) {
            return false;
        }
        if (this.hasParam("FirstTime")) {
            List<Card> entered = CardUtil.getThisTurnEntered(ZoneType.smartValueOf(this.getParam("Destination")), null, this.getParam("ValidCards"), this.getHostCard(), this, this.getHostCard().getController());
            entered.removeAll(this.filterCards(table));
            if (!entered.isEmpty()) {
                return false;
            }
        }
        if (!this.matchesValidParam("ValidCause", runParams.get((Object)AbilityKey.Cause))) {
            return false;
        }
        if (this.hasParam("ValidAmount")) {
            int right = AbilityUtils.calculateAmount(this.hostCard, this.getParam("ValidAmount").substring(2), this);
            if (!Expressions.compare(this.filterCards(table).size(), this.getParam("ValidAmount").substring(0, 2), right)) {
                return false;
            }
        }
        return !this.filterCards(table).isEmpty();
    }

    @Override
    public void setTriggeringObjects(SpellAbility sa, Map<AbilityKey, Object> runParams) {
        CardZoneTable table = (CardZoneTable)runParams.get((Object)AbilityKey.Cards);
        CardCollection allCards = this.filterCards(table);
        sa.setTriggeringObject(AbilityKey.Cards, allCards);
        sa.setTriggeringObject(AbilityKey.Amount, allCards.size());
        sa.setTriggeringObjectsFrom(runParams, AbilityKey.Cause);
    }

    @Override
    public String getImportantStackObjects(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        sb.append(Localizer.getInstance().getMessage("lblAmount", new Object[0])).append(": ").append(sa.getTriggeringObject(AbilityKey.Amount));
        return sb.toString();
    }

    private CardCollection filterCards(CardZoneTable table) {
        List<ZoneType> destination = null;
        List<ZoneType> origin = null;
        if (this.hasParam("Destination") && !this.getParam("Destination").equals("Any")) {
            destination = ZoneType.listValueOf(this.getParam("Destination"));
        }
        if (this.hasParam("Origin") && !this.getParam("Origin").equals("Any")) {
            origin = ZoneType.listValueOf(this.getParam("Origin"));
        }
        String valid = this.getParam("ValidCards");
        return table.filterCards(origin, destination, valid, this.getHostCard(), this);
    }
}

