/*
 * Decompiled with CFR 0.152.
 */
package forge.game.trigger;

import forge.game.GameEntity;
import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.Trigger;
import forge.util.Localizer;
import java.util.List;
import java.util.Map;

public class TriggerAttacks
extends Trigger {
    public TriggerAttacks(Map<String, String> params, Card host, boolean intrinsic) {
        super(params, host, intrinsic);
    }

    @Override
    public final boolean performTest(Map<AbilityKey, Object> runParams) {
        Player defendingPlayer;
        Card attacker;
        if (!this.matchesValidParam("ValidCard", runParams.get((Object)AbilityKey.Attacker))) {
            return false;
        }
        if (!this.matchesValidParam("Attacked", runParams.get((Object)AbilityKey.Attacked))) {
            return false;
        }
        if (this.hasParam("Alone")) {
            List otherAttackers = (List)runParams.get((Object)AbilityKey.OtherAttackers);
            if (otherAttackers == null) {
                return false;
            }
            if (this.getParam("Alone").equals("True") ? otherAttackers.size() != 0 : otherAttackers.size() == 0) {
                return false;
            }
        }
        if (this.hasParam("FirstAttack") && (attacker = (Card)runParams.get((Object)AbilityKey.Attacker)).getDamageHistory().getCreatureAttacksThisTurn() > 1) {
            return false;
        }
        if (this.hasParam("DefendingPlayerPoisoned") && (defendingPlayer = (Player)runParams.get((Object)AbilityKey.DefendingPlayer)).getPoisonCounters() == 0) {
            return false;
        }
        if (this.hasParam("AttackDifferentPlayers")) {
            GameEntity attacked = (GameEntity)runParams.get((Object)AbilityKey.Attacked);
            boolean found = false;
            if (attacked instanceof Player) {
                List list = (List)runParams.get((Object)AbilityKey.Defenders);
                for (GameEntity e : list) {
                    if (!(e instanceof Player) || e.equals(attacked)) continue;
                    found = true;
                    break;
                }
            }
            if (!found) {
                return false;
            }
        }
        return true;
    }

    @Override
    public final void setTriggeringObjects(SpellAbility sa, Map<AbilityKey, Object> runParams) {
        sa.setTriggeringObject(AbilityKey.Defender, runParams.get((Object)AbilityKey.Attacked));
        sa.setTriggeringObjectsFrom(runParams, AbilityKey.Attacker, AbilityKey.Defenders, AbilityKey.DefendingPlayer);
    }

    @Override
    public String getImportantStackObjects(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        sb.append(Localizer.getInstance().getMessage("lblAttacker", new Object[0])).append(": ").append(sa.getTriggeringObject(AbilityKey.Attacker));
        return sb.toString();
    }
}

