/*
 * Decompiled with CFR 0.152.
 */
package forge.game.trigger;

import com.google.common.collect.Iterables;
import forge.game.CardTraitBase;
import forge.game.GameObject;
import forge.game.GameObjectPredicates;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.Trigger;
import forge.util.Expressions;
import forge.util.Localizer;
import forge.util.collect.FCollection;
import java.util.Map;

public class TriggerAttackersDeclared
extends Trigger {
    public TriggerAttackersDeclared(Map<String, String> params, Card host, boolean intrinsic) {
        super(params, host, intrinsic);
    }

    @Override
    public final boolean performTest(Map<AbilityKey, Object> runParams) {
        if (!this.matchesValidParam("AttackingPlayer", runParams.get((Object)AbilityKey.AttackingPlayer))) {
            return false;
        }
        if (!this.matchesValidParam("AttackedTarget", runParams.get((Object)AbilityKey.AttackedTarget))) {
            return false;
        }
        if (this.hasParam("ValidAttackers")) {
            int amount;
            String param = this.getParamOrDefault("ValidAttackersAmount", "GE1");
            int attackers = CardLists.getValidCardCount((CardCollection)runParams.get((Object)AbilityKey.Attackers), this.getParam("ValidAttackers"), this.getHostCard().getController(), this.getHostCard(), this);
            if (!Expressions.compare(attackers, param, amount = AbilityUtils.calculateAmount(this.getHostCard(), param.substring(2), this))) {
                return false;
            }
        }
        return true;
    }

    @Override
    public final void setTriggeringObjects(SpellAbility sa, Map<AbilityKey, Object> runParams) {
        Iterable<GameObject> attackedTarget = (Iterable<GameObject>)runParams.get((Object)AbilityKey.AttackedTarget);
        CardCollection attackers = (CardCollection)runParams.get((Object)AbilityKey.Attackers);
        if (this.hasParam("ValidAttackers")) {
            attackers = CardLists.getValidCards((Iterable<Card>)attackers, this.getParam("ValidAttackers"), this.getHostCard().getController(), this.getHostCard(), (CardTraitBase)this);
            FCollection<GameObject> defenders = new FCollection<GameObject>();
            for (Card attacker : attackers) {
                defenders.add(attacker.getGame().getCombat().getDefenderByAttacker(attacker));
            }
            attackedTarget = defenders;
        }
        sa.setTriggeringObject(AbilityKey.Attackers, attackers);
        if (this.hasParam("AttackedTarget")) {
            attackedTarget = Iterables.filter(attackedTarget, GameObjectPredicates.restriction(this.getParam("AttackedTarget").split(","), this.getHostCard().getController(), this.getHostCard(), this));
        }
        sa.setTriggeringObject(AbilityKey.AttackedTarget, attackedTarget);
        sa.setTriggeringObjectsFrom(runParams, AbilityKey.AttackingPlayer);
    }

    @Override
    public String getImportantStackObjects(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        sb.append(Localizer.getInstance().getMessage("lblNumberAttackers", new Object[0])).append(": ").append(sa.getTriggeringObject(AbilityKey.Attackers));
        return sb.toString();
    }
}

