/*
 * Decompiled with CFR 0.152.
 */
package forge.game.trigger;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import forge.game.Game;
import forge.game.GameEntity;
import forge.game.GameStage;
import forge.game.IHasSVars;
import forge.game.TriggerReplacementBase;
import forge.game.ability.AbilityFactory;
import forge.game.ability.AbilityKey;
import forge.game.ability.ApiType;
import forge.game.ability.effects.CharmEffect;
import forge.game.card.Card;
import forge.game.card.CardState;
import forge.game.cost.IndividualCostPaymentInstance;
import forge.game.keyword.Keyword;
import forge.game.phase.PhaseHandler;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.TriggerType;
import forge.game.trigger.WrappedAbility;
import forge.game.zone.CostPaymentStack;
import forge.game.zone.ZoneType;
import forge.util.CardTranslation;
import forge.util.ITranslatable;
import forge.util.Lang;
import forge.util.TextUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public abstract class Trigger
extends TriggerReplacementBase {
    private static int maxId = 0;
    private int id;
    private TriggerType mode;
    private List<Object> triggerRemembered = Lists.newArrayList();
    private Set<PhaseType> validPhases;
    private SpellAbility spawningAbility;

    private static int nextId() {
        return ++maxId;
    }

    public static void resetIDs() {
        maxId = 50000;
    }

    public Trigger(Map<String, String> params, Card host, boolean intrinsic) {
        String triggerPhases;
        this.id = Trigger.nextId();
        this.intrinsic = intrinsic;
        this.originalMapParams.putAll(params);
        this.mapParams.putAll(params);
        this.setHostCard(host);
        String triggerZones = this.getParam("TriggerZones");
        if (null != triggerZones) {
            this.setActiveZone(EnumSet.copyOf(ZoneType.listValueOf(triggerZones)));
        }
        if (null != (triggerPhases = this.getParam("Phase"))) {
            this.setTriggerPhases(PhaseType.parseRange(triggerPhases));
        }
    }

    public final String toString() {
        return this.toString(false);
    }

    public String toString(boolean active) {
        if (this.hasParam("TriggerDescription") && !this.isSuppressed()) {
            StringBuilder sb = new StringBuilder();
            ITranslatable nameSource = this.getHostName(this);
            String desc = this.getParam("TriggerDescription");
            if (!desc.contains("ABILITY")) {
                desc = CardTranslation.translateSingleDescriptionText(this.getParam("TriggerDescription"), nameSource);
                String translatedName = CardTranslation.getTranslatedName(nameSource);
                desc = TextUtil.fastReplace(desc, "CARDNAME", translatedName);
                if ((desc = TextUtil.fastReplace(desc, "NICKNAME", Lang.getInstance().getNickName(translatedName))).contains("ORIGINALHOST") && this.getOriginalHost() != null) {
                    desc = TextUtil.fastReplace(desc, "ORIGINALHOST", this.getOriginalHost().getName());
                }
            }
            if (this.getHostCard().getEffectSource() != null) {
                desc = active ? TextUtil.fastReplace(desc, "EFFECTSOURCE", this.getHostCard().getEffectSource().toString()) : TextUtil.fastReplace(desc, "EFFECTSOURCE", this.getHostCard().getEffectSource().getName());
            }
            sb.append(desc);
            if (!this.triggerRemembered.isEmpty()) {
                sb.append(" (").append(this.triggerRemembered).append(")");
            }
            return sb.toString();
        }
        return "";
    }

    public final String replaceAbilityText(String desc, CardState state) {
        if (!desc.contains("ABILITY")) {
            return desc;
        }
        SpellAbility sa = this.ensureAbility();
        return this.replaceAbilityText(desc, sa);
    }

    public final String replaceAbilityText(String desc, SpellAbility sa) {
        return this.replaceAbilityText(desc, sa, false);
    }

    public final String replaceAbilityText(String desc, SpellAbility sa, boolean forStack) {
        String result = desc;
        if (!result.contains("ABILITY")) {
            return result;
        }
        if (sa == null) {
            sa = this.getOverridingAbility();
        }
        if (sa != null) {
            WrappedAbility wa;
            String saDesc = "";
            boolean digMore = true;
            if (sa.isWrapper() && ApiType.Charm.equals((Object)(sa = (wa = (WrappedAbility)sa).getWrappedAbility()).getApi())) {
                saDesc = sa.getStackDescription();
                digMore = false;
            }
            if (digMore) {
                SpellAbility trigSA = sa;
                while (trigSA != null) {
                    ApiType api = trigSA.getApi();
                    if (ApiType.Charm.equals((Object)api)) {
                        saDesc = CharmEffect.makeFormatedDescription(trigSA, !forStack);
                        break;
                    }
                    if (ApiType.ImmediateTrigger.equals((Object)api) || ApiType.DelayedTrigger.equals((Object)api)) {
                        trigSA = trigSA.getAdditionalAbility("Execute");
                        continue;
                    }
                    trigSA = trigSA.getSubAbility();
                }
            }
            if (saDesc.isEmpty()) {
                saDesc = sa.toString();
            }
            if (!(saDesc = saDesc.trim()).isEmpty()) {
                if (!saDesc.startsWith(sa.getHostCard().getName())) {
                    saDesc = saDesc.substring(0, 1).toLowerCase() + saDesc.substring(1);
                }
                if (saDesc.contains("ORIGINALHOST") && sa.getOriginalHost() != null) {
                    saDesc = TextUtil.fastReplace(saDesc, "ORIGINALHOST", sa.getOriginalHost().getName());
                }
            } else {
                saDesc = "<take no action>";
            }
            result = TextUtil.fastReplace(result, "ABILITY", saDesc);
            result = CardTranslation.translateMultipleDescriptionText(result, sa.getHostCard());
            String translatedName = CardTranslation.getTranslatedName(sa.getHostCard());
            result = TextUtil.fastReplace(result, "CARDNAME", translatedName);
            result = TextUtil.fastReplace(result, "NICKNAME", Lang.getInstance().getNickName(translatedName));
        }
        return result;
    }

    public final boolean phasesCheck(Game game) {
        PhaseHandler phaseHandler = game.getPhaseHandler();
        if (null != this.validPhases) {
            if (!this.validPhases.contains((Object)phaseHandler.getPhase())) {
                return false;
            }
            if (this.hasParam("PhaseCount") && phaseHandler.getNumMain() + 1 != 2) {
                return false;
            }
        }
        if (this.hasParam("PlayerTurn") && !phaseHandler.isPlayerTurn(this.getHostCard().getController())) {
            return false;
        }
        if (this.hasParam("NotPlayerTurn") && phaseHandler.isPlayerTurn(this.getHostCard().getController())) {
            return false;
        }
        if (this.hasParam("OpponentTurn") && !this.getHostCard().getController().isOpponentOf(phaseHandler.getPlayerTurn())) {
            return false;
        }
        if (this.hasParam("FirstUpkeep") && !phaseHandler.isFirstUpkeep()) {
            return false;
        }
        if (this.hasParam("FirstUpkeepThisGame") && !phaseHandler.isFirstUpkeepThisGame()) {
            return false;
        }
        if (this.hasParam("FirstCombat") && !phaseHandler.isFirstCombat()) {
            return false;
        }
        if (this.hasParam("TurnCount")) {
            int turn = Integer.parseInt(this.getParam("TurnCount"));
            if (phaseHandler.getTurn() != turn) {
                return false;
            }
        }
        return true;
    }

    public final boolean requirementsCheck(Game game) {
        if (this.hasParam("APlayerHasMoreLifeThanEachOther")) {
            int highestLife = Integer.MIN_VALUE;
            ArrayList<Player> healthiest = new ArrayList<Player>();
            for (Player p : game.getPlayers()) {
                if (p.getLife() > highestLife) {
                    healthiest.clear();
                    highestLife = p.getLife();
                    healthiest.add(p);
                    continue;
                }
                if (p.getLife() != highestLife) continue;
                highestLife = p.getLife();
                healthiest.add(p);
            }
            if (healthiest.size() != 1) {
                return false;
            }
        }
        if (this.hasParam("APlayerHasMostCardsInHand")) {
            int largestHand = 0;
            ArrayList<Player> withLargestHand = new ArrayList<Player>();
            for (Player p : game.getPlayers()) {
                if (p.getCardsIn(ZoneType.Hand).size() > largestHand) {
                    withLargestHand.clear();
                    largestHand = p.getCardsIn(ZoneType.Hand).size();
                    withLargestHand.add(p);
                    continue;
                }
                if (p.getCardsIn(ZoneType.Hand).size() != largestHand) continue;
                largestHand = p.getCardsIn(ZoneType.Hand).size();
                withLargestHand.add(p);
            }
            if (withLargestHand.size() != 1) {
                return false;
            }
        }
        if (this.getHostCard().getController() == null || game.getAge() != GameStage.Play && game.getAge() != GameStage.RestartedByKarn || !this.meetsCommonRequirements(this.mapParams)) {
            return false;
        }
        return this.checkResolvedLimit(this.getHostCard().getController());
    }

    public boolean checkResolvedLimit(Player activator) {
        return !this.hasParam("ResolvedLimit") || Collections.frequency(this.getHostCard().getAbilityResolvedThisTurnActivators(this.getOverridingAbility()), activator) < Integer.parseInt(this.getParam("ResolvedLimit"));
    }

    public boolean checkActivationLimit() {
        if (this.hasParam("ActivationLimit") && this.getActivationsThisTurn() >= Integer.parseInt(this.getParam("ActivationLimit"))) {
            return false;
        }
        return !this.hasParam("GameActivationLimit") || this.getActivationsThisGame() < Integer.parseInt(this.getParam("GameActivationLimit"));
    }

    public boolean meetsRequirementsOnTriggeredObjects(Game game, Map<AbilityKey, Object> runParams) {
        GameEntity attacked;
        SpellAbility trigSA;
        String condition = this.getParam("Condition");
        if (this.isKeyword(Keyword.EVOLVE) || "Evolve".equals(condition)) {
            Card moved = (Card)runParams.get((Object)AbilityKey.Card);
            if (moved == null) {
                return false;
            }
            if (!moved.isCreature() || !this.getHostCard().isCreature()) {
                return false;
            }
            if (moved.getNetPower() <= this.getHostCard().getNetPower() && moved.getNetToughness() <= this.getHostCard().getNetToughness()) {
                return false;
            }
        }
        if ("LifePaid".equals(condition)) {
            trigSA = (SpellAbility)runParams.get((Object)AbilityKey.SpellAbility);
            if (trigSA != null && trigSA.getAmountLifePaid() <= 0) {
                return false;
            }
        } else if ("NoOpponentHasMoreLifeThanAttacked".equals(condition)) {
            attacked = (GameEntity)runParams.get((Object)AbilityKey.Attacked);
            if (attacked == null) {
                attacked = (GameEntity)runParams.get((Object)AbilityKey.Defender);
            }
            if (!(attacked instanceof Player)) {
                return false;
            }
            Player attackedP = (Player)attacked;
            int life = attackedP.getLife();
            boolean found = false;
            for (Player opp : this.getHostCard().getController().getOpponents()) {
                if (opp.equals(attackedP) || opp.getLife() <= life) continue;
                found = true;
                break;
            }
            if (found) {
                return false;
            }
        } else if ("Sacrificed".equals(condition)) {
            trigSA = (SpellAbility)runParams.get((Object)AbilityKey.SpellAbility);
            if (trigSA != null && Iterables.isEmpty(trigSA.getPaidList("Sacrificed"))) {
                return false;
            }
        } else if ("AttackedPlayerWithMostLife".equals(condition)) {
            attacked = (GameEntity)runParams.get((Object)AbilityKey.Attacked);
            if (attacked == null) {
                attacked = (GameEntity)runParams.get((Object)AbilityKey.Defender);
            }
            if (attacked == null || !attacked.isValid("Player.withMostLife", this.getHostCard().getController(), this.getHostCard(), null)) {
                return false;
            }
        } else if ("AttackerHasUnattackedOpp".equals(condition)) {
            Player attacker = (Player)runParams.get((Object)AbilityKey.AttackingPlayer);
            if (game.getCombat().getAttackersAndDefenders().values().containsAll(attacker.getOpponents())) {
                return false;
            }
        }
        return true;
    }

    public final boolean equals(Object o) {
        if (!(o instanceof Trigger)) {
            return false;
        }
        return this.getId() == ((Trigger)o).getId();
    }

    public int hashCode() {
        return Objects.hash(Trigger.class, this.getId());
    }

    public abstract boolean performTest(Map<AbilityKey, Object> var1);

    public abstract void setTriggeringObjects(SpellAbility var1, Map<AbilityKey, Object> var2);

    @Override
    public int getId() {
        return this.id;
    }

    public final void setId(int id) {
        this.id = id;
    }

    public void addRemembered(Object o) {
        this.triggerRemembered.add(o);
    }

    @Override
    public List<Object> getTriggerRemembered() {
        return this.triggerRemembered;
    }

    public TriggerType getMode() {
        return this.mode;
    }

    void setMode(TriggerType triggerType) {
        this.mode = triggerType;
    }

    public final Trigger copy(Card newHost, boolean lki) {
        Trigger copy = (Trigger)this.clone();
        this.copyHelper(copy, newHost);
        if (this.getOverridingAbility() != null) {
            copy.setOverridingAbility(this.getOverridingAbility().copy(newHost, lki));
        }
        if (!lki) {
            copy.setId(Trigger.nextId());
        }
        if (this.validPhases != null) {
            copy.setTriggerPhases(Sets.newEnumSet(this.validPhases, PhaseType.class));
        }
        copy.setActiveZone(this.validHostZones);
        return copy;
    }

    public boolean isStatic() {
        return this.hasParam("Static");
    }

    public void setTriggerPhases(Set<PhaseType> phases) {
        this.validPhases = phases;
    }

    public abstract String getImportantStackObjects(SpellAbility var1);

    public SpellAbility getSpawningAbility() {
        return this.spawningAbility;
    }

    public void setSpawningAbility(SpellAbility ability) {
        this.spawningAbility = ability;
    }

    public int getActivationsThisTurn() {
        return this.hostCard.getAbilityActivatedThisTurn(this.getOverridingAbility());
    }

    public int getActivationsThisGame() {
        return this.hostCard.getAbilityActivatedThisGame(this.getOverridingAbility());
    }

    public void triggerRun() {
        if (this.getOverridingAbility() != null) {
            this.hostCard.addAbilityActivated(this.getOverridingAbility());
        }
    }

    public final Object clone() {
        try {
            return super.clone();
        }
        catch (Exception ex) {
            throw new RuntimeException("Trigger : clone() error, " + ex);
        }
    }

    public SpellAbility ensureAbility(IHasSVars sVarHolder) {
        SpellAbility sa = this.getOverridingAbility();
        if (sa == null && this.hasParam("Execute")) {
            sa = AbilityFactory.getAbility(this.getHostCard(), this.getParam("Execute"), sVarHolder);
            this.setOverridingAbility(sa);
        }
        return sa;
    }

    @Override
    public SpellAbility ensureAbility() {
        return this.ensureAbility(this);
    }

    @Override
    public void setOverridingAbility(SpellAbility overridingAbility0) {
        super.setOverridingAbility(overridingAbility0);
        overridingAbility0.setTrigger(this);
    }

    boolean whileKeywordCheck(String param, Map<AbilityKey, Object> runParams) {
        IndividualCostPaymentInstance currentPayment = (IndividualCostPaymentInstance)runParams.get((Object)AbilityKey.IndividualCostPaymentInstance);
        if (currentPayment != null && this.matchesValidParam(param, currentPayment.getPayment().getAbility())) {
            return true;
        }
        CostPaymentStack stack = (CostPaymentStack)runParams.get((Object)AbilityKey.CostStack);
        for (IndividualCostPaymentInstance individual : stack) {
            if (!this.matchesValidParam(param, individual.getPayment().getAbility())) continue;
            return true;
        }
        return false;
    }

    public boolean isChapter() {
        return this.hasParam("Chapter");
    }

    public Integer getChapter() {
        if (!this.isChapter()) {
            return null;
        }
        return Integer.valueOf(this.getParam("Chapter"));
    }

    public boolean isLastChapter() {
        return this.isChapter() && this.getChapter().intValue() == this.getCardState().getFinalChapterNr();
    }
}

