/*
 * Decompiled with CFR 0.152.
 */
package forge.game.staticability;

import com.google.common.collect.Sets;
import forge.card.MagicColor;
import forge.card.mana.ManaAtom;
import forge.game.Game;
import forge.game.card.Card;
import forge.game.player.Player;
import forge.game.staticability.StaticAbility;
import forge.game.zone.ZoneType;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class StaticAbilityUnspentMana {
    static String MODE_UNSPENT = "UnspentMana";
    static String MODE_BURN = "ManaBurn";

    public static Collection<Byte> getManaToKeep(Player player) {
        Game game = player.getGame();
        HashSet<Byte> result = Sets.newHashSet();
        for (Card ca : game.getCardsIn(ZoneType.STATIC_ABILITIES_SOURCE_ZONES)) {
            for (StaticAbility stAb : ca.getStaticAbilities()) {
                if (!stAb.checkConditions(MODE_UNSPENT)) continue;
                StaticAbilityUnspentMana.applyUnspentManaAbility(stAb, player, result);
            }
        }
        return result;
    }

    public static boolean hasManaBurn(Player player) {
        Game game = player.getGame();
        for (Card ca : game.getCardsIn(ZoneType.STATIC_ABILITIES_SOURCE_ZONES)) {
            for (StaticAbility stAb : ca.getStaticAbilities()) {
                if (!stAb.checkConditions(MODE_BURN)) continue;
                return stAb.matchesValidParam("ValidPlayer", player);
            }
        }
        return false;
    }

    private static void applyUnspentManaAbility(StaticAbility stAb, Player player, Set<Byte> result) {
        if (!stAb.matchesValidParam("ValidPlayer", player)) {
            return;
        }
        if (!stAb.hasParam("ManaType")) {
            for (byte b : ManaAtom.MANATYPES) {
                result.add(b);
            }
        } else {
            result.add(MagicColor.fromName(stAb.getParam("ManaType")));
        }
    }
}

