/*
 * Decompiled with CFR 0.152.
 */
package forge.game.staticability;

import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.spellability.SpellAbility;
import forge.game.staticability.StaticAbility;
import forge.game.zone.ZoneType;

public class StaticAbilityNumLoyaltyAct {
    static String MODE = "NumLoyaltyAct";

    public static boolean limitIncrease(Card card) {
        for (Card ca : card.getGame().getCardsIn(ZoneType.STATIC_ABILITIES_SOURCE_ZONES)) {
            for (StaticAbility stAb : ca.getStaticAbilities()) {
                if (!stAb.checkConditions(MODE) || !StaticAbilityNumLoyaltyAct.applyLimitIncrease(stAb, card)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean applyLimitIncrease(StaticAbility stAb, Card card) {
        if (!stAb.matchesValidParam("ValidCard", card)) {
            return false;
        }
        return stAb.hasParam("Twice");
    }

    public static int additionalActivations(Card card, SpellAbility sa) {
        int addl = 0;
        for (Card ca : card.getGame().getCardsIn(ZoneType.STATIC_ABILITIES_SOURCE_ZONES)) {
            for (StaticAbility stAb : ca.getStaticAbilities()) {
                if (!stAb.checkConditions(MODE) || !stAb.matchesValidParam("ValidCard", card) || !stAb.hasParam("Additional") || stAb.hasParam("OnlySourceAbs") && !stAb.getHostCard().getEffectSourceAbility().getRootAbility().getOriginalAbility().equals(sa)) continue;
                addl += AbilityUtils.calculateAmount(card, stAb.getParam("Additional"), stAb);
            }
        }
        return addl;
    }
}

