/*
 * Decompiled with CFR 0.152.
 */
package forge.game.staticability;

import forge.game.Game;
import forge.game.card.Card;
import forge.game.card.CounterType;
import forge.game.player.Player;
import forge.game.staticability.StaticAbility;
import forge.game.zone.ZoneType;

public class StaticAbilityCantPutCounter {
    static String MODE = "CantPutCounter";

    public static boolean anyCantPutCounter(Card card, CounterType type) {
        Game game = card.getGame();
        for (Card ca : game.getCardsIn(ZoneType.STATIC_ABILITIES_SOURCE_ZONES)) {
            for (StaticAbility stAb : ca.getStaticAbilities()) {
                if (!stAb.checkConditions(MODE) || !StaticAbilityCantPutCounter.applyCantPutCounter(stAb, card, type)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean anyCantPutCounter(Player player, CounterType type) {
        Game game = player.getGame();
        for (Card ca : game.getCardsIn(ZoneType.STATIC_ABILITIES_SOURCE_ZONES)) {
            for (StaticAbility stAb : ca.getStaticAbilities()) {
                if (!stAb.checkConditions(MODE) || !StaticAbilityCantPutCounter.applyCantPutCounter(stAb, player, type)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean applyCantPutCounter(StaticAbility stAb, Card card, CounterType type) {
        CounterType t2;
        if (stAb.hasParam("CounterType") && (t2 = CounterType.getType(stAb.getParam("CounterType"))) != null && !type.equals(t2)) {
            return false;
        }
        if (!stAb.matchesValidParam("ValidCard", card)) {
            return false;
        }
        return !stAb.hasParam("ValidPlayer");
    }

    public static boolean applyCantPutCounter(StaticAbility stAb, Player player, CounterType type) {
        CounterType t2;
        if (stAb.hasParam("CounterType") && (t2 = CounterType.getType(stAb.getParam("CounterType"))) != null && !type.equals(t2)) {
            return false;
        }
        if (!stAb.matchesValidParam("ValidPlayer", player)) {
            return false;
        }
        return !stAb.hasParam("ValidCard");
    }
}

