/*
 * Decompiled with CFR 0.152.
 */
package forge.game.staticability;

import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.staticability.StaticAbility;
import forge.game.zone.ZoneType;

public class StaticAbilityCantPreventDamage {
    static String MODE = "CantPreventDamage";

    public static boolean cantPreventDamage(Card source, boolean isCombat) {
        CardCollection list = new CardCollection(source.getGame().getCardsIn(ZoneType.STATIC_ABILITIES_SOURCE_ZONES));
        list.add(source);
        for (Card ca : list) {
            for (StaticAbility stAb : ca.getStaticAbilities()) {
                if (!stAb.checkConditions(MODE) || !StaticAbilityCantPreventDamage.applyCantPreventDamage(stAb, source, isCombat)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean applyCantPreventDamage(StaticAbility stAb, Card source, boolean isCombat) {
        if (stAb.hasParam("IsCombat") && stAb.getParam("IsCombat").equals("True") != isCombat) {
            return false;
        }
        return stAb.matchesValidParam("ValidSource", source);
    }
}

