/*
 * Decompiled with CFR 0.152.
 */
package forge.game.staticability;

import forge.game.Game;
import forge.game.card.Card;
import forge.game.staticability.StaticAbility;
import forge.game.zone.ZoneType;

public class StaticAbilityCantPhase {
    static String MODE_CANT_PHASE_IN = "CantPhaseIn";
    static String MODE_CANT_PHASE_OUT = "CantPhaseOut";

    public static boolean cantPhaseIn(Card card) {
        return StaticAbilityCantPhase.cantPhase(card, MODE_CANT_PHASE_IN);
    }

    public static boolean cantPhaseOut(Card card) {
        return StaticAbilityCantPhase.cantPhase(card, MODE_CANT_PHASE_OUT);
    }

    private static boolean cantPhase(Card card, String mode) {
        Game game = card.getGame();
        for (Card ca : game.getCardsIn(ZoneType.STATIC_ABILITIES_SOURCE_ZONES)) {
            for (StaticAbility stAb : ca.getStaticAbilities()) {
                if (!stAb.checkConditions(mode) || !StaticAbilityCantPhase.applyCantPhase(stAb, card)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean applyCantPhase(StaticAbility stAb, Card card) {
        return stAb.matchesValidParam("ValidCard", card);
    }
}

