/*
 * Decompiled with CFR 0.152.
 */
package forge.game.staticability;

import forge.game.Game;
import forge.game.card.Card;
import forge.game.player.Player;
import forge.game.staticability.StaticAbility;
import forge.game.zone.ZoneType;

public class StaticAbilityCantDraw {
    static String MODE = "CantDraw";

    public static boolean canDrawThisAmount(Player player, int startAmount) {
        if (startAmount <= 0) {
            return true;
        }
        return startAmount <= StaticAbilityCantDraw.canDrawAmount(player, startAmount);
    }

    public static int canDrawAmount(Player player, int startAmount) {
        int amount = startAmount;
        if (startAmount <= 0) {
            return 0;
        }
        Game game = player.getGame();
        for (Card ca : game.getCardsIn(ZoneType.STATIC_ABILITIES_SOURCE_ZONES)) {
            for (StaticAbility stAb : ca.getStaticAbilities()) {
                if (!stAb.checkConditions(MODE)) continue;
                amount = StaticAbilityCantDraw.applyCantDrawAmountAbility(stAb, player, amount);
            }
        }
        return amount;
    }

    public static int applyCantDrawAmountAbility(StaticAbility stAb, Player player, int amount) {
        if (!stAb.matchesValidParam("ValidPlayer", player)) {
            return amount;
        }
        int limit = Integer.parseInt(stAb.getParamOrDefault("DrawLimit", "0"));
        int drawn = player.getNumDrawnThisTurn();
        return Math.min(Math.max(limit - drawn, 0), amount);
    }
}

