/*
 * Decompiled with CFR 0.152.
 */
package forge.game.staticability;

import forge.game.Game;
import forge.game.card.Card;
import forge.game.staticability.StaticAbility;
import forge.game.zone.ZoneType;

public class StaticAbilityCantChangeDayTime {
    static String MODE = "CantChangeDayTime";

    public static boolean cantChangeDay(Game game, Boolean value) {
        if (value == null) {
            return false;
        }
        for (Card ca : game.getCardsIn(ZoneType.STATIC_ABILITIES_SOURCE_ZONES)) {
            for (StaticAbility stAb : ca.getStaticAbilities()) {
                if (!stAb.checkConditions(MODE) || !StaticAbilityCantChangeDayTime.cantChangeDayCheck(stAb, value)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean cantChangeDayCheck(StaticAbility stAb, Boolean value) {
        if (stAb.hasParam("NewTime")) {
            switch (stAb.getParam("NewTime")) {
                case "Day": {
                    if (value.booleanValue()) {
                        return false;
                    }
                }
                case "Night": {
                    if (value.booleanValue()) break;
                    return false;
                }
            }
        }
        return true;
    }
}

