/*
 * Decompiled with CFR 0.152.
 */
package forge.game.staticability;

import forge.game.Game;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.card.CardUtil;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.staticability.StaticAbility;
import forge.game.zone.ZoneType;
import java.util.List;

public class StaticAbilityCantBeCast {
    static String CantBeCast = "CantBeCast";
    static String CantBeActivated = "CantBeActivated";
    static String CantPlayLand = "CantPlayLand";

    public static boolean cantBeCastAbility(SpellAbility spell, Card card, Player activator) {
        card.setCastSA(spell);
        Game game = activator.getGame();
        CardCollection allp = new CardCollection(game.getCardsIn(ZoneType.STATIC_ABILITIES_SOURCE_ZONES));
        allp.add(card);
        for (Card ca : allp) {
            for (StaticAbility stAb : ca.getStaticAbilities()) {
                if (!stAb.checkConditions(CantBeCast) || !StaticAbilityCantBeCast.applyCantBeCastAbility(stAb, spell, card, activator)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean cantBeActivatedAbility(SpellAbility spell, Card card, Player activator) {
        if (spell.isTrigger()) {
            return false;
        }
        Game game = activator.getGame();
        for (Card ca : game.getCardsIn(ZoneType.STATIC_ABILITIES_SOURCE_ZONES)) {
            for (StaticAbility stAb : ca.getStaticAbilities()) {
                if (!stAb.checkConditions(CantBeActivated) || !StaticAbilityCantBeCast.applyCantBeActivatedAbility(stAb, spell, card, activator)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean cantPlayLandAbility(SpellAbility spell, Card card, Player activator) {
        Game game = activator.getGame();
        for (Card ca : game.getCardsIn(ZoneType.STATIC_ABILITIES_SOURCE_ZONES)) {
            for (StaticAbility stAb : ca.getStaticAbilities()) {
                if (!stAb.checkConditions(CantPlayLand) || !StaticAbilityCantBeCast.applyCantPlayLandAbility(stAb, card, activator)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean applyCantBeCastAbility(StaticAbility stAb, SpellAbility spell, Card card, Player activator) {
        if (!stAb.matchesValidParam("ValidCard", card)) {
            return false;
        }
        if (!stAb.matchesValidParam("Caster", activator)) {
            return false;
        }
        if (stAb.hasParam("OnlySorcerySpeed") && activator != null && activator.canCastSorcery()) {
            return false;
        }
        if (stAb.hasParam("Origin")) {
            List<ZoneType> src = ZoneType.listValueOf(stAb.getParam("Origin"));
            if (card.getCastFrom() == null || !src.contains((Object)card.getCastFrom().getZoneType())) {
                return false;
            }
        }
        if (stAb.hasParam("cmcGT") && activator != null && (stAb.getParam("cmcGT").equals("Turns") ? card.getCMC() <= activator.getTurn() : card.getCMC() <= CardLists.getType(activator.getCardsIn(ZoneType.Battlefield), stAb.getParam("cmcGT")).size())) {
            return false;
        }
        if (stAb.hasParam("NumLimitEachTurn") && activator != null) {
            int limit = Integer.parseInt(stAb.getParam("NumLimitEachTurn"));
            String valid = stAb.getParamOrDefault("ValidCard", "Card");
            List<Card> thisTurnCast = CardUtil.getThisTurnCast(valid, card, stAb, activator);
            if (CardLists.filterControlledByAsList(thisTurnCast, activator).size() < limit) {
                return false;
            }
        }
        return true;
    }

    public static boolean applyCantBeActivatedAbility(StaticAbility stAb, SpellAbility spellAbility, Card card, Player activator) {
        if (!stAb.matchesValidParam("ValidCard", card)) {
            return false;
        }
        if (!stAb.matchesValidParam("ValidSA", spellAbility)) {
            return false;
        }
        if (stAb.hasParam("AffectedZone") && !card.isInZone(ZoneType.smartValueOf(stAb.getParam("AffectedZone")))) {
            return false;
        }
        return stAb.matchesValidParam("Activator", activator);
    }

    public static boolean applyCantPlayLandAbility(StaticAbility stAb, Card card, Player player) {
        List<ZoneType> src;
        if (!stAb.matchesValidParam("ValidCard", card)) {
            return false;
        }
        if (stAb.hasParam("Origin") && !(src = ZoneType.listValueOf(stAb.getParam("Origin"))).contains((Object)card.getLastKnownZone().getZoneType())) {
            return false;
        }
        return stAb.matchesValidParam("Player", player);
    }
}

