/*
 * Decompiled with CFR 0.152.
 */
package forge.game.staticability;

import forge.game.GameEntity;
import forge.game.card.Card;
import forge.game.staticability.StaticAbility;
import forge.game.zone.ZoneType;

public class StaticAbilityCantAttach {
    static String MODE = "CantAttach";

    public static boolean cantAttach(GameEntity target, Card card, boolean checkSBA) {
        for (Card ca : target.getGame().getCardsIn(ZoneType.STATIC_ABILITIES_SOURCE_ZONES)) {
            for (StaticAbility stAb : ca.getStaticAbilities()) {
                if (!stAb.checkConditions(MODE) || !StaticAbilityCantAttach.applyCantAttachAbility(stAb, card, target, checkSBA)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean applyCantAttachAbility(StaticAbility stAb, Card card, GameEntity target, boolean checkSBA) {
        if (!stAb.matchesValidParam("ValidCard", card)) {
            return false;
        }
        if (!stAb.matchesValidParam("Target", target)) {
            return false;
        }
        if (stAb.hasParam("ValidCardToTarget")) {
            if (!(target instanceof Card)) {
                return false;
            }
            Card tcard = (Card)target;
            if (!stAb.matchesValid(card, stAb.getParam("ValidCardToTarget").split(","), tcard)) {
                return false;
            }
        }
        return !checkSBA && stAb.hasParam("ExceptionSBA") || !stAb.hasParam("Exceptions") || !stAb.matchesValidParam("Exceptions", card);
    }
}

