/*
 * Decompiled with CFR 0.152.
 */
package forge.game.staticability;

import forge.game.Game;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.player.Player;
import forge.game.staticability.StaticAbility;
import forge.game.zone.ZoneType;

public class StaticAbilityBlockRestrict {
    static String MODE = "BlockRestrict";

    public static int blockRestrictNum(Player defender) {
        Game game = defender.getGame();
        int num = Integer.MAX_VALUE;
        for (Card ca : game.getCardsIn(ZoneType.STATIC_ABILITIES_SOURCE_ZONES)) {
            for (StaticAbility stAb : ca.getStaticAbilities()) {
                int stNum;
                if (!stAb.checkConditions(MODE) || !StaticAbilityBlockRestrict.blockRestrict(stAb, defender) || (stNum = AbilityUtils.calculateAmount(stAb.getHostCard(), stAb.getParamOrDefault("MaxBlockers", "1"), stAb)) >= num) continue;
                num = stNum;
            }
        }
        return num;
    }

    public static boolean blockRestrict(StaticAbility stAb, Player defender) {
        return stAb.matchesValidParam("ValidDefender", defender);
    }
}

