/*
 * Decompiled with CFR 0.152.
 */
package forge.game.staticability;

import forge.game.Game;
import forge.game.GameEntity;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.staticability.StaticAbility;
import forge.game.zone.ZoneType;

public class StaticAbilityAttackRestrict {
    static String MODE = "AttackRestrict";

    public static int globalAttackRestrict(Game game) {
        int max = Integer.MAX_VALUE;
        for (Card ca : game.getCardsIn(ZoneType.STATIC_ABILITIES_SOURCE_ZONES)) {
            for (StaticAbility stAb : ca.getStaticAbilities()) {
                int stMax;
                if (!stAb.checkConditions(MODE) || stAb.hasParam("ValidDefender") || (stMax = AbilityUtils.calculateAmount(stAb.getHostCard(), stAb.getParamOrDefault("MaxAttackers", "1"), stAb)) >= max) continue;
                max = stMax;
            }
        }
        return max < Integer.MAX_VALUE ? max : -1;
    }

    public static int attackRestrictNum(GameEntity defender) {
        Game game = defender.getGame();
        int num = Integer.MAX_VALUE;
        for (Card ca : game.getCardsIn(ZoneType.STATIC_ABILITIES_SOURCE_ZONES)) {
            for (StaticAbility stAb : ca.getStaticAbilities()) {
                int stNum;
                if (!stAb.checkConditions(MODE) || !stAb.hasParam("ValidDefender") || !StaticAbilityAttackRestrict.attackRestrict(stAb, defender) || (stNum = AbilityUtils.calculateAmount(stAb.getHostCard(), stAb.getParamOrDefault("MaxAttackers", "1"), stAb)) >= num) continue;
                num = stNum;
            }
        }
        return num < Integer.MAX_VALUE ? num : -1;
    }

    public static boolean attackRestrict(StaticAbility stAb, GameEntity defender) {
        return stAb.matchesValidParam("ValidDefender", defender);
    }
}

