/*
 * Decompiled with CFR 0.152.
 */
package forge.game.staticability;

import com.google.common.collect.Lists;
import forge.card.mana.ManaCostParser;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.cost.Cost;
import forge.game.player.Player;
import forge.game.spellability.OptionalCost;
import forge.game.spellability.SpellAbility;
import forge.game.staticability.StaticAbility;
import forge.game.zone.ZoneType;
import java.util.ArrayList;
import java.util.List;

public class StaticAbilityAlternativeCost {
    static String MODE = "AlternativeCost";

    public static List<SpellAbility> alternativeCosts(SpellAbility sa, Card source, Player pl) {
        ArrayList<SpellAbility> result = Lists.newArrayList();
        CardCollection list = new CardCollection(source);
        list.addAll(source.getGame().getCardsIn(ZoneType.STATIC_ABILITIES_SOURCE_ZONES));
        for (Card ca : list) {
            for (StaticAbility stAb : ca.getStaticAbilities()) {
                if (!stAb.checkConditions(MODE) || !StaticAbilityAlternativeCost.apply(stAb, sa, source, pl)) continue;
                String costTemplate = stAb.getParam("Cost");
                costTemplate = costTemplate.replace("ConvertedManaCost", Integer.toString(source.getCMC()));
                Cost cost = new Cost(costTemplate, sa.isAbility());
                SpellAbility newSA = sa.isAbility() ? sa.copyWithDefinedCost(cost) : sa.copyWithManaCostReplaced(pl, cost);
                newSA.setActivatingPlayer(pl);
                newSA.setBasicSpell(false);
                if (stAb.hasParam("XAlternative")) {
                    newSA.putParam("XAlternative", stAb.getParam("XAlternative"));
                }
                if (stAb.hasParam("Announce")) {
                    newSA.putParam("Announce", stAb.getParam("Announce"));
                }
                if (stAb.hasParam("ManaRestriction")) {
                    newSA.putParam("ManaRestriction", stAb.getParam("ManaRestriction"));
                }
                if (stAb.hasParam("AffectedZone")) {
                    newSA.getRestrictions().setZone(ZoneType.smartValueOf(stAb.getParam("AffectedZone")));
                } else if (!stAb.getHostCard().isImmutable() && stAb.hasParam("EffectZone") && !"All".equals(stAb.getParam("EffectZone"))) {
                    newSA.getRestrictions().setZone(ZoneType.smartValueOf(stAb.getParam("EffectZone")));
                }
                if (stAb.hasParam("StackDescription")) {
                    newSA.putParam("StackDescription", stAb.getParam("StackDescription"));
                }
                StringBuilder sb = new StringBuilder();
                if (sa.isAbility()) {
                    newSA.putParam("CostDesc", stAb.hasParam("CostDesc") ? ManaCostParser.parse(stAb.getParam("CostDesc")) : cost.toSimpleString());
                    sb.append(newSA.getCostDescription());
                }
                if (sa.isSpell()) {
                    sb.append(sa.getDescription());
                    if (source.equals(stAb.getHostCard())) {
                        newSA.addOptionalCost(OptionalCost.AltCost);
                        sb.append(" (" + stAb.getParam("Description") + ") ");
                    } else {
                        sb.append(" (by paying " + cost.toSimpleString() + " instead of its mana cost)");
                    }
                }
                newSA.setDescription(sb.toString());
                result.add(newSA);
            }
        }
        return result;
    }

    private static boolean apply(StaticAbility stAb, SpellAbility sa, Card source, Player pl) {
        if (!stAb.matchesValidParam("ValidSA", sa)) {
            return false;
        }
        if (!stAb.matchesValidParam("ValidCard", source)) {
            return false;
        }
        return stAb.matchesValidParam("ValidPlayer", pl);
    }
}

