/*
 * Decompiled with CFR 0.152.
 */
package forge.game.spellability;

import com.google.common.collect.Lists;
import forge.card.CardType;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.GameEntity;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.SpellAbilityStackInstance;
import forge.game.zone.ZoneType;
import forge.util.TextUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;

public class TargetRestrictions {
    private String[] originalValidTgts;
    private String[] validTgts;
    private String uiPrompt = "";
    private List<ZoneType> tgtZone = Arrays.asList(ZoneType.Battlefield);
    private String saValidTargeting = null;
    private boolean uniqueTargets = false;
    private boolean singleZone = false;
    private boolean forEachPlayer = false;
    private boolean differentControllers = false;
    private boolean differentCMC = false;
    private boolean equalToughness = false;
    private boolean sameController = false;
    private boolean withoutSameCreatureType = false;
    private boolean withSameCreatureType = false;
    private boolean withSameCardType = false;
    private boolean randomTarget = false;
    private boolean randomNumTargets = false;
    private String minTargets;
    private String maxTargets;
    private String maxTotalCMC;
    private String maxTotalPower;
    private boolean bMandatory = false;

    public TargetRestrictions(TargetRestrictions target) {
        this.uiPrompt = target.getVTSelection();
        this.originalValidTgts = target.getValidTgts();
        this.validTgts = (String[])this.originalValidTgts.clone();
        this.minTargets = target.getMinTargets();
        this.maxTargets = target.getMaxTargets();
        this.maxTotalCMC = target.getMaxTotalCMC();
        this.maxTotalPower = target.getMaxTotalPower();
        this.tgtZone = target.getZone();
        this.saValidTargeting = target.getSAValidTargeting();
        this.uniqueTargets = target.isUniqueTargets();
        this.singleZone = target.isSingleZone();
        this.forEachPlayer = target.isForEachPlayer();
        this.differentControllers = target.isDifferentControllers();
        this.differentCMC = target.isDifferentCMC();
        this.equalToughness = target.isEqualToughness();
        this.sameController = target.isSameController();
        this.withoutSameCreatureType = target.isWithoutSameCreatureType();
        this.withSameCreatureType = target.isWithSameCreatureType();
        this.withSameCardType = target.isWithSameCardType();
        this.randomTarget = target.isRandomTarget();
        this.randomNumTargets = target.isRandomNumTargets();
    }

    public TargetRestrictions(String prompt, String[] valid, String min2, String max) {
        this.uiPrompt = prompt;
        this.originalValidTgts = valid;
        this.validTgts = (String[])this.originalValidTgts.clone();
        this.minTargets = min2;
        this.maxTargets = max;
    }

    public final boolean getMandatory() {
        return this.bMandatory;
    }

    public final void setMandatory(boolean m4) {
        this.bMandatory = m4;
    }

    public final void setMaxTotalCMC(String cmc) {
        this.maxTotalCMC = cmc;
    }

    public final void setMaxTotalPower(String power) {
        this.maxTotalPower = power;
    }

    public final String[] getValidTgts() {
        return this.validTgts;
    }

    public final String getVTSelection() {
        return this.uiPrompt;
    }

    public final String getMinTargets() {
        return this.minTargets;
    }

    public final String getMaxTargets() {
        return this.maxTargets;
    }

    private String getMaxTotalCMC() {
        return this.maxTotalCMC;
    }

    public final int getMaxTotalCMC(Card c, SpellAbility sa) {
        return AbilityUtils.calculateAmount(c, this.maxTotalCMC, sa);
    }

    private String getMaxTotalPower() {
        return this.maxTotalPower;
    }

    public final int getMaxTotalPower(Card c, SpellAbility sa) {
        return AbilityUtils.calculateAmount(c, this.maxTotalPower, sa);
    }

    public final int getMinTargets(Card c, SpellAbility sa) {
        return AbilityUtils.calculateAmount(c, this.minTargets, sa);
    }

    public final int getMaxTargets(Card c, SpellAbility sa) {
        return AbilityUtils.calculateAmount(c, this.maxTargets, sa);
    }

    public final boolean isMaxTargetsChosen(Card c, SpellAbility sa) {
        return this.getMaxTargets(c, sa) == sa.getTargets().size();
    }

    public final boolean isMinTargetsChosen(Card c, SpellAbility sa) {
        int min2 = this.getMinTargets(c, sa);
        if (min2 == 0 || sa.isDividedAsYouChoose() && ObjectUtils.defaultIfNull(sa.getDividedValue(), 0) == 0) {
            return true;
        }
        return min2 <= sa.getTargets().size();
    }

    public final void setZone(ZoneType tZone) {
        this.tgtZone = Arrays.asList(tZone);
    }

    public final void setZone(List<ZoneType> tZone) {
        this.tgtZone = tZone;
    }

    public final List<ZoneType> getZone() {
        return this.tgtZone;
    }

    public final void setSAValidTargeting(String saValidTgting) {
        this.saValidTargeting = saValidTgting;
    }

    public final String getSAValidTargeting() {
        return this.saValidTargeting;
    }

    public final boolean canOnlyTgtOpponent() {
        boolean player = false;
        boolean opponent = false;
        for (String s2 : this.validTgts) {
            if (s2.startsWith("Opponent")) {
                opponent = true;
                continue;
            }
            if (!s2.startsWith("Player")) continue;
            player = true;
        }
        return opponent && !player;
    }

    public final boolean canTgtPlayer() {
        for (String s2 : this.validTgts) {
            if (!s2.startsWith("Player") && !s2.startsWith("Opponent") && !s2.startsWith("Any")) continue;
            return true;
        }
        return false;
    }

    public final boolean canTgtPermanent() {
        for (String s2 : this.validTgts) {
            if (!s2.contains("Permanent")) continue;
            return true;
        }
        return false;
    }

    public final boolean canTgtCreature() {
        for (String s2 : this.validTgts) {
            String[] tgtParams;
            if ((s2.contains("Creature") || s2.startsWith("Permanent") || s2.startsWith("Any")) && !s2.contains("nonCreature")) {
                return true;
            }
            for (String param : tgtParams = TextUtil.split(s2, '.')) {
                if (!CardType.isACreatureType(param)) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean canTgtPlaneswalker() {
        for (String s2 : this.validTgts) {
            if (!s2.startsWith("Planeswalker") && !s2.startsWith("Any")) continue;
            return true;
        }
        return false;
    }

    public final boolean canTgtCreatureAndPlayer() {
        return this.canTgtPlayer() && this.canTgtCreature();
    }

    public final boolean hasCandidates(SpellAbility sa) {
        Card srcCard = sa.getHostCard();
        Game game = srcCard.getGame();
        this.applyTargetTextChanges(sa);
        for (Player player : game.getPlayers()) {
            if (!player.isValid(this.validTgts, sa.getActivatingPlayer(), srcCard, (CardTraitBase)sa) || !sa.canTarget(player) || sa.getTargets().contains(player)) continue;
            return true;
        }
        if (this.tgtZone.contains((Object)ZoneType.Stack)) {
            return true;
        }
        for (Card c : game.getCardsIn(this.tgtZone)) {
            if (!c.isValid(this.validTgts, sa.getActivatingPlayer(), srcCard, (CardTraitBase)sa) || !sa.canTarget(c) || sa.getTargets().contains(c)) continue;
            return true;
        }
        return false;
    }

    public final int getNumCandidates(SpellAbility sa, boolean isTargeted) {
        int num = 0;
        if (this.tgtZone.contains((Object)ZoneType.Stack)) {
            for (SpellAbilityStackInstance si : sa.getHostCard().getGame().getStack()) {
                SpellAbility abilityOnStack = si.getSpellAbility();
                if (!sa.canTargetSpellAbility(abilityOnStack)) continue;
                ++num;
            }
        }
        return num + this.getAllCandidates(sa, isTargeted).size();
    }

    public final List<GameEntity> getAllCandidates(SpellAbility sa, boolean isTargeted) {
        return this.getAllCandidates(sa, isTargeted, false);
    }

    public final List<GameEntity> getAllCandidates(SpellAbility sa, boolean isTargeted, boolean onlyNonCard) {
        Game game = sa.getActivatingPlayer().getGame();
        ArrayList<GameEntity> candidates = Lists.newArrayList();
        for (Player player : game.getPlayers()) {
            if (!sa.canTarget(player)) continue;
            candidates.add(player);
        }
        this.applyTargetTextChanges(sa);
        if (onlyNonCard) {
            return candidates;
        }
        Card srcCard = sa.getHostCard();
        for (Card c : game.getCardsIn(this.tgtZone)) {
            if (!c.isValid(this.validTgts, sa.getActivatingPlayer(), srcCard, (CardTraitBase)sa) || isTargeted && !sa.canTarget(c) || sa.getTargets().contains(c)) continue;
            candidates.add(c);
        }
        return candidates;
    }

    public final boolean isUniqueTargets() {
        return this.uniqueTargets;
    }

    public final void setUniqueTargets(boolean unique) {
        this.uniqueTargets = unique;
    }

    public final boolean isSingleZone() {
        return this.singleZone;
    }

    public final void setSingleZone(boolean single) {
        this.singleZone = single;
    }

    public boolean isWithoutSameCreatureType() {
        return this.withoutSameCreatureType;
    }

    public void setWithoutSameCreatureType(boolean b) {
        this.withoutSameCreatureType = b;
    }

    public boolean isWithSameCreatureType() {
        return this.withSameCreatureType;
    }

    public void setWithSameCreatureType(boolean b) {
        this.withSameCreatureType = b;
    }

    public boolean isWithSameCardType() {
        return this.withSameCardType;
    }

    public void setWithSameCardType(boolean b) {
        this.withSameCardType = b;
    }

    public TargetRestrictions copy() {
        TargetRestrictions clone = null;
        try {
            clone = (TargetRestrictions)this.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println(e);
        }
        return clone;
    }

    public boolean isRandomTarget() {
        return this.randomTarget;
    }

    public void setRandomTarget(boolean random) {
        this.randomTarget = random;
    }

    public boolean isRandomNumTargets() {
        return this.randomNumTargets;
    }

    public void setRandomNumTargets(boolean randomNumTgts) {
        this.randomNumTargets = randomNumTgts;
    }

    public boolean isDifferentCMC() {
        return this.differentCMC;
    }

    public void setDifferentCMC(boolean different) {
        this.differentCMC = different;
    }

    public boolean isEqualToughness() {
        return this.equalToughness;
    }

    public void setEqualToughness(boolean b) {
        this.equalToughness = b;
    }

    public boolean isDifferentControllers() {
        return this.differentControllers;
    }

    public void setDifferentControllers(boolean different) {
        this.differentControllers = different;
    }

    public boolean isForEachPlayer() {
        return this.forEachPlayer;
    }

    public void setForEachPlayer(boolean each) {
        this.forEachPlayer = each;
    }

    public final boolean isSameController() {
        return this.sameController;
    }

    public final void setSameController(boolean same) {
        this.sameController = same;
    }

    public final void applyTargetTextChanges(SpellAbility sa) {
        for (int i = 0; i < this.validTgts.length; ++i) {
            this.validTgts[i] = AbilityUtils.applyAbilityTextChangeEffects(this.originalValidTgts[i], sa);
        }
    }
}

