/*
 * Decompiled with CFR 0.152.
 */
package forge.game.spellability;

import com.google.common.collect.Maps;
import forge.game.ability.ApiType;
import forge.game.ability.SpellApiBased;
import forge.game.card.Card;
import forge.game.card.CardState;
import forge.game.cost.Cost;
import org.apache.commons.lang3.StringUtils;

public class SpellPermanent
extends SpellApiBased {
    private static final long serialVersionUID = 2413495058630644447L;

    public SpellPermanent(Card sourceCard) {
        this(sourceCard, sourceCard.getCurrentState(), new Cost(sourceCard.getManaCost(), false));
    }

    public SpellPermanent(Card sourceCard, CardState cardstate) {
        this(sourceCard, cardstate, new Cost(cardstate.getManaCost(), false));
    }

    public SpellPermanent(Card sourceCard, CardState cardstate, Cost cost) {
        super(cardstate.getType().isCreature() ? ApiType.PermanentCreature : ApiType.PermanentNoncreature, sourceCard, cost, null, Maps.newHashMap());
        this.setStackDescription("");
        this.setDescription(this.getStackDescription());
        if (this.costHasManaX() && StringUtils.isNotBlank(this.getHostCard().getSVar("X"))) {
            this.setSVar("X", this.getHostCard().getSVar("X"));
        }
    }
}

