/*
 * Decompiled with CFR 0.152.
 */
package forge.game.spellability;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.GameObject;
import forge.game.GameObjectPredicates;
import forge.game.GameType;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCopyService;
import forge.game.card.CardLists;
import forge.game.card.CardPlayOption;
import forge.game.cost.IndividualCostPaymentInstance;
import forge.game.keyword.Keyword;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.SpellAbilityVariables;
import forge.game.staticability.StaticAbilityCastWithFlash;
import forge.game.staticability.StaticAbilityNumLoyaltyAct;
import forge.game.zone.Zone;
import forge.game.zone.ZoneType;
import forge.util.Expressions;
import forge.util.collect.FCollection;
import java.util.List;
import java.util.Map;

public class SpellAbilityRestriction
extends SpellAbilityVariables {
    public final void setRestrictions(Map<String, String> params) {
        if (params.containsKey("Activation")) {
            String value = params.get("Activation");
            if (value.equals("Threshold")) {
                this.setThreshold(true);
            }
            if (value.equals("Metalcraft")) {
                this.setMetalcraft(true);
            }
            if (value.equals("Delirium")) {
                this.setDelirium(true);
            }
            if (value.equals("Hellbent")) {
                this.setHellbent(true);
            }
            if (value.equals("Desert")) {
                this.setDesert(true);
            }
            if (value.equals("Blessing")) {
                this.setBlessing(true);
            }
            if (value.equals("Solved")) {
                this.setSolved(true);
            }
        }
        if (params.containsKey("ActivationZone")) {
            this.setZone(ZoneType.smartValueOf(params.get("ActivationZone")));
        }
        if (params.containsKey("SorcerySpeed")) {
            this.setSorcerySpeed(true);
        }
        if (params.containsKey("InstantSpeed")) {
            this.setInstantSpeed(true);
        }
        if (params.containsKey("PlayerTurn")) {
            this.setPlayerTurn(true);
        }
        if (params.containsKey("OpponentTurn")) {
            this.setOpponentTurn(true);
        }
        if (params.containsKey("Activator")) {
            this.setActivator(params.get("Activator"));
        }
        if (params.containsKey("ActivationLimit")) {
            this.setLimitToCheck(params.get("ActivationLimit"));
        }
        if (params.containsKey("GameActivationLimit")) {
            this.setGameLimitToCheck(params.get("GameActivationLimit"));
        }
        if (params.containsKey("ActivationPhases")) {
            this.setPhases(PhaseType.parseRange(params.get("ActivationPhases")));
        }
        if (params.containsKey("ActivationFirstCombat")) {
            this.setFirstCombatOnly(true);
        }
        if (params.containsKey("ActivationAfterBlockers")) {
            this.setAfterBlockersOnly(true);
        }
        if (params.containsKey("ActivationGameTypes")) {
            this.setGameTypes(GameType.listValueOf(params.get("ActivationGameTypes")));
        }
        if (params.containsKey("ActivationCardsInHand")) {
            this.setActivateCardsInHand(Integer.parseInt(params.get("ActivationCardsInHand")));
        }
        if (params.containsKey("OrActivationCardsInHand")) {
            this.setActivateCardsInHand2(Integer.parseInt(params.get("OrActivationCardsInHand")));
        }
        if (params.containsKey("ActivationChosenColor")) {
            this.setColorToCheck(params.get("ActivationChosenColor"));
        }
        if (params.containsKey("IsPresent")) {
            this.setIsPresent(params.get("IsPresent"));
            if (params.containsKey("PresentCompare")) {
                this.setPresentCompare(params.get("PresentCompare"));
            }
            if (params.containsKey("PresentZone")) {
                this.setPresentZone(ZoneType.smartValueOf(params.get("PresentZone")));
            }
        }
        if (params.containsKey("PresentDefined")) {
            this.setPresentDefined(params.get("PresentDefined"));
        }
        if (params.containsKey("ActivationLifeTotal")) {
            this.setLifeTotal(params.get("ActivationLifeTotal"));
            if (params.containsKey("ActivationLifeAmount")) {
                this.setLifeAmount(params.get("ActivationLifeAmount"));
            }
        }
        if (params.containsKey("CheckSVar")) {
            this.setSvarToCheck(params.get("CheckSVar"));
        }
        if (params.containsKey("SVarCompare")) {
            this.setSvarOperator(params.get("SVarCompare").substring(0, 2));
            this.setSvarOperand(params.get("SVarCompare").substring(2));
        }
        if (params.containsKey("ClassLevel")) {
            this.setClassLevelOperator(params.get("ClassLevel").substring(0, 2));
            this.setClassLevel(params.get("ClassLevel").substring(2));
        }
    }

    public final boolean checkZoneRestrictions(Card c, SpellAbility sa) {
        Player activator = sa.getActivatingPlayer();
        Zone cardZone = c.getLastKnownZone();
        Card cp = c;
        if (sa.isSpell() && sa.isBestow()) {
            if (c.isInPlay()) {
                return false;
            }
            if (!c.isLKI() || !c.isBestowed()) {
                if (!c.isLKI()) {
                    cp = CardCopyService.getLKICopy(c);
                }
                cp.animateBestow(!cp.isLKI());
            }
        }
        if (cardZone == null || this.getZone() == null || !cardZone.is(this.getZone())) {
            if (cardZone != null && cardZone.is(ZoneType.Command) && sa.hasParam("HiddenAgenda")) {
                return true;
            }
            if (sa.hasParam("AdditionalActivationZone") && cardZone != null && cardZone.is(ZoneType.valueOf(sa.getParam("AdditionalActivationZone")))) {
                return true;
            }
            if (!sa.isSpell() || cardZone != null && ZoneType.Battlefield.equals((Object)cardZone.getZoneType()) || this.getZone() != null && !this.getZone().equals((Object)ZoneType.Hand)) {
                return false;
            }
            if (cardZone != null && cardZone.is(ZoneType.Stack)) {
                return false;
            }
            if (sa.isSpell()) {
                CardPlayOption o = c.mayPlay(sa.getMayPlay());
                if (o == null || sa.isCastFromPlayEffect()) {
                    return this.getZone() == null || cardZone != null && cardZone.is(this.getZone());
                }
                if (o.getPlayer() == activator) {
                    Map<String, String> params = sa.getMayPlay().getMapParams();
                    if (!(o.grantsZonePermissions() || cardZone == null || cardZone.is(ZoneType.Hand) && activator == c.getOwner())) {
                        List<CardPlayOption> opts = c.mayPlay(activator);
                        boolean hasOtherGrantor = false;
                        for (CardPlayOption opt : opts) {
                            if (!opt.grantsZonePermissions()) continue;
                            hasOtherGrantor = true;
                            break;
                        }
                        if (cardZone.is(ZoneType.Graveyard) && sa.isAftermath()) {
                            return true;
                        }
                        if (!hasOtherGrantor) {
                            return false;
                        }
                    }
                    if (params.containsKey("Affected") && !cp.isValid(params.get("Affected").split(","), activator, o.getHost(), (CardTraitBase)o.getAbility())) {
                        return false;
                    }
                    if (params.containsKey("ValidSA") && !sa.isValid(params.get("ValidSA").split(","), activator, o.getHost(), (CardTraitBase)o.getAbility())) {
                        return false;
                    }
                    return this.getZone() == ZoneType.Graveyard || !sa.isAftermath() || sa.getCardState() == null;
                }
            }
            return false;
        }
        return true;
    }

    public final boolean checkTimingRestrictions(Card c, SpellAbility sa) {
        Player activator = sa.getActivatingPlayer();
        Game game = activator.getGame();
        if (this.isPlayerTurn() && !game.getPhaseHandler().isPlayerTurn(activator)) {
            return false;
        }
        if (this.isOpponentTurn() && !game.getPhaseHandler().getPlayerTurn().isOpponentOf(activator)) {
            return false;
        }
        if (this.getPhases().size() > 0 && !this.getPhases().contains((Object)game.getPhaseHandler().getPhase())) {
            return false;
        }
        if (this.getFirstCombatOnly() && game.getPhaseHandler().getNumCombat() > (game.getPhaseHandler().inCombat() ? 1 : 0)) {
            return false;
        }
        return !this.getAfterBlockersOnly() || !game.getPhaseHandler().skippedDeclareBlockers();
    }

    public final boolean checkActivatorRestrictions(Card c, SpellAbility sa) {
        CardPlayOption o;
        Player activator = sa.getActivatingPlayer();
        if (sa.isSpell() && (o = c.mayPlay(sa.getMayPlay())) != null && o.getPlayer() == activator) {
            return true;
        }
        String validPlayer = this.getActivator();
        return activator.isValid(validPlayer, c.getController(), c, (CardTraitBase)sa);
    }

    public final boolean checkOtherRestrictions(Card c, SpellAbility sa, Player activator) {
        Game game = activator.getGame();
        if ((c.isSorcery() || c.isInstant()) && c.getType().isLegendary() && CardLists.getValidCardCount(activator.getCardsIn(ZoneType.Battlefield), "Creature.Legendary,Planeswalker.Legendary", c.getController(), c, sa) <= 0) {
            return false;
        }
        if ((sa.isAftermath() || sa.isDisturb()) && !c.isInZone(ZoneType.Graveyard)) {
            return false;
        }
        if (sa.isKeyword(Keyword.FUSE) && !c.isInZone(ZoneType.Hand)) {
            return false;
        }
        if (this.getCardsInHand() != -1) {
            int h2 = activator.getCardsIn(ZoneType.Hand).size();
            if (this.getCardsInHand2() != -1 ? h2 != this.getCardsInHand() && h2 != this.getCardsInHand2() : h2 != this.getCardsInHand()) {
                return false;
            }
        }
        if (this.getColorToCheck() != null && !sa.getHostCard().hasChosenColor(this.getColorToCheck())) {
            return false;
        }
        if (this.isHellbent() && !activator.hasHellbent()) {
            return false;
        }
        if (this.isThreshold() && !activator.hasThreshold()) {
            return false;
        }
        if (this.isMetalcraft() && !activator.hasMetalcraft()) {
            return false;
        }
        if (this.isDelirium() && !activator.hasDelirium()) {
            return false;
        }
        if (sa.isSurged() && !activator.hasSurge()) {
            return false;
        }
        if (sa.isSpectacle() && activator.getOpponentLostLifeThisTurn() <= 0) {
            return false;
        }
        if (this.isDesert() && !activator.hasDesert()) {
            return false;
        }
        if (this.isBlessing() && !activator.hasBlessing()) {
            return false;
        }
        if (this.isSolved() && !c.isSolved()) {
            return false;
        }
        if (sa.isProwl() && !activator.hasProwl(sa)) {
            return false;
        }
        if (sa.isFreerunning() && !activator.hasFreerunning()) {
            return false;
        }
        if (this.getIsPresent() != null) {
            FCollection<GameObject> list = this.getPresentDefined() != null ? AbilityUtils.getDefinedObjects(sa.getHostCard(), this.getPresentDefined(), sa) : new FCollection<Card>(game.getCardsIn(this.getPresentZone()));
            int left = Iterables.size(Iterables.filter(list, GameObjectPredicates.restriction(this.getIsPresent().split(","), activator, c, sa)));
            String rightString = this.getPresentCompare().substring(2);
            int right = AbilityUtils.calculateAmount(c, rightString, sa);
            if (!Expressions.compare(left, this.getPresentCompare(), right)) {
                return false;
            }
        }
        if (this.getLifeTotal() != null) {
            int life = 1;
            if (this.getLifeTotal().equals("You")) {
                life = activator.getLife();
            }
            if (this.getLifeTotal().equals("OpponentSmallest")) {
                life = activator.getOpponentsSmallestLifeTotal();
            }
            int right = AbilityUtils.calculateAmount(sa.getHostCard(), this.getLifeAmount().substring(2), sa);
            if (!Expressions.compare(life, this.getLifeAmount(), right)) {
                return false;
            }
        }
        if (sa.isPwAbility()) {
            int limit;
            int numActivates = c.getPlaneswalkerAbilityActivated();
            int n = limit = StaticAbilityNumLoyaltyAct.limitIncrease(c) ? 2 : 1;
            if (numActivates >= limit && numActivates >= (limit += StaticAbilityNumLoyaltyAct.additionalActivations(c, sa) - (limit == 1 || c.planeswalkerActivationLimitUsed() ? 0 : 1))) {
                return false;
            }
        }
        if ((sa.isMorphUp() || sa.isDisguiseUp()) && c.isInPlay()) {
            Card cp = c;
            if (!c.isLKI()) {
                cp = CardCopyService.getLKICopy(c);
            }
            cp.forceTurnFaceUp();
            game.getTracker().freeze();
            cp.clearStaticChangedCardKeywords(false);
            CardCollection preList = new CardCollection(cp);
            game.getAction().checkStaticAbilities(false, Sets.newHashSet(cp), preList);
            boolean found = cp.hasSpellAbility(sa);
            game.getAction().checkStaticAbilities(false);
            game.getTracker().clearDelayed();
            game.getTracker().unfreeze();
            if (!found) {
                return false;
            }
        }
        if (sa.isBoast()) {
            int limit;
            int n = limit = activator.hasKeyword("Creatures you control can boast twice during each of your turns rather than once.") ? 2 : 1;
            if (limit <= sa.getActivationsThisTurn()) {
                return false;
            }
        }
        if (sa.isManaAbility()) {
            for (IndividualCostPaymentInstance i : game.costPaymentStack) {
                if (!i.getPayment().getAbility().equals(sa)) continue;
                return false;
            }
        }
        if (this.getsVarToCheck() != null) {
            int svarValue = AbilityUtils.calculateAmount(c, this.getsVarToCheck(), sa);
            int operandValue = AbilityUtils.calculateAmount(c, this.getsVarOperand(), sa);
            if (!Expressions.compare(svarValue, this.getsVarOperator(), operandValue)) {
                return false;
            }
        }
        if (this.getClassLevel() != null) {
            int level = c.getClassLevel();
            int levelOperand = AbilityUtils.calculateAmount(c, this.getClassLevel(), sa);
            if (!Expressions.compare(level, this.getClassLevelOperator(), levelOperand)) {
                return false;
            }
        }
        if (this.getGameTypes().size() > 0) {
            Predicate pgt = type -> game.getRules().hasAppliedVariant((GameType)((Object)type));
            if (!Iterables.any(this.getGameTypes(), pgt)) {
                return false;
            }
        }
        return true;
    }

    public final boolean canPlay(Card c, SpellAbility sa) {
        int limit;
        if (c.isPhasedOut() || c.isUsedToPay()) {
            return false;
        }
        Player activator = sa.getActivatingPlayer();
        if (activator == null) {
            activator = c.getController();
            sa.setActivatingPlayer(activator);
            System.out.println(c.getName() + " Did not have activator set in SpellAbilityRestriction.canPlay()");
        }
        if (!StaticAbilityCastWithFlash.anyWithFlashNeedsInfo(sa, c, activator) && !sa.canCastTiming(c, activator)) {
            return false;
        }
        if (sa.isManaAbility() && c.getGame().costPaymentStack.peek() != null && this.isInstantSpeed()) {
            return false;
        }
        if (!sa.isCastFromPlayEffect()) {
            if (!this.checkTimingRestrictions(c, sa)) {
                return false;
            }
            if (!this.checkActivatorRestrictions(c, sa)) {
                return false;
            }
        }
        if (!this.checkZoneRestrictions(c, sa)) {
            return false;
        }
        if (!this.checkOtherRestrictions(c, sa, activator)) {
            return false;
        }
        if (this.getLimitToCheck() != null) {
            limit = AbilityUtils.calculateAmount(c, this.getLimitToCheck(), sa);
            if (sa.getActivationsThisTurn() >= limit) {
                return false;
            }
        }
        if (this.getGameLimitToCheck() != null) {
            limit = AbilityUtils.calculateAmount(c, this.getGameLimitToCheck(), sa);
            if (sa.getActivationsThisGame() >= limit) {
                return false;
            }
        }
        return true;
    }
}

