/*
 * Decompiled with CFR 0.152.
 */
package forge.game.spellability;

import com.google.common.collect.Iterables;
import forge.card.ColorSet;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.GameObject;
import forge.game.GameObjectPredicates;
import forge.game.GameType;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.phase.PhaseHandler;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.spellability.OptionalCost;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.SpellAbilityVariables;
import forge.game.spellability.TargetChoices;
import forge.game.zone.ZoneType;
import forge.util.Expressions;
import forge.util.collect.FCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class SpellAbilityCondition
extends SpellAbilityVariables {
    public final void setConditions(Map<String, String> params) {
        if (params.containsKey("Condition")) {
            String value = params.get("Condition");
            if (value.equals("Threshold")) {
                this.setThreshold(true);
            }
            if (value.equals("Metalcraft")) {
                this.setMetalcraft(true);
            }
            if (value.equals("Delirium")) {
                this.setDelirium(true);
            }
            if (value.equals("Hellbent")) {
                this.setHellbent(true);
            }
            if (value.equals("Revolt")) {
                this.setRevolt(true);
            }
            if (value.equals("Desert")) {
                this.setDesert(true);
            }
            if (value.equals("Blessing")) {
                this.setBlessing(true);
            }
            if (value.equals("Kicked")) {
                this.kicked = true;
            }
            if (value.equals("Kicked 1")) {
                this.kicked1 = true;
            }
            if (value.equals("Kicked 2")) {
                this.kicked2 = true;
            }
            if (value.equals("Surge")) {
                this.surgeCostPaid = true;
            }
            if (value.equals("Bargain")) {
                this.bargain = true;
            }
            if (value.equals("AltCost")) {
                this.altCostPaid = true;
            }
            if (value.equals("OptionalCost")) {
                this.optionalCostPaid = true;
            }
            if (value.equals("Foretold")) {
                this.foretold = true;
            }
            if (params.containsKey("ConditionOptionalPaid")) {
                this.optionalBoolean = Boolean.parseBoolean(params.get("ConditionOptionalPaid"));
            }
        }
        if (params.containsKey("ConditionSorcerySpeed")) {
            this.setSorcerySpeed(true);
        }
        if (params.containsKey("ConditionPlayerTurn")) {
            this.setPlayerTurn(true);
        }
        if (params.containsKey("ConditionOpponentTurn")) {
            this.setOpponentTurn(true);
        }
        if (params.containsKey("ConditionPhases")) {
            this.setPhases(PhaseType.parseRange(params.get("ConditionPhases")));
        }
        if (params.containsKey("ConditionFirstCombat")) {
            this.setFirstCombatOnly(true);
        }
        if (params.containsKey("ConditionGameTypes")) {
            this.setGameTypes(GameType.listValueOf(params.get("ConditionGameTypes")));
        }
        if (params.containsKey("ConditionActivationLimit")) {
            this.setLimitToCheck(params.get("ConditionActivationLimit"));
        }
        if (params.containsKey("ConditionChosenColor")) {
            this.setColorToCheck(params.get("ConditionChosenColor"));
        }
        if (params.containsKey("Presence")) {
            this.setPresenceCondition(params.get("Presence"));
        }
        if (params.containsKey("ConditionPresent")) {
            this.setIsPresent(params.get("ConditionPresent"));
            if (params.containsKey("ConditionCompare")) {
                this.setPresentCompare(params.get("ConditionCompare"));
            }
            if (params.containsKey("ConditionPresent2")) {
                this.setIsPresent2(params.get("ConditionPresent2"));
                if (params.containsKey("ConditionCompare2")) {
                    this.setPresentCompare2(params.get("ConditionCompare2"));
                }
            }
        }
        if (params.containsKey("ConditionDefined")) {
            this.setPresentDefined(params.get("ConditionDefined"));
        }
        if (params.containsKey("ConditionDefined2")) {
            this.setPresentDefined2(params.get("ConditionDefined2"));
        }
        if (params.containsKey("ConditionZone")) {
            this.setPresentZone(ZoneType.smartValueOf(params.get("ConditionZone")));
        }
        if (params.containsKey("ConditionPlayerDefined")) {
            this.setPlayerDefined(params.get("ConditionPlayerDefined"));
        }
        if (params.containsKey("ConditionPlayerContains")) {
            this.setPlayerContains(params.get("ConditionPlayerContains"));
        }
        if (params.containsKey("ConditionNotPresent")) {
            this.setIsPresent(params.get("ConditionNotPresent"));
            this.setPresentCompare("EQ0");
        }
        if (params.containsKey("ConditionLifeTotal")) {
            this.setLifeTotal(params.get("ConditionLifeTotal"));
            if (params.containsKey("ConditionLifeAmount")) {
                this.setLifeAmount(params.get("ConditionLifeAmount"));
            }
        }
        if (params.containsKey("ConditionNoDifferentColors")) {
            this.setNoDifferentColors(params.get("ConditionNoDifferentColors"));
        }
        if (params.containsKey("ConditionManaSpent")) {
            this.setManaSpent(params.get("ConditionManaSpent"));
        }
        if (params.containsKey("ConditionManaNotSpent")) {
            this.setManaNotSpent(params.get("ConditionManaNotSpent"));
        }
        if (params.containsKey("ConditionCheckSVar")) {
            this.setSvarToCheck(params.get("ConditionCheckSVar"));
        }
        if (params.containsKey("ConditionSVarCompare")) {
            this.setSvarOperator(params.get("ConditionSVarCompare").substring(0, 2));
            this.setSvarOperand(params.get("ConditionSVarCompare").substring(2));
        }
        if (params.containsKey("OrOtherConditionSVarCompare")) {
            if (params.containsKey("OrConditionCheckSVar")) {
                this.setSvarToCheck2(params.get("OrConditionCheckSVar"));
            } else {
                this.setSvarToCheck2(params.get("ConditionCheckSVar"));
            }
            this.setSvarOperator2(params.get("OrOtherConditionSVarCompare").substring(0, 2));
            this.setSvarOperand2(params.get("OrOtherConditionSVarCompare").substring(2));
        }
        if (params.containsKey("ConditionTargetValidTargeting")) {
            this.setTargetValidTargeting(params.get("ConditionTargetValidTargeting"));
        }
        if (params.containsKey("ConditionTargetsSingleTarget")) {
            this.setTargetsSingleTarget(true);
        }
    }

    public final boolean areMet(SpellAbility sa) {
        SpellAbility castSa;
        int left;
        boolean usedLastState;
        Player activator = sa.getActivatingPlayer();
        if (activator == null) {
            activator = sa.getHostCard().getController();
            System.out.println(sa.getHostCard().getName() + " Did not have activator set in SpellAbility_Condition.checkConditions()");
        }
        Game game = activator.getGame();
        PhaseHandler phase = game.getPhaseHandler();
        Card host = sa.getHostCard();
        if (this.isHellbent() && !activator.hasHellbent()) {
            return false;
        }
        if (this.isThreshold() && !activator.hasThreshold()) {
            return false;
        }
        if (this.isMetalcraft() && !activator.hasMetalcraft()) {
            return false;
        }
        if (this.isDelirium() && !activator.hasDelirium()) {
            return false;
        }
        if (this.isRevolt() && !activator.hasRevolt()) {
            return false;
        }
        if (this.isDesert() && !activator.hasDesert()) {
            return false;
        }
        if (this.isBlessing() && !activator.hasBlessing()) {
            return false;
        }
        if (this.kicked && !sa.isKicked()) {
            return false;
        }
        if (this.kicked1 && !sa.isOptionalCostPaid(OptionalCost.Kicker1)) {
            return false;
        }
        if (this.kicked2 && !sa.isOptionalCostPaid(OptionalCost.Kicker2)) {
            return false;
        }
        if (this.altCostPaid && !sa.isOptionalCostPaid(OptionalCost.AltCost)) {
            return false;
        }
        if (this.surgeCostPaid && !sa.isSurged()) {
            return false;
        }
        if (this.bargain && !sa.isBargained()) {
            return false;
        }
        if (this.foretold && !sa.isForetold()) {
            return false;
        }
        if (this.optionalCostPaid && this.optionalBoolean && !sa.isOptionalCostPaid(OptionalCost.Generic)) {
            return false;
        }
        if (this.optionalCostPaid && !this.optionalBoolean && sa.isOptionalCostPaid(OptionalCost.Generic)) {
            return false;
        }
        if (!this.getPresenceCondition().isEmpty()) {
            int ctrl;
            if (host.getCastFrom() == null || host.getCastSA() == null) {
                return false;
            }
            String type = this.getPresenceCondition();
            int revealed = AbilityUtils.calculateAmount(host, "Revealed$Valid " + type, host.getCastSA());
            if (revealed + (ctrl = AbilityUtils.calculateAmount(host, "Count$LastStateBattlefield " + type + ".YouCtrl", host.getCastSA())) == 0) {
                return false;
            }
        }
        if (this.getNoDifferentColors() != null) {
            CardCollection tgts = AbilityUtils.getDefinedCards(host, this.getNoDifferentColors(), sa);
            Card first = Iterables.getFirst(tgts, null);
            if (first == null) {
                return false;
            }
            byte firstColor = first.getColor().getColor();
            for (Card c : tgts) {
                if (c.getColor().getColor() == firstColor) continue;
                return false;
            }
        }
        if (this.isSorcerySpeed() && !activator.canCastSorcery()) {
            return false;
        }
        if (this.isPlayerTurn()) {
            boolean b;
            boolean bl = b = !sa.getParam("ConditionPlayerTurn").equals("False");
            if (!b && phase.isPlayerTurn(activator)) {
                return false;
            }
            if (b && !phase.isPlayerTurn(activator)) {
                return false;
            }
        }
        if (this.isOpponentTurn() && !phase.getPlayerTurn().isOpponentOf(activator)) {
            return false;
        }
        if (this.getFirstCombatOnly() && !phase.isFirstCombat()) {
            return false;
        }
        if (this.getLimitToCheck() != null) {
            String comp = this.getLimitToCheck();
            int right = Integer.parseInt(comp.substring(2));
            int activationNum = sa.getActivationsThisTurn();
            if (!Expressions.compare(activationNum, comp, right)) {
                return false;
            }
        }
        if (this.getPhases().size() > 0 && !this.getPhases().contains((Object)phase.getPhase())) {
            return false;
        }
        if (this.getGameTypes().size() > 0 && !this.getGameTypes().contains((Object)game.getRules().getGameType())) {
            return false;
        }
        if (this.getCardsInHand() != -1 && activator.getCardsIn(ZoneType.Hand).size() != this.getCardsInHand()) {
            return false;
        }
        if (this.getColorToCheck() != null && !host.hasChosenColor(this.getColorToCheck())) {
            return false;
        }
        if (this.getIsPresent() != null) {
            FCollection<GameObject> list = null;
            if (this.getPresentDefined() != null) {
                list = AbilityUtils.getDefinedObjects(host, this.getPresentDefined(), sa);
            } else {
                usedLastState = false;
                if (sa.isReplacementAbility()) {
                    if (this.getPresentZone().equals((Object)ZoneType.Battlefield)) {
                        list = new FCollection<Card>(sa.getRootAbility().getLastStateBattlefield());
                        usedLastState = true;
                    } else if (this.getPresentZone().equals((Object)ZoneType.Graveyard)) {
                        list = new FCollection<Card>(sa.getRootAbility().getLastStateGraveyard());
                        usedLastState = true;
                    }
                }
                if (!usedLastState) {
                    list = new FCollection<Card>(game.getCardsIn(this.getPresentZone()));
                }
            }
            left = Iterables.size(Iterables.filter(list, GameObjectPredicates.restriction(this.getIsPresent().split(","), activator, host, sa)));
            String rightString = this.getPresentCompare().substring(2);
            int right = AbilityUtils.calculateAmount(host, rightString, sa);
            if (!Expressions.compare(left, this.getPresentCompare(), right)) {
                return false;
            }
        }
        if (this.getIsPresent2() != null) {
            FCollection<GameObject> list = null;
            if (this.getPresentDefined2() != null) {
                list = AbilityUtils.getDefinedObjects(host, this.getPresentDefined2(), sa);
            } else {
                usedLastState = false;
                if (sa.isReplacementAbility()) {
                    if (this.getPresentZone().equals((Object)ZoneType.Battlefield)) {
                        list = new FCollection<Card>(sa.getRootAbility().getLastStateBattlefield());
                        usedLastState = true;
                    } else if (this.getPresentZone().equals((Object)ZoneType.Graveyard)) {
                        list = new FCollection<Card>(sa.getRootAbility().getLastStateGraveyard());
                        usedLastState = true;
                    }
                }
                if (!usedLastState) {
                    list = new FCollection<Card>(game.getCardsIn(this.getPresentZone()));
                }
            }
            left = Iterables.size(Iterables.filter(list, GameObjectPredicates.restriction(this.getIsPresent2().split(","), activator, host, sa)));
            String rightString = this.getPresentCompare2().substring(2);
            int right = AbilityUtils.calculateAmount(host, rightString, sa);
            if (!Expressions.compare(left, this.getPresentCompare2(), right)) {
                return false;
            }
        }
        if (this.getPlayerContains() != null) {
            PlayerCollection contains;
            ArrayList<Player> list = new ArrayList<Player>();
            if (this.getPlayerDefined() != null) {
                list.addAll(AbilityUtils.getDefinedPlayers(host, this.getPlayerDefined(), sa));
            }
            if ((contains = AbilityUtils.getDefinedPlayers(host, this.getPlayerContains(), sa)).isEmpty() || !list.containsAll(contains)) {
                return false;
            }
        }
        if (this.getLifeTotal() != null) {
            int life = 1;
            life = this.getLifeTotal().equals("OpponentSmallest") ? activator.getOpponentsSmallestLifeTotal() : ((Player)AbilityUtils.getDefinedPlayers(host, this.getLifeTotal(), sa).getFirst()).getLife();
            int right = 1;
            String rightString = this.getLifeAmount().substring(2);
            right = rightString.equals("X") ? AbilityUtils.calculateAmount(host, host.getSVar("X"), sa) : Integer.parseInt(this.getLifeAmount().substring(2));
            if (!Expressions.compare(life, this.getLifeAmount(), right)) {
                return false;
            }
        }
        if (this.getTargetValidTargeting() != null) {
            TargetChoices matchTgt = sa.getTargets();
            if (matchTgt == null || matchTgt.getFirstTargetedSpell() == null || matchTgt.getFirstTargetedSpell().getTargets() == null) {
                return false;
            }
            boolean result = false;
            SpellAbility abSub = matchTgt.getFirstTargetedSpell();
            while (abSub != null && !result) {
                for (GameObject o : abSub.getTargets()) {
                    if (!o.isValid(this.getTargetValidTargeting().split(","), activator, host, (CardTraitBase)sa)) continue;
                    result = true;
                    break;
                }
                abSub = sa.getSubAbility();
            }
            if (!result) {
                return false;
            }
        }
        if (this.targetsSingleTarget()) {
            TargetChoices matchTgt = sa.getTargets();
            if (matchTgt == null || matchTgt.getFirstTargetedSpell() == null || matchTgt.getFirstTargetedSpell().getTargets() == null) {
                return false;
            }
            HashSet<GameObject> targets = new HashSet<GameObject>();
            for (TargetChoices tc : sa.getAllTargetChoices()) {
                targets.addAll(tc);
                if (targets.size() <= 1) continue;
                return false;
            }
            if (targets.size() != 1) {
                return false;
            }
        }
        if (StringUtils.isNotEmpty(this.getManaSpent())) {
            SpellAbility castSa2 = host.getCastSA();
            if (castSa2 == null) {
                return false;
            }
            if (!castSa2.getPayingColors().hasAllColors(ColorSet.fromNames(this.getManaSpent().split(" ")).getColor())) {
                return false;
            }
        }
        if (StringUtils.isNotEmpty(this.getManaNotSpent()) && (castSa = host.getCastSA()) != null && castSa.getPayingColors().hasAllColors(ColorSet.fromNames(this.getManaNotSpent().split(" ")).getColor())) {
            return false;
        }
        if (this.getsVarToCheck() != null) {
            int svarValue = AbilityUtils.calculateAmount(host, this.getsVarToCheck(), sa);
            int operandValue = AbilityUtils.calculateAmount(host, this.getsVarOperand(), sa);
            boolean secondCheck = false;
            if (this.getsVarToCheck2() != null) {
                int svarValue2 = AbilityUtils.calculateAmount(host, this.getsVarToCheck2(), sa);
                int operandValue2 = AbilityUtils.calculateAmount(host, this.getsVarOperand2(), sa);
                if (Expressions.compare(svarValue2, this.getsVarOperator2(), operandValue2)) {
                    secondCheck = true;
                }
            }
            if (!Expressions.compare(svarValue, this.getsVarOperator(), operandValue) && !secondCheck) {
                return false;
            }
        }
        return true;
    }
}

