/*
 * Decompiled with CFR 0.152.
 */
package forge.game.spellability;

import com.google.common.collect.Lists;
import forge.card.ColorSet;
import forge.card.GamePieceType;
import forge.card.MagicColor;
import forge.card.mana.ManaAtom;
import forge.card.mana.ManaCostShard;
import forge.game.Game;
import forge.game.GameActionUtil;
import forge.game.IHasSVars;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.ApiType;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardUtil;
import forge.game.cost.Cost;
import forge.game.mana.Mana;
import forge.game.mana.ManaPool;
import forge.game.player.Player;
import forge.game.replacement.ReplacementEffect;
import forge.game.replacement.ReplacementHandler;
import forge.game.replacement.ReplacementLayer;
import forge.game.replacement.ReplacementType;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.Trigger;
import forge.game.trigger.TriggerHandler;
import forge.game.trigger.TriggerType;
import forge.game.zone.Zone;
import forge.game.zone.ZoneType;
import forge.util.TextUtil;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class AbilityManaPart
implements Serializable {
    private static final long serialVersionUID = -6816356991224950520L;
    private final String origProduced;
    private String lastExpressChoice = "";
    private final String manaRestrictions;
    private String extraManaRestrictions = "";
    private final String cannotCounterSpell;
    private final String addsKeywords;
    private final String addsKeywordsType;
    private final String addsKeywordsUntil;
    private final String addsCounters;
    private final String triggersWhenSpent;
    private final boolean persistentMana;
    private transient List<Mana> lastManaProduced = Lists.newArrayList();
    private transient Card sourceCard;
    private transient IHasSVars sVarHolder;

    public AbilityManaPart(SpellAbility sourceSA, Map<String, String> params) {
        this(sourceSA.getHostCard(), params);
        this.sVarHolder = sourceSA;
    }

    public AbilityManaPart(Card sourceCard, Map<String, String> params) {
        this.sourceCard = sourceCard;
        this.sVarHolder = sourceCard;
        this.origProduced = params.getOrDefault("Produced", "1");
        this.manaRestrictions = params.getOrDefault("RestrictValid", "");
        this.cannotCounterSpell = params.get("AddsNoCounter");
        this.addsKeywords = params.get("AddsKeywords");
        this.addsKeywordsType = params.get("AddsKeywordsValid");
        this.addsKeywordsUntil = params.get("AddsKeywordsUntil");
        this.addsCounters = params.get("AddsCounters");
        this.triggersWhenSpent = params.get("TriggersWhenSpent");
        this.persistentMana = null != params.get("PersistentMana") && "True".equalsIgnoreCase(params.get("PersistentMana"));
    }

    public AbilityManaPart(Card newSource, AbilityManaPart oldMana) {
        this.sourceCard = newSource;
        this.origProduced = oldMana.origProduced;
        this.manaRestrictions = oldMana.manaRestrictions;
        this.cannotCounterSpell = oldMana.cannotCounterSpell;
        this.addsKeywords = oldMana.addsKeywords;
        this.addsKeywordsType = oldMana.addsKeywordsType;
        this.addsKeywordsUntil = oldMana.addsKeywordsUntil;
        this.addsCounters = oldMana.addsCounters;
        this.triggersWhenSpent = oldMana.triggersWhenSpent;
        this.persistentMana = oldMana.persistentMana;
    }

    public final void produceMana(SpellAbility sa) {
        this.produceMana(this.getOrigProduced(), this.getSourceCard().getController(), sa);
    }

    public final String produceMana(String produced, Player player, SpellAbility sa) {
        SpellAbility root;
        Card source = this.getSourceCard();
        ManaPool manaPool = player.getManaPool();
        Game game = player.getGame();
        String afterReplace = produced;
        SpellAbility spellAbility = root = sa == null ? null : sa.getRootAbility();
        if (root != null) {
            String[] repParams = AbilityKey.mapFromAffected(source);
            repParams.put((AbilityKey)AbilityKey.Mana, (Object)afterReplace);
            repParams.put(AbilityKey.Player, player);
            repParams.put(AbilityKey.AbilityMana, root);
            repParams.put(AbilityKey.Activator, root.getActivatingPlayer());
            switch (game.getReplacementHandler().run(ReplacementType.ProduceMana, (Map<AbilityKey, Object>)repParams)) {
                case NotReplaced: {
                    break;
                }
                case Updated: {
                    afterReplace = (String)repParams.get((Object)AbilityKey.Mana);
                    break;
                }
                default: {
                    return "";
                }
            }
        }
        this.lastManaProduced.clear();
        for (String c : afterReplace.split(" ")) {
            if (StringUtils.isNumeric(c)) {
                for (int i = Integer.parseInt(c); i > 0; --i) {
                    this.lastManaProduced.add(new Mana(32, source, this));
                }
                continue;
            }
            byte attemptedMana = MagicColor.fromName(c);
            if (attemptedMana == 0) {
                attemptedMana = 32;
            }
            this.lastManaProduced.add(new Mana(attemptedMana, source, this));
        }
        manaPool.add(this.lastManaProduced);
        Map<AbilityKey, Object> runParams = AbilityKey.mapFromCard(source);
        runParams.put(AbilityKey.Player, player);
        runParams.put(AbilityKey.Produced, afterReplace);
        runParams.put(AbilityKey.AbilityMana, root);
        runParams.put(AbilityKey.Activator, root == null ? null : root.getActivatingPlayer());
        game.getTriggerHandler().runTrigger(TriggerType.ManaAdded, runParams, false);
        return afterReplace;
    }

    public void tapsForMana(SpellAbility root, String mana) {
        if (!root.isManaAbility() || root.getPayCosts() == null || !root.getPayCosts().hasTapCost()) {
            return;
        }
        if (this.getSourceCard().isLand()) {
            root.getActivatingPlayer().setTappedLandForManaThisTurn(true);
        }
        Map<AbilityKey, Object> runParams = AbilityKey.mapFromCard(this.getSourceCard());
        runParams.put(AbilityKey.Produced, mana);
        runParams.put(AbilityKey.AbilityMana, root);
        runParams.put(AbilityKey.Activator, root.getActivatingPlayer());
        this.getSourceCard().getGame().getTriggerHandler().runTrigger(TriggerType.TapsForMana, runParams, false);
    }

    public boolean cannotCounterPaidWith(SpellAbility saBeingPaid) {
        if (null == this.cannotCounterSpell) {
            return false;
        }
        if ("True".equalsIgnoreCase(this.cannotCounterSpell)) {
            return true;
        }
        Card source = saBeingPaid.getHostCard();
        if (source == null) {
            return false;
        }
        return source.isValid(this.cannotCounterSpell, this.sourceCard.getController(), this.sourceCard, null);
    }

    public boolean isCannotCounterPaidWith() {
        return null != this.cannotCounterSpell;
    }

    public void addNoCounterEffect(SpellAbility saBeingPaid) {
        Game game = this.sourceCard.getGame();
        Card eff = new Card(game.nextCardId(), game);
        eff.setGameTimestamp(game.getNextTimestamp());
        eff.setName(this.sourceCard + "'s Effect");
        eff.setOwner(this.sourceCard.getController());
        eff.setImageKey(this.sourceCard.getImageKey());
        eff.setColor((byte)0);
        eff.setGamePieceType(GamePieceType.EFFECT);
        String cantcounterstr = "Event$ Counter | ValidCard$ Card.IsRemembered | Description$ That spell can't be countered.";
        ReplacementEffect re = ReplacementHandler.parseReplacement(cantcounterstr, eff, true);
        re.setLayer(ReplacementLayer.CantHappen);
        eff.addReplacementEffect(re);
        eff.addRemembered(saBeingPaid.getHostCard());
        SpellAbilityEffect.addForgetOnMovedTrigger(eff, "Stack");
        game.getAction().moveToCommand(eff, null);
    }

    public boolean addKeywords(SpellAbility saBeingPaid) {
        return this.addsKeywords != null;
    }

    public String getAddsKeywordsType() {
        return this.addsKeywordsType;
    }

    public String getAddsKeywordsUntil() {
        return this.addsKeywordsUntil;
    }

    public String getKeywords() {
        return this.addsKeywords;
    }

    public boolean addsCounters(SpellAbility saBeingPaid) {
        return this.addsCounters != null;
    }

    public void createETBCounters(Card c, Player controller) {
        String[] parse = this.addsCounters.split("_");
        if (c.isValid(parse[0], c.getController(), c, null)) {
            GameActionUtil.createETBCountersEffect(this.sourceCard, c, controller, parse[1], parse[2]);
        }
    }

    public boolean getTriggersWhenSpent() {
        return this.triggersWhenSpent != null;
    }

    public void addTriggersWhenSpent(SpellAbility saBeingPaid, Card card) {
        if (this.triggersWhenSpent == null) {
            return;
        }
        TriggerHandler handler = card.getGame().getTriggerHandler();
        Trigger trig = TriggerHandler.parseTrigger(this.sVarHolder.getSVar(this.triggersWhenSpent), this.sourceCard, false, this.sVarHolder);
        if (this.sVarHolder instanceof SpellAbility) {
            trig.setSpawningAbility((SpellAbility)this.sVarHolder);
        }
        handler.registerOneTrigger(trig);
    }

    public SpellAbility getSourceSA() {
        return this.sVarHolder instanceof SpellAbility ? (SpellAbility)this.sVarHolder : null;
    }

    public String getManaRestrictions() {
        return this.manaRestrictions;
    }

    public void setExtraManaRestriction(String str) {
        this.extraManaRestrictions = str;
    }

    public String getExtraManaRestriction() {
        return this.extraManaRestrictions;
    }

    public boolean meetsManaRestrictions(SpellAbility sa) {
        return this.meetsManaRestrictions(sa, this.manaRestrictions) && this.meetsManaRestrictions(sa, this.extraManaRestrictions);
    }

    public boolean meetsManaRestrictions(SpellAbility sa, String restrictions) {
        if (restrictions.isEmpty()) {
            return true;
        }
        for (String restriction : restrictions.split(",")) {
            if (restriction.equals("nonSpell")) {
                return !sa.isSpell();
            }
            if (restriction.equals("CumulativeUpkeep")) {
                if (!sa.isCumulativeUpkeep()) continue;
                return true;
            }
            if (restriction.startsWith("CostContains")) {
                Game game = sa.getHostCard().getGame();
                Cost payment = sa.getPayCosts();
                if (game.getStack().isResolving() && sa.hasParam("UnlessCost")) {
                    payment = AbilityUtils.calculateUnlessCost(sa, sa.getParam("UnlessCost"), false);
                }
                if (payment.hasNoManaCost()) continue;
                if (restriction.endsWith("X") && payment.getCostMana().getAmountOfX() > 0) {
                    return true;
                }
                if (!restriction.endsWith("C") || payment.getCostMana().getMana().getShardCount(ManaCostShard.COLORLESS) <= 0) continue;
                return true;
            }
            if (restriction.equals("MorphOrManifest")) {
                if ((!sa.isSpell() || !sa.getHostCard().isCreature() || !sa.isCastFaceDown()) && !sa.isManifestUp() && !sa.isMorphUp()) continue;
                return true;
            }
            if (restriction.equals("CantPayGenericCosts")) {
                return true;
            }
            if (restriction.startsWith("CantCastSpellFrom")) {
                ZoneType zone;
                if (!sa.isSpell()) {
                    return true;
                }
                ZoneType badZone = ZoneType.smartValueOf(restriction.substring(17));
                Card host = sa.getHostCard();
                Zone castFrom = host.getCastFrom();
                ZoneType zoneType = zone = castFrom == null ? host.getZone().getZoneType() : castFrom.getZoneType();
                if (!badZone.equals((Object)zone)) {
                    return true;
                }
            }
            if (restriction.equals("CantCastNonArtifactSpells")) {
                return !sa.isSpell() || sa.getHostCard().isArtifact();
            }
            if (this.getSourceCard().getGame().getStack().getInstanceMatchingSpellAbilityID(sa.getRootAbility()) != null) {
                return false;
            }
            if (!sa.isValid(restriction, this.getSourceCard().getController(), this.getSourceCard(), null)) continue;
            return true;
        }
        return false;
    }

    public boolean meetsManaShardRestrictions(ManaCostShard shard, byte color) {
        if (this.manaRestrictions.isEmpty()) {
            return true;
        }
        for (String restriction : this.manaRestrictions.split(",")) {
            if (!restriction.equals("CantPayGenericCosts") || !shard.isGeneric() || shard.isOr2Generic() && shard.isColor(color)) continue;
            return false;
        }
        return true;
    }

    public boolean meetsSpellAndShardRestrictions(SpellAbility sa, ManaCostShard shard, byte color) {
        return this.meetsManaRestrictions(sa) && this.meetsManaShardRestrictions(shard, color);
    }

    public final String mana(SpellAbility sa) {
        if (this.isComboMana()) {
            return this.getComboColors(sa);
        }
        String produced = this.getOrigProduced();
        if (produced.contains("Chosen")) {
            produced = produced.replace("Chosen", this.getChosenColor(sa));
        }
        return produced;
    }

    public void setExpressChoice(String s2) {
        this.lastExpressChoice = s2;
    }

    public void setExpressChoice(ColorSet cs) {
        StringBuilder sb = new StringBuilder();
        if (cs.hasBlack()) {
            sb.append("B ");
        }
        if (cs.hasBlue()) {
            sb.append("U ");
        }
        if (cs.hasWhite()) {
            sb.append("W ");
        }
        if (cs.hasRed()) {
            sb.append("R ");
        }
        if (cs.hasGreen()) {
            sb.append("G ");
        }
        this.lastExpressChoice = sb.toString().trim();
    }

    public String getExpressChoice() {
        return this.lastExpressChoice;
    }

    public void clearExpressChoice() {
        this.lastExpressChoice = "";
    }

    public List<Mana> getLastManaProduced() {
        return this.lastManaProduced;
    }

    public final boolean isSnow() {
        return this.getSourceCard().isSnow();
    }

    public boolean isAnyMana() {
        return this.getOrigProduced().contains("Any");
    }

    public boolean isComboMana() {
        return this.getOrigProduced().startsWith("Combo");
    }

    public boolean isSpecialMana() {
        return this.getOrigProduced().contains("Special");
    }

    public final boolean canProduce(String s2, SpellAbility sa) {
        if (this.isAnyMana() && !s2.equals("C")) {
            return true;
        }
        return this.mana(sa).contains(s2);
    }

    public final boolean equals(Object o) {
        if (!(o instanceof AbilityManaPart)) {
            return false;
        }
        AbilityManaPart abm = (AbilityManaPart)o;
        return this.sourceCard.equals(abm.sourceCard) && this.origProduced.equals(abm.getOrigProduced());
    }

    public int hashCode() {
        return 41 * (41 + this.getSourceCard().hashCode());
    }

    public String getOrigProduced() {
        return this.origProduced;
    }

    public String getComboColors(SpellAbility sa) {
        String origProduced = this.getOrigProduced();
        if (!origProduced.startsWith("Combo")) {
            return "";
        }
        if (origProduced.contains("Any")) {
            return "W U B R G";
        }
        if (origProduced.contains("Chosen")) {
            origProduced = origProduced.replace("Chosen", this.getChosenColor(sa));
        }
        if (origProduced.contains("NotedColors")) {
            if (sa.getActivatingPlayer() == null) {
                return "";
            }
            String colors = sa.getActivatingPlayer().getDraftNotes().get("Paliano, the High City");
            if (colors == null) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            for (String color : colors.split(",")) {
                String shortColor = MagicColor.toShortString(color);
                if (sb.indexOf(shortColor) != -1) continue;
                sb.append(shortColor).append(" ");
            }
            origProduced = origProduced.replace("NotedColors", sb.toString().trim());
        }
        if (!origProduced.contains("ColorIdentity")) {
            return TextUtil.fastReplace(origProduced, "Combo ", "");
        }
        StringBuilder sb = new StringBuilder();
        if (this.getSourceCard().getController() != null) {
            List<Card> commanders = this.getSourceCard().getController().getCommanders();
            if (commanders.isEmpty()) {
                return "";
            }
            ColorSet identity = this.getSourceCard().getController().getCommanderColorID();
            if (identity.hasWhite()) {
                sb.append("W ");
            }
            if (identity.hasBlue()) {
                sb.append("U ");
            }
            if (identity.hasBlack()) {
                sb.append("B ");
            }
            if (identity.hasRed()) {
                sb.append("R ");
            }
            if (identity.hasGreen()) {
                sb.append("G ");
            }
        }
        return sb.length() == 0 ? "" : sb.substring(0, sb.length() - 1);
    }

    public String getChosenColor(SpellAbility sa) {
        if (sa == null) {
            return "";
        }
        Card card = sa.getHostCard();
        if (card != null && card.hasChosenColor()) {
            return MagicColor.toShortString(card.getChosenColor());
        }
        return "";
    }

    public Card getSourceCard() {
        return this.sourceCard;
    }

    public void setSourceCard(Card host) {
        this.sourceCard = host;
    }

    public boolean isPersistentMana() {
        return this.persistentMana;
    }

    boolean abilityProducesManaColor(SpellAbility am, byte neededColor) {
        if (0 != (neededColor & 0x40)) {
            return true;
        }
        if (this.isAnyMana()) {
            return true;
        }
        Card source = am.getHostCard();
        Player activator = am.getActivatingPlayer();
        Map<AbilityKey, Object> repParams = AbilityKey.mapFromAffected(source);
        repParams.put(AbilityKey.Mana, this.getOrigProduced());
        repParams.put(AbilityKey.Activator, activator);
        repParams.put(AbilityKey.AbilityMana, am.getRootAbility());
        if (!source.getGame().getReplacementHandler().getReplacementList(ReplacementType.ProduceMana, repParams, ReplacementLayer.Other).isEmpty()) {
            return true;
        }
        if (am.getApi() == ApiType.ManaReflected) {
            Set<String> reflectableColors = CardUtil.getReflectableManaColors(am);
            for (String color : reflectableColors) {
                if (0 == (neededColor & ManaAtom.fromName(color))) continue;
                return true;
            }
        } else {
            if (this.isSpecialMana()) {
                return true;
            }
            String colorsProduced = this.mana(am);
            for (String color : colorsProduced.split(" ")) {
                if (0 == (neededColor & ManaAtom.fromName(color))) continue;
                return true;
            }
        }
        return false;
    }
}

