/*
 * Decompiled with CFR 0.152.
 */
package forge.game.spellability;

import forge.game.Game;
import forge.game.card.Card;
import forge.game.cost.Cost;
import forge.game.cost.CostPayment;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.TargetRestrictions;
import forge.game.staticability.StaticAbilityCantBeCast;

public abstract class AbilityActivated
extends SpellAbility
implements Cloneable {
    public AbilityActivated(Card card, String manacost) {
        this(card, new Cost(manacost, true), (TargetRestrictions)null);
    }

    public AbilityActivated(Card sourceCard, Cost abCost, TargetRestrictions tgt) {
        super(sourceCard, abCost);
        this.setTargetRestrictions(tgt);
    }

    @Override
    public boolean isActivatedAbility() {
        return !this.isTrigger();
    }

    @Override
    public boolean canPlay() {
        Game game;
        if (this.getPayCosts().hasManaCost() && this.getPayCosts().getCostMana().getManaCostFor(this).isNoCost()) {
            return false;
        }
        Player player = this.getActivatingPlayer();
        if (player == null) {
            player = this.getHostCard().getController();
        }
        if ((game = player.getGame()).getStack().isSplitSecondOnStack() && !this.isManaAbility()) {
            return false;
        }
        Card c = this.getHostCard();
        if (c.hasKeyword("CARDNAME's activated abilities can't be activated.") || this.isSuppressed()) {
            return false;
        }
        if (!this.getRestrictions().canPlay(c, this)) {
            return false;
        }
        return CostPayment.canPayAdditionalCosts(this.getPayCosts(), this, false);
    }

    @Override
    public boolean checkRestrictions(Card host, Player activator) {
        return !StaticAbilityCantBeCast.cantBeActivatedAbility(this, host, activator);
    }

    @Override
    public boolean isPossible() {
        if (this.getActivatingPlayer() == null) {
            this.setActivatingPlayer(this.getHostCard().getController());
            System.out.println(this.getHostCard().getName() + " Did not have activator set in AbilityActivated.isPossible");
        }
        return this.getRestrictions().checkZoneRestrictions(this.getHostCard(), this) && this.getRestrictions().checkActivatorRestrictions(this.getHostCard(), this);
    }

    @Override
    public boolean promptIfOnlyPossibleAbility() {
        return false;
    }

    public final Object clone() {
        try {
            return super.clone();
        }
        catch (Exception ex) {
            throw new RuntimeException("AbilityActivated : clone() error, " + ex);
        }
    }
}

