/*
 * Decompiled with CFR 0.152.
 */
package forge.game.replacement;

import forge.game.card.Card;
import forge.game.replacement.ReplaceAddCounter;
import forge.game.replacement.ReplaceAssignDealDamage;
import forge.game.replacement.ReplaceAttached;
import forge.game.replacement.ReplaceBeginPhase;
import forge.game.replacement.ReplaceBeginTurn;
import forge.game.replacement.ReplaceCopySpell;
import forge.game.replacement.ReplaceCounter;
import forge.game.replacement.ReplaceDamage;
import forge.game.replacement.ReplaceDealtDamage;
import forge.game.replacement.ReplaceDeclareBlocker;
import forge.game.replacement.ReplaceDestroy;
import forge.game.replacement.ReplaceDraw;
import forge.game.replacement.ReplaceDrawCards;
import forge.game.replacement.ReplaceExplore;
import forge.game.replacement.ReplaceGainLife;
import forge.game.replacement.ReplaceGameLoss;
import forge.game.replacement.ReplaceGameWin;
import forge.game.replacement.ReplaceLearn;
import forge.game.replacement.ReplaceLifeReduced;
import forge.game.replacement.ReplaceLoseMana;
import forge.game.replacement.ReplaceMill;
import forge.game.replacement.ReplaceMoved;
import forge.game.replacement.ReplacePayLife;
import forge.game.replacement.ReplacePlanarDiceResult;
import forge.game.replacement.ReplacePlaneswalk;
import forge.game.replacement.ReplaceProduceMana;
import forge.game.replacement.ReplaceProliferate;
import forge.game.replacement.ReplaceRemoveCounter;
import forge.game.replacement.ReplaceRollDice;
import forge.game.replacement.ReplaceRollPlanarDice;
import forge.game.replacement.ReplaceScry;
import forge.game.replacement.ReplaceSetInMotion;
import forge.game.replacement.ReplaceTap;
import forge.game.replacement.ReplaceToken;
import forge.game.replacement.ReplaceTransform;
import forge.game.replacement.ReplaceTurnFaceUp;
import forge.game.replacement.ReplaceUntap;
import forge.game.replacement.ReplacementEffect;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;

public enum ReplacementType {
    AddCounter(ReplaceAddCounter.class),
    AssignDealDamage(ReplaceAssignDealDamage.class),
    Attached(ReplaceAttached.class),
    BeginPhase(ReplaceBeginPhase.class),
    BeginTurn(ReplaceBeginTurn.class),
    Counter(ReplaceCounter.class),
    CopySpell(ReplaceCopySpell.class),
    CreateToken(ReplaceToken.class),
    DamageDone(ReplaceDamage.class),
    DealtDamage(ReplaceDealtDamage.class),
    DeclareBlocker(ReplaceDeclareBlocker.class),
    Destroy(ReplaceDestroy.class),
    Draw(ReplaceDraw.class),
    DrawCards(ReplaceDrawCards.class),
    Explore(ReplaceExplore.class),
    GainLife(ReplaceGainLife.class),
    GameLoss(ReplaceGameLoss.class),
    GameWin(ReplaceGameWin.class),
    Learn(ReplaceLearn.class),
    LifeReduced(ReplaceLifeReduced.class),
    LoseMana(ReplaceLoseMana.class),
    Mill(ReplaceMill.class),
    Moved(ReplaceMoved.class),
    PayLife(ReplacePayLife.class),
    PlanarDiceResult(ReplacePlanarDiceResult.class),
    Planeswalk(ReplacePlaneswalk.class),
    ProduceMana(ReplaceProduceMana.class),
    Proliferate(ReplaceProliferate.class),
    RemoveCounter(ReplaceRemoveCounter.class),
    RollDice(ReplaceRollDice.class),
    RollPlanarDice(ReplaceRollPlanarDice.class),
    Scry(ReplaceScry.class),
    SetInMotion(ReplaceSetInMotion.class),
    Tap(ReplaceTap.class),
    Transform(ReplaceTransform.class),
    TurnFaceUp(ReplaceTurnFaceUp.class),
    Untap(ReplaceUntap.class);

    Class<? extends ReplacementEffect> clasz;

    private ReplacementType(Class<? extends ReplacementEffect> cls) {
        this.clasz = cls;
    }

    public static ReplacementType smartValueOf(String value) {
        String valToCompate = value.trim();
        for (ReplacementType v : ReplacementType.values()) {
            if (v.name().compareToIgnoreCase(valToCompate) != 0) continue;
            return v;
        }
        throw new RuntimeException("Element " + value + " not found in ReplacementType enum");
    }

    public ReplacementEffect createReplacement(Map<String, String> mapParams, Card host, boolean intrinsic) {
        Constructor<?>[] cc;
        for (Constructor<?> c : cc = this.clasz.getDeclaredConstructors()) {
            Class<?>[] pp = c.getParameterTypes();
            if (!pp[0].isAssignableFrom(Map.class)) continue;
            try {
                ReplacementEffect res = (ReplacementEffect)c.newInstance(mapParams, host, intrinsic);
                res.setMode(this);
                return res;
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        throw new RuntimeException("No constructor found that would take Map as 1st parameter in class " + this.clasz.getName());
    }
}

