/*
 * Decompiled with CFR 0.152.
 */
package forge.game.replacement;

import com.google.common.collect.ImmutableList;
import forge.game.Game;
import forge.game.TriggerReplacementBase;
import forge.game.ability.AbilityFactory;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.ApiType;
import forge.game.card.Card;
import forge.game.card.CardCollectionView;
import forge.game.phase.PhaseType;
import forge.game.replacement.ReplacementEffectView;
import forge.game.replacement.ReplacementLayer;
import forge.game.replacement.ReplacementType;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.util.CardTranslation;
import forge.util.ITranslatable;
import forge.util.Lang;
import forge.util.TextUtil;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public abstract class ReplacementEffect
extends TriggerReplacementBase {
    private static int maxId = 0;
    private int id;
    private ReplacementType mode;
    private ReplacementLayer layer = ReplacementLayer.Other;
    private boolean hasRun = false;
    private List<ReplacementEffect> otherChoices = null;
    private ReplacementEffectView view = null;

    private static int nextId() {
        return ++maxId;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public final void setId(int id) {
        this.id = id;
    }

    public final boolean hasRun() {
        return this.hasRun;
    }

    public ReplacementEffect(Map<String, String> map, Card host, boolean intrinsic) {
        this.id = ReplacementEffect.nextId();
        this.intrinsic = intrinsic;
        this.originalMapParams.putAll(map);
        this.mapParams.putAll(map);
        this.setHostCard(host);
        if (map.containsKey("Layer")) {
            this.setLayer(ReplacementLayer.smartValueOf(map.get("Layer")));
        }
    }

    public ReplacementEffectView getView() {
        if (this.view == null) {
            this.view = new ReplacementEffectView(this);
        } else {
            this.view.updateHostCard(this);
            this.view.updateDescription(this);
        }
        return this.view;
    }

    public final void setHasRun(boolean hasRun) {
        this.hasRun = hasRun;
    }

    public List<ReplacementEffect> getOtherChoices() {
        return this.otherChoices;
    }

    public void setOtherChoices(List<ReplacementEffect> choices) {
        this.otherChoices = choices;
    }

    public abstract boolean canReplace(Map<AbilityKey, Object> var1);

    public boolean requirementsCheck(Game game) {
        return this.requirementsCheck(game, this.getMapParams());
    }

    public boolean requirementsCheck(Game game, Map<String, String> params) {
        if (this.isSuppressed()) {
            return false;
        }
        if (params.containsKey("PlayerTurn") && params.get("PlayerTurn").equals("True") && !game.getPhaseHandler().isPlayerTurn(this.getHostCard().getController())) {
            return false;
        }
        if (params.containsKey("ActivePhases") && !PhaseType.parseRange(params.get("ActivePhases")).contains((Object)game.getPhaseHandler().getPhase())) {
            return false;
        }
        return this.meetsCommonRequirements(params);
    }

    public final ReplacementEffect copy(Card host, boolean lki) {
        SpellAbility overridingAbilityCopy;
        ReplacementEffect res = (ReplacementEffect)this.clone();
        this.copyHelper(res, host);
        SpellAbility sa = this.getOverridingAbility();
        if (sa != null && (overridingAbilityCopy = sa.copy(host, lki)) != null) {
            res.setOverridingAbility(overridingAbilityCopy);
        }
        if (!lki) {
            res.setId(ReplacementEffect.nextId());
            res.setHasRun(false);
            res.setOtherChoices(null);
        }
        res.setActiveZone(this.validHostZones);
        res.setLayer(this.getLayer());
        return res;
    }

    public void setReplacingObjects(Map<AbilityKey, Object> runParams, SpellAbility spellAbility) {
    }

    public ReplacementLayer getLayer() {
        return this.layer;
    }

    public void setLayer(ReplacementLayer layer0) {
        this.layer = layer0;
    }

    public String getDescription() {
        if (this.hasParam("Description") && !this.isSuppressed()) {
            String desc = AbilityUtils.applyDescriptionTextChangeEffects(this.getParam("Description"), this);
            ITranslatable nameSource = this.getHostName(this);
            desc = CardTranslation.translateMultipleDescriptionText(desc, nameSource);
            String translatedName = CardTranslation.getTranslatedName(nameSource);
            desc = TextUtil.fastReplace(desc, "CARDNAME", translatedName);
            if ((desc = TextUtil.fastReplace(desc, "NICKNAME", Lang.getInstance().getNickName(translatedName))).contains("EFFECTSOURCE")) {
                desc = TextUtil.fastReplace(desc, "EFFECTSOURCE", this.getHostCard().getEffectSource().toString());
            }
            if (this.mode == ReplacementType.DamageDone) {
                String varValue;
                SpellAbility repSA = this.getOverridingAbility();
                if (repSA != null && repSA.getApi() == ApiType.ReplaceDamage && repSA.hasParam("Amount") && !StringUtils.isNumeric(varValue = repSA.getParam("Amount")) && (varValue = repSA.getSVar(varValue)).startsWith("Number$")) {
                    desc = desc + " \nShields remain: " + varValue.substring(7);
                }
                if (repSA != null && repSA.getApi() == ApiType.ReplaceSplitDamage) {
                    varValue = repSA.getParamOrDefault("VarName", "1");
                    if (varValue.equals("1")) {
                        desc = desc + " \nShields remain: 1";
                    } else if (!StringUtils.isNumeric(varValue) && (varValue = repSA.getSVar(varValue)).startsWith("Number$")) {
                        desc = desc + " \nShields remain: " + varValue.substring(7);
                    }
                }
            }
            return desc;
        }
        return "";
    }

    public String toString() {
        return this.getHostCard().toString() + " - " + this.getDescription();
    }

    public final Object clone() {
        try {
            return super.clone();
        }
        catch (Exception ex) {
            throw new RuntimeException("ReplacementEffect : clone() error, " + ex);
        }
    }

    public final boolean equals(Object o) {
        if (!(o instanceof ReplacementEffect)) {
            return false;
        }
        return this.getId() == ((ReplacementEffect)o).getId();
    }

    public int hashCode() {
        return Objects.hash(ReplacementEffect.class, this.getId());
    }

    public ReplacementType getMode() {
        return this.mode;
    }

    void setMode(ReplacementType mode) {
        this.mode = mode;
    }

    @Override
    public SpellAbility ensureAbility() {
        SpellAbility sa = this.getOverridingAbility();
        if (sa == null && this.hasParam("ReplaceWith")) {
            sa = AbilityFactory.getAbility(this.getHostCard(), this.getParam("ReplaceWith"));
            this.setOverridingAbility(sa);
        }
        return sa;
    }

    @Override
    public List<Object> getTriggerRemembered() {
        return ImmutableList.of();
    }

    protected boolean canReplaceETB(Map<AbilityKey, Object> runParams) {
        if (!this.hasParam("ValidCard") || !this.getParam("ValidCard").startsWith("Card.Self")) {
            CardCollectionView lastBattlefield;
            if (this.getHostCard().equals(runParams.get((Object)AbilityKey.Affected))) {
                return false;
            }
            if (this.getActiveZone() != null && this.getActiveZone().contains((Object)ZoneType.Battlefield) && runParams.containsKey((Object)AbilityKey.LastStateBattlefield) && (lastBattlefield = (CardCollectionView)runParams.get((Object)AbilityKey.LastStateBattlefield)) != null && !lastBattlefield.contains(this.getHostCard())) {
                return false;
            }
        }
        return true;
    }

    public boolean modeCheck(ReplacementType event, Map<AbilityKey, Object> runParams) {
        return event.equals((Object)this.getMode());
    }
}

