/*
 * Decompiled with CFR 0.152.
 */
package forge.game.replacement;

import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.replacement.ReplacementEffect;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import java.util.Map;

public class ReplaceMoved
extends ReplacementEffect {
    public ReplaceMoved(Map<String, String> mapParams, Card host, boolean intrinsic) {
        super(mapParams, host, intrinsic);
    }

    @Override
    public boolean canReplace(Map<AbilityKey, Object> runParams) {
        Boolean effectOnly;
        Boolean val;
        ZoneType zt;
        if (!this.matchesValidParam("ValidCard", runParams.get((Object)AbilityKey.Affected))) {
            return false;
        }
        if (!this.matchesValidParam("ValidLKI", runParams.get((Object)AbilityKey.CardLKI))) {
            return false;
        }
        if (!this.matchesValidParam("ValidStackSa", runParams.get((Object)AbilityKey.StackSa))) {
            return false;
        }
        if (!this.matchesValidParam("ValidCause", runParams.get((Object)AbilityKey.Cause))) {
            return false;
        }
        if (this.hasParam("Origin")) {
            zt = (ZoneType)((Object)runParams.get((Object)AbilityKey.Origin));
            if (!ZoneType.listValueOf(this.getParam("Origin")).contains((Object)zt)) {
                return false;
            }
        }
        if (this.hasParam("Destination")) {
            zt = (ZoneType)((Object)runParams.get((Object)AbilityKey.Destination));
            if (!ZoneType.listValueOf(this.getParam("Destination")).contains((Object)zt)) {
                return false;
            }
        }
        if (this.hasParam("ExcludeDestination")) {
            zt = (ZoneType)((Object)runParams.get((Object)AbilityKey.Destination));
            if (ZoneType.listValueOf(this.getParam("ExcludeDestination")).contains((Object)zt)) {
                return false;
            }
        }
        if (this.hasParam("Fizzle")) {
            if (!runParams.containsKey((Object)AbilityKey.Fizzle)) {
                return false;
            }
            val = (Boolean)runParams.get((Object)AbilityKey.Fizzle);
            if ("True".equals(this.getParam("Fizzle")) != val.booleanValue()) {
                return false;
            }
        }
        if (this.hasParam("Cycling") && this.getParam("Cycling").equalsIgnoreCase("True") != runParams.containsKey((Object)AbilityKey.Cycling)) {
            return false;
        }
        if (this.hasParam("Discard") && this.getParam("Discard").equalsIgnoreCase("True") != runParams.containsKey((Object)AbilityKey.Discard)) {
            return false;
        }
        if (this.hasParam("EffectOnly") && !(effectOnly = (Boolean)runParams.get((Object)AbilityKey.EffectOnly)).booleanValue()) {
            return false;
        }
        if (this.hasParam("FoundSearchingLibrary")) {
            if (!runParams.containsKey((Object)AbilityKey.FoundSearchingLibrary)) {
                return false;
            }
            val = (Boolean)runParams.get((Object)AbilityKey.FoundSearchingLibrary);
            if (!val.booleanValue()) {
                return false;
            }
        }
        return runParams.get((Object)AbilityKey.Destination) != ZoneType.Battlefield || this.canReplaceETB(runParams);
    }

    @Override
    public void setReplacingObjects(Map<AbilityKey, Object> runParams, SpellAbility sa) {
        sa.setReplacingObject(AbilityKey.Card, runParams.get((Object)AbilityKey.Affected));
        sa.setReplacingObjectsFrom(runParams, AbilityKey.NewCard, AbilityKey.CardLKI, AbilityKey.Cause, AbilityKey.LastStateBattlefield, AbilityKey.LastStateGraveyard, AbilityKey.CounterTable, AbilityKey.CounterMap);
    }
}

