/*
 * Decompiled with CFR 0.152.
 */
package forge.game.replacement;

import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.player.Player;
import forge.game.replacement.ReplacementEffect;
import forge.game.spellability.SpellAbility;
import forge.util.Expressions;
import java.util.Map;

public class ReplaceLifeReduced
extends ReplacementEffect {
    public ReplaceLifeReduced(Map<String, String> map, Card host, boolean intrinsic) {
        super(map, host, intrinsic);
    }

    @Override
    public boolean canReplace(Map<AbilityKey, Object> runParams) {
        int operandValue;
        String comparator;
        String operator;
        int n;
        int amount = (Integer)runParams.get((Object)AbilityKey.Amount);
        Player affected = (Player)runParams.get((Object)AbilityKey.Affected);
        if (amount <= 0) {
            return false;
        }
        if (!this.matchesValidParam("ValidPlayer", affected)) {
            return false;
        }
        if (this.hasParam("IsDamage") && this.getParam("IsDamage").equals("True") != ((Boolean)runParams.get((Object)AbilityKey.IsDamage)).booleanValue()) {
            return false;
        }
        return !this.hasParam("Result") || Expressions.compare(n = affected.getLife() - amount, operator = (comparator = this.getParam("Result")).substring(0, 2), operandValue = Integer.parseInt(comparator.substring(2)));
    }

    @Override
    public void setReplacingObjects(Map<AbilityKey, Object> runParams, SpellAbility sa) {
        sa.setReplacingObjectsFrom(runParams, AbilityKey.Amount);
        sa.setReplacingObject(AbilityKey.Player, runParams.get((Object)AbilityKey.Affected));
    }
}

