/*
 * Decompiled with CFR 0.152.
 */
package forge.game.replacement;

import forge.game.Game;
import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.replacement.ReplacementEffect;
import forge.game.spellability.SpellAbility;
import java.util.Map;

public class ReplaceDraw
extends ReplacementEffect {
    public ReplaceDraw(Map<String, String> params, Card host, boolean intrinsic) {
        super(params, host, intrinsic);
    }

    @Override
    public boolean canReplace(Map<AbilityKey, Object> runParams) {
        if (!this.matchesValidParam("ValidPlayer", runParams.get((Object)AbilityKey.Affected))) {
            return false;
        }
        if (!this.matchesValidParam("ValidCause", runParams.get((Object)AbilityKey.Cause))) {
            return false;
        }
        if (this.hasParam("NotFirstCardInDrawStep")) {
            Game game = this.getHostCard().getGame();
            Player p = (Player)runParams.get((Object)AbilityKey.Affected);
            if (p.numDrawnThisDrawStep() == 0 && game.getPhaseHandler().is(PhaseType.DRAW, p)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void setReplacingObjects(Map<AbilityKey, Object> runParams, SpellAbility sa) {
        SpellAbility cause;
        sa.setReplacingObject(AbilityKey.Player, runParams.get((Object)AbilityKey.Affected));
        if (runParams.containsKey((Object)AbilityKey.Cause) && (cause = (SpellAbility)runParams.get((Object)AbilityKey.Cause)) != null) {
            sa.setReplacingObject(AbilityKey.Cause, cause);
            sa.setReplacingObject(AbilityKey.Source, cause.getHostCard());
        }
    }
}

