/*
 * Decompiled with CFR 0.152.
 */
package forge.game.replacement;

import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.replacement.ReplacementEffect;
import forge.game.spellability.SpellAbility;
import java.util.Map;

public class ReplaceDestroy
extends ReplacementEffect {
    public ReplaceDestroy(Map<String, String> params, Card host, boolean intrinsic) {
        super(params, host, intrinsic);
    }

    @Override
    public boolean canReplace(Map<AbilityKey, Object> runParams) {
        if (!this.matchesValidParam("ValidCard", runParams.get((Object)AbilityKey.Affected))) {
            return false;
        }
        if (this.hasParam("Regeneration")) {
            Card card = (Card)runParams.get((Object)AbilityKey.Affected);
            if (!runParams.containsKey((Object)AbilityKey.Regeneration) || !((Boolean)runParams.get((Object)AbilityKey.Regeneration)).booleanValue()) {
                return false;
            }
            if (!card.canBeShielded()) {
                return false;
            }
            if (card.isCreature() && card.getNetToughness() <= 0) {
                return false;
            }
        }
        return this.matchesValidParam("ValidCause", runParams.get((Object)AbilityKey.Cause));
    }

    @Override
    public void setReplacingObjects(Map<AbilityKey, Object> runParams, SpellAbility sa) {
        sa.setReplacingObject(AbilityKey.Card, runParams.get((Object)AbilityKey.Affected));
        sa.setReplacingObjectsFrom(runParams, AbilityKey.Cause);
    }
}

