/*
 * Decompiled with CFR 0.152.
 */
package forge.game.replacement;

import forge.game.Game;
import forge.game.GameEntity;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.player.Player;
import forge.game.replacement.ReplacementEffect;
import forge.game.spellability.SpellAbility;
import forge.util.Expressions;
import java.util.Map;

public class ReplaceDamage
extends ReplacementEffect {
    public ReplaceDamage(Map<String, String> map, Card host, boolean intrinsic) {
        super(map, host, intrinsic);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canReplace(Map<AbilityKey, Object> runParams) {
        SpellAbility cause;
        Game game = this.getHostCard().getGame();
        if ((Integer)runParams.get((Object)AbilityKey.DamageAmount) == 0) {
            return false;
        }
        if (!this.matchesValidParam("ValidSource", runParams.get((Object)AbilityKey.DamageSource))) {
            return false;
        }
        if (!this.matchesValidParam("ValidTarget", runParams.get((Object)AbilityKey.Affected))) {
            return false;
        }
        if (!this.matchesValidParam("ValidCause", runParams.get((Object)AbilityKey.Cause))) {
            return false;
        }
        if (this.hasParam("CauseIsSource") && !(cause = (SpellAbility)runParams.get((Object)AbilityKey.Cause)).getHostCard().equals(runParams.get((Object)AbilityKey.DamageSource))) {
            return false;
        }
        if (this.hasParam("RelativeToSource")) {
            Card source = (Card)runParams.get((Object)AbilityKey.DamageSource);
            String validRelative = this.getParam("RelativeToSource");
            if (!this.matchesValid(runParams.get((Object)AbilityKey.DamageTarget), validRelative.split(","), source)) {
                return false;
            }
        }
        if (this.hasParam("DamageAmount")) {
            String full = this.getParam("DamageAmount");
            String operator = full.substring(0, 2);
            String operand = full.substring(2);
            int intoperand = AbilityUtils.calculateAmount(this.getHostCard(), operand, this);
            if (!Expressions.compare((Integer)runParams.get((Object)AbilityKey.DamageAmount), operator, intoperand)) {
                return false;
            }
        }
        if (this.hasParam("IsCombat") && this.getParam("IsCombat").equals("True") != ((Boolean)runParams.get((Object)AbilityKey.IsCombat)).booleanValue()) {
            return false;
        }
        if (this.hasParam("IsEquipping") && !this.getHostCard().isEquipping()) {
            return false;
        }
        if (!this.hasParam("DamageTarget")) return true;
        cause = (SpellAbility)runParams.get((Object)AbilityKey.Cause);
        GameEntity affected = (GameEntity)runParams.get((Object)AbilityKey.Affected);
        if (cause != null && cause.hasParam("NoRedirection") || affected.hasKeyword("Damage that would be dealt to CARDNAME can't be redirected.")) {
            return false;
        }
        String def = this.getParam("DamageTarget");
        if (def.startsWith("Replaced")) {
            if (def.equals("ReplacedSourceController")) {
                Card source = (Card)runParams.get((Object)AbilityKey.DamageSource);
                if (game.getPlayers().contains(source.getController())) return true;
                return false;
            }
            if (!def.equals("ReplacedTargetController")) return false;
            if (affected instanceof Card && game.getPlayers().contains(((Card)affected).getController())) return true;
            return false;
        }
        for (Player p : AbilityUtils.getDefinedPlayers(this.getHostCard(), def, this)) {
            if (p.isInGame()) continue;
            return false;
        }
        for (Card c : AbilityUtils.getDefinedCards(this.getHostCard(), def, this)) {
            if (!(c.isCreature() || c.isPlaneswalker() || c.isBattle())) {
                return false;
            }
            if (c.isInPlay()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setReplacingObjects(Map<AbilityKey, Object> runParams, SpellAbility sa) {
        sa.setReplacingObject(AbilityKey.DamageAmount, runParams.get((Object)AbilityKey.DamageAmount));
        sa.setReplacingObject(AbilityKey.Target, runParams.get((Object)AbilityKey.Affected));
        sa.setReplacingObject(AbilityKey.Source, runParams.get((Object)AbilityKey.DamageSource));
    }
}

