/*
 * Decompiled with CFR 0.152.
 */
package forge.game.replacement;

import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.player.Player;
import forge.game.replacement.ReplacementEffect;
import forge.game.replacement.ReplacementLayer;
import forge.game.spellability.SpellAbility;
import java.util.Map;

public class ReplaceBeginPhase
extends ReplacementEffect {
    public ReplaceBeginPhase(Map<String, String> mapParams, Card host, boolean intrinsic) {
        super(mapParams, host, intrinsic);
        if (!mapParams.containsKey("Layer")) {
            this.setLayer(ReplacementLayer.Control);
        }
    }

    @Override
    public boolean canReplace(Map<AbilityKey, Object> runParams) {
        Player affected = (Player)runParams.get((Object)AbilityKey.Affected);
        if (!this.matchesValidParam("ValidPlayer", affected)) {
            return false;
        }
        if (this.hasParam("Phase")) {
            String phase = this.getParam("Phase");
            String currentPhase = (String)runParams.get((Object)AbilityKey.Phase);
            if (phase.equals("Combat") && currentPhase.equals("BeginCombat")) {
                return true;
            }
            if (phase.equals("Main") && (currentPhase.equals("Main1") || currentPhase.equals("Main2"))) {
                return true;
            }
            if (!phase.equals(currentPhase)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void setReplacingObjects(Map<AbilityKey, Object> runParams, SpellAbility sa) {
        sa.setReplacingObject(AbilityKey.Player, runParams.get((Object)AbilityKey.Affected));
    }
}

