/*
 * Decompiled with CFR 0.152.
 */
package forge.game.replacement;

import com.google.common.base.Optional;
import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.card.CounterType;
import forge.game.player.Player;
import forge.game.replacement.ReplacementEffect;
import forge.game.replacement.ReplacementType;
import forge.game.spellability.SpellAbility;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;

public class ReplaceAddCounter
extends ReplacementEffect {
    public ReplaceAddCounter(Map<String, String> mapParams, Card host, boolean intrinsic) {
        super(mapParams, host, intrinsic);
    }

    @Override
    public boolean canReplace(Map<AbilityKey, Object> runParams) {
        Boolean effectOnly;
        if (this.hasParam("EffectOnly") && !(effectOnly = (Boolean)runParams.get((Object)AbilityKey.EffectOnly)).booleanValue()) {
            return false;
        }
        if (!this.matchesValidParam("ValidCard", runParams.get((Object)AbilityKey.Affected))) {
            return false;
        }
        if (!this.matchesValidParam("ValidPlayer", runParams.get((Object)AbilityKey.Affected))) {
            return false;
        }
        if (!this.matchesValidParam("ValidObject", runParams.get((Object)AbilityKey.Affected))) {
            return false;
        }
        if (!this.matchesValidParam("ValidCause", runParams.get((Object)AbilityKey.Cause))) {
            return false;
        }
        if (!this.hasAnyInCounterMap(runParams)) {
            return false;
        }
        return !runParams.containsKey((Object)AbilityKey.Destination) || this.canReplaceETB(runParams);
    }

    @Override
    public void setReplacingObjects(Map<AbilityKey, Object> runParams, SpellAbility sa) {
        sa.setReplacingObject(AbilityKey.CounterMap, runParams.get((Object)AbilityKey.CounterMap));
        Object o = runParams.get((Object)AbilityKey.Affected);
        if (o instanceof Card) {
            sa.setReplacingObject(AbilityKey.Card, o);
        } else if (o instanceof Player) {
            sa.setReplacingObject(AbilityKey.Player, o);
        }
        sa.setReplacingObject(AbilityKey.Object, o);
    }

    public boolean hasAnyInCounterMap(Map<AbilityKey, Object> runParams) {
        Map counterMap = (Map)runParams.get((Object)AbilityKey.CounterMap);
        for (Map.Entry e : counterMap.entrySet()) {
            if (!this.matchesValidParam("ValidSource", ((Optional)e.getKey()).orNull())) continue;
            if (this.hasParam("ValidCounterType")) {
                CounterType ct = CounterType.getType(this.getParam("ValidCounterType"));
                if (!((Map)e.getValue()).containsKey(ct) || 0 >= ObjectUtils.defaultIfNull((Integer)((Map)e.getValue()).get(ct), 0)) continue;
                return true;
            }
            Iterator iterator = ((Map)e.getValue()).values().iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                if (i <= 0) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean modeCheck(ReplacementType event, Map<AbilityKey, Object> runParams) {
        if (super.modeCheck(event, runParams)) {
            return true;
        }
        return event.equals((Object)ReplacementType.Moved) && runParams.containsKey((Object)AbilityKey.CounterMap);
    }
}

