/*
 * Decompiled with CFR 0.152.
 */
package forge.game.player;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import forge.LobbyPlayer;
import forge.deck.CardPool;
import forge.deck.Deck;
import forge.deck.DeckSection;
import forge.game.GameType;
import forge.item.IPaperCard;
import forge.item.PaperCard;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class RegisteredPlayer {
    private final Deck originalDeck;
    private Deck currentDeck;
    private static final Iterable<PaperCard> EmptyList = Collections.emptyList();
    private LobbyPlayer player = null;
    private int startingLife = 20;
    private int startingHand = 7;
    private int manaShards = 0;
    private Iterable<IPaperCard> cardsOnBattlefield = null;
    private Iterable<IPaperCard> extraCardsOnBattlefield = null;
    private Iterable<IPaperCard> extraCardsInCommandZone = null;
    private Iterable<? extends IPaperCard> schemes = null;
    private Iterable<PaperCard> planes = null;
    private Iterable<PaperCard> conspiracies = null;
    private Iterable<PaperCard> attractions = null;
    private List<PaperCard> commanders = Lists.newArrayList();
    private List<PaperCard> vanguardAvatars = null;
    private PaperCard planeswalker = null;
    private int teamNumber = -1;
    private Integer id = null;
    private boolean randomFoil = false;
    private boolean enableETBCountersEffect = false;

    public RegisteredPlayer(Deck deck0) {
        this.originalDeck = deck0;
        this.restoreDeck();
    }

    public final Integer getId() {
        return this.id;
    }

    public final void setId(Integer id0) {
        this.id = id0;
    }

    public final Deck getDeck() {
        return this.currentDeck;
    }

    public final int getStartingLife() {
        return this.startingLife;
    }

    public final void setStartingLife(int startingLife) {
        this.startingLife = startingLife;
    }

    public final int getManaShards() {
        return this.manaShards;
    }

    public final void setManaShards(int manaShards) {
        this.manaShards = manaShards;
    }

    public boolean hasEnableETBCountersEffect() {
        return this.enableETBCountersEffect;
    }

    public void setEnableETBCountersEffect(boolean value) {
        this.enableETBCountersEffect = value;
    }

    public final Iterable<? extends IPaperCard> getCardsOnBattlefield() {
        return Iterables.concat(this.cardsOnBattlefield == null ? EmptyList : this.cardsOnBattlefield, this.extraCardsOnBattlefield == null ? EmptyList : this.extraCardsOnBattlefield);
    }

    public final Iterable<? extends IPaperCard> getExtraCardsInCommandZone() {
        return this.extraCardsInCommandZone == null ? EmptyList : this.extraCardsInCommandZone;
    }

    public final void setCardsOnBattlefield(Iterable<IPaperCard> cardsOnTable) {
        this.cardsOnBattlefield = cardsOnTable;
    }

    public final void addExtraCardsOnBattlefield(Iterable<IPaperCard> extraCardsonTable) {
        this.extraCardsOnBattlefield = this.extraCardsOnBattlefield == null ? extraCardsonTable : Iterables.concat(this.extraCardsOnBattlefield, extraCardsonTable);
    }

    public final void addExtraCardsInCommandZone(Iterable<IPaperCard> extraCardsInCommandZone) {
        this.extraCardsInCommandZone = this.extraCardsInCommandZone == null ? extraCardsInCommandZone : Iterables.concat(this.extraCardsInCommandZone, extraCardsInCommandZone);
    }

    public int getStartingHand() {
        return this.startingHand;
    }

    public void setStartingHand(int startingHand0) {
        this.startingHand = startingHand0;
    }

    public Iterable<? extends IPaperCard> getSchemes() {
        return this.schemes == null ? EmptyList : this.schemes;
    }

    public Iterable<PaperCard> getPlanes() {
        return this.planes == null ? EmptyList : this.planes;
    }

    public void setPlanes(Iterable<PaperCard> planes0) {
        this.planes = planes0;
    }

    public Iterable<PaperCard> getConspiracies() {
        return this.conspiracies == null ? EmptyList : this.conspiracies;
    }

    public void assignConspiracies() {
        if (this.currentDeck.has(DeckSection.Conspiracy)) {
            this.conspiracies = this.currentDeck.get(DeckSection.Conspiracy).toFlatList();
        }
    }

    public int getTeamNumber() {
        return this.teamNumber;
    }

    public void setTeamNumber(int teamNumber0) {
        this.teamNumber = teamNumber0;
    }

    public static RegisteredPlayer forCommander(Deck deck) {
        RegisteredPlayer start = new RegisteredPlayer(deck);
        start.commanders = deck.getCommanders();
        start.setStartingLife(40);
        return start;
    }

    public static RegisteredPlayer forVariants(int playerCount, Set<GameType> appliedVariants, Deck deck, Iterable<PaperCard> schemes, boolean playerIsArchenemy, Iterable<PaperCard> planes, CardPool vanguardAvatar) {
        RegisteredPlayer start = new RegisteredPlayer(deck);
        if (appliedVariants.contains((Object)GameType.Archenemy) && playerIsArchenemy) {
            start.setStartingLife(40);
            start.schemes = schemes;
        }
        if (appliedVariants.contains((Object)GameType.ArchenemyRumble)) {
            start.setStartingLife(40);
            start.schemes = schemes;
        }
        if (appliedVariants.contains((Object)GameType.Commander)) {
            start.commanders = deck.getCommanders();
            start.setStartingLife(start.getStartingLife() + 20);
        }
        if (appliedVariants.contains((Object)GameType.Oathbreaker)) {
            start.commanders = deck.getCommanders();
        }
        if (appliedVariants.contains((Object)GameType.TinyLeaders)) {
            start.commanders = deck.getCommanders();
            start.setStartingLife(start.getStartingLife() + 5);
        }
        if (appliedVariants.contains((Object)GameType.Brawl)) {
            start.commanders = deck.getCommanders();
            start.setStartingLife(start.getStartingLife() + 10);
        }
        if (appliedVariants.contains((Object)GameType.Planechase)) {
            start.planes = planes;
        }
        if (appliedVariants.contains((Object)GameType.Vanguard) || appliedVariants.contains((Object)GameType.MomirBasic) || appliedVariants.contains((Object)GameType.MoJhoSto)) {
            start.setVanguardAvatars(vanguardAvatar == null ? deck.get(DeckSection.Avatar).toFlatList() : vanguardAvatar.toFlatList());
        }
        return start;
    }

    public LobbyPlayer getPlayer() {
        return this.player;
    }

    public RegisteredPlayer setPlayer(LobbyPlayer player0) {
        this.player = player0;
        return this;
    }

    public List<PaperCard> getCommanders() {
        return this.commanders;
    }

    public void assignCommander() {
        this.commanders = this.currentDeck.getCommanders();
    }

    public List<PaperCard> getVanguardAvatars() {
        return this.vanguardAvatars;
    }

    public void assignVanguardAvatar() {
        CardPool section = this.currentDeck.get(DeckSection.Avatar);
        this.setVanguardAvatars(section == null ? null : section.toFlatList());
    }

    private void setVanguardAvatars(List<PaperCard> vanguardAvatars0) {
        this.vanguardAvatars = vanguardAvatars0;
        if (this.vanguardAvatars == null) {
            return;
        }
        for (PaperCard avatar : this.vanguardAvatars) {
            this.setStartingLife(this.getStartingLife() + avatar.getRules().getLife());
            this.setStartingHand(this.getStartingHand() + avatar.getRules().getHand());
        }
    }

    public PaperCard getPlaneswalker() {
        return this.planeswalker;
    }

    public void setPlaneswalker(PaperCard planeswalker0) {
        this.planeswalker = planeswalker0;
        if (this.planeswalker != null) {
            this.currentDeck.getMain().remove(this.planeswalker);
        }
    }

    public Iterable<PaperCard> getAttractions() {
        return this.attractions;
    }

    private void assignAttractions() {
        this.attractions = this.currentDeck.has(DeckSection.Attractions) ? this.currentDeck.get(DeckSection.Attractions).toFlatList() : EmptyList;
    }

    public void restoreDeck() {
        this.currentDeck = (Deck)this.originalDeck.copyTo(this.originalDeck.getName());
        this.assignAttractions();
    }

    public boolean useRandomFoil() {
        return this.randomFoil;
    }

    public void setRandomFoil(boolean useRandomFoil) {
        this.randomFoil = useRandomFoil;
    }
}

