/*
 * Decompiled with CFR 0.152.
 */
package forge.game.player;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.google.common.collect.TreeBasedTable;
import forge.ImageKeys;
import forge.LobbyPlayer;
import forge.card.CardStateName;
import forge.card.CardType;
import forge.card.ColorSet;
import forge.card.GamePieceType;
import forge.card.MagicColor;
import forge.card.mana.ManaCost;
import forge.card.mana.ManaCostShard;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.GameActionUtil;
import forge.game.GameEntity;
import forge.game.GameEntityCounterTable;
import forge.game.GameLogEntryType;
import forge.game.GameStage;
import forge.game.GameType;
import forge.game.ability.AbilityFactory;
import forge.game.ability.AbilityKey;
import forge.game.ability.ApiType;
import forge.game.ability.effects.DetachedCardEffect;
import forge.game.ability.effects.RollDiceEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardCopyService;
import forge.game.card.CardFactoryUtil;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CardUtil;
import forge.game.card.CounterEnumType;
import forge.game.card.CounterType;
import forge.game.event.GameEventCardSacrificed;
import forge.game.event.GameEventLandPlayed;
import forge.game.event.GameEventManaBurn;
import forge.game.event.GameEventMulligan;
import forge.game.event.GameEventPlayerControl;
import forge.game.event.GameEventPlayerCounters;
import forge.game.event.GameEventPlayerDamaged;
import forge.game.event.GameEventPlayerLivesChanged;
import forge.game.event.GameEventPlayerPoisoned;
import forge.game.event.GameEventPlayerRadiation;
import forge.game.event.GameEventPlayerShardsChanged;
import forge.game.event.GameEventPlayerStatsChanged;
import forge.game.event.GameEventShuffle;
import forge.game.event.GameEventSurveil;
import forge.game.keyword.Companion;
import forge.game.keyword.Keyword;
import forge.game.keyword.KeywordCollection;
import forge.game.keyword.KeywordInterface;
import forge.game.keyword.KeywordsChange;
import forge.game.mana.ManaPool;
import forge.game.phase.PhaseHandler;
import forge.game.phase.PhaseType;
import forge.game.player.AchievementTracker;
import forge.game.player.GameLossReason;
import forge.game.player.IGameEntitiesFactory;
import forge.game.player.PlayerCollection;
import forge.game.player.PlayerController;
import forge.game.player.PlayerOutcome;
import forge.game.player.PlayerPredicates;
import forge.game.player.PlayerProperty;
import forge.game.player.PlayerStatistics;
import forge.game.player.PlayerView;
import forge.game.player.RegisteredPlayer;
import forge.game.replacement.ReplacementEffect;
import forge.game.replacement.ReplacementHandler;
import forge.game.replacement.ReplacementResult;
import forge.game.replacement.ReplacementType;
import forge.game.spellability.AbilitySub;
import forge.game.spellability.SpellAbility;
import forge.game.staticability.StaticAbility;
import forge.game.staticability.StaticAbilityCantBeCast;
import forge.game.staticability.StaticAbilityCantBecomeMonarch;
import forge.game.staticability.StaticAbilityCantDiscard;
import forge.game.staticability.StaticAbilityCantDraw;
import forge.game.staticability.StaticAbilityCantGainLosePayLife;
import forge.game.staticability.StaticAbilityCantPutCounter;
import forge.game.staticability.StaticAbilityCantSetSchemesInMotion;
import forge.game.staticability.StaticAbilityCantTarget;
import forge.game.staticability.StaticAbilitySurveilNum;
import forge.game.trigger.Trigger;
import forge.game.trigger.TriggerHandler;
import forge.game.trigger.TriggerType;
import forge.game.zone.PlayerZone;
import forge.game.zone.PlayerZoneBattlefield;
import forge.game.zone.Zone;
import forge.game.zone.ZoneType;
import forge.item.IPaperCard;
import forge.item.PaperCard;
import forge.util.Aggregates;
import forge.util.Lang;
import forge.util.Localizer;
import forge.util.MyRandom;
import forge.util.TextUtil;
import forge.util.collect.FCollection;
import forge.util.collect.FCollectionView;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class Player
extends GameEntity
implements Comparable<Player> {
    public static final List<ZoneType> ALL_ZONES = Collections.unmodifiableList(Arrays.asList(ZoneType.Battlefield, ZoneType.Library, ZoneType.Graveyard, ZoneType.Hand, ZoneType.Exile, ZoneType.Command, ZoneType.Ante, ZoneType.Sideboard, ZoneType.PlanarDeck, ZoneType.SchemeDeck, ZoneType.AttractionDeck, ZoneType.Junkyard, ZoneType.Merged, ZoneType.Subgame, ZoneType.None));
    private final Map<Card, Integer> commanderDamage = Maps.newHashMap();
    private int life = 20;
    private int startingLife;
    private int lifeStartedThisTurnWith = this.startingLife = 20;
    private int spellsCastThisTurn;
    private int spellsCastThisGame;
    private int spellsCastLastTurn;
    private List<Card> spellsCastSinceBeginningOfLastTurn = Lists.newArrayList();
    private int landsPlayedThisTurn;
    private int landsPlayedLastTurn;
    private int investigatedThisTurn;
    private int surveilThisTurn;
    private int lifeLostThisTurn;
    private int lifeLostLastTurn;
    private int lifeGainedThisTurn;
    private int lifeGainedTimesThisTurn;
    private int lifeGainedByTeamThisTurn;
    private int committedCrimeThisTurn;
    private int expentThisTurn;
    private int numManaShards;
    private int numPowerSurgeLands;
    private int numLibrarySearchedOwn;
    private int numDrawnThisTurn;
    private int numDrawnLastTurn;
    private int numDrawnThisDrawStep;
    private int numRollsThisTurn;
    private int numExploredThisTurn;
    private int numTokenCreatedThisTurn;
    private int numForetoldThisTurn;
    private int numCardsInHandStartedThisTurnWith;
    private int venturedThisTurn;
    private int maxHandSize = 7;
    private int startingHandSize = 7;
    private boolean unlimitedHandSize = false;
    private Card lastDrawnCard;
    private Card ringBearer;
    private Card theRing;
    private String namedCard = "";
    private int simultaneousDamage = 0;
    private int lastTurnNr = 0;
    private int numRingTemptedYou = 0;
    private final Map<String, FCollection<String>> notes = Maps.newHashMap();
    private final Map<String, Integer> notedNum = Maps.newHashMap();
    private final Map<String, String> draftNotes = Maps.newHashMap();
    private boolean revolt = false;
    private int descended = 0;
    private List<Card> sacrificedThisTurn = new ArrayList<Card>();
    private List<Card> discardedThisTurn = new ArrayList<Card>();
    private CardCollection inboundTokens = new CardCollection();
    private KeywordCollection keywords = new KeywordCollection();
    private final Table<Long, String, KeywordInterface> storedKeywords = TreeBasedTable.create();
    private Map<Card, DetachedCardEffect> staticAbilities = Maps.newHashMap();
    private Table<Long, Long, KeywordsChange> changedKeywords = TreeBasedTable.create();
    private ManaPool manaPool = new ManaPool(this);
    private Map<GameEntity, List<Card>> attackedThisTurn = new HashMap<GameEntity, List<Card>>();
    private List<Player> attackedPlayersLastTurn = new ArrayList<Player>();
    private List<Player> attackedPlayersThisCombat = new ArrayList<Player>();
    private boolean beenDealtCombatDamageSinceLastTurn = false;
    private boolean activateLoyaltyAbilityThisTurn = false;
    private boolean tappedLandForManaThisTurn = false;
    private List<Card> completedDungeons = new ArrayList<Card>();
    private final Map<ZoneType, PlayerZone> zones = Maps.newEnumMap(ZoneType.class);
    private List<PlayerZone> extraZones = null;
    private final Map<Long, Integer> adjustLandPlays = Maps.newHashMap();
    private final Set<Long> adjustLandPlaysInfinite = Sets.newHashSet();
    private Map<Card, Card> maingameCardsMap = Maps.newHashMap();
    private CardCollection currentPlanes = new CardCollection();
    private CardCollection planeswalkedToThisTurn = new CardCollection();
    private PlayerStatistics stats = new PlayerStatistics();
    private PlayerController controller;
    private NavigableMap<Long, Pair<Player, PlayerController>> controlledBy = Maps.newTreeMap();
    private NavigableMap<Long, Player> controlledWhileSearching = Maps.newTreeMap();
    private int teamNumber = -1;
    private Card activeScheme = null;
    private final CardCollection commanders = new CardCollection();
    private final Map<Card, Integer> commanderCast = Maps.newHashMap();
    private DetachedCardEffect commanderEffect = null;
    private final Game game;
    private boolean triedToDrawFromEmptyLibrary = false;
    private CardCollection lostOwnership = new CardCollection();
    private CardCollection gainedOwnership = new CardCollection();
    private int numManaConversion = 0;
    private Deque<SpellAbility> paidForStack = new ArrayDeque<SpellAbility>();
    private Card monarchEffect;
    private Card initiativeEffect;
    private Card blessingEffect;
    private Card radiationEffect;
    private Card keywordEffect;
    private Map<Long, Integer> additionalVotes = Maps.newHashMap();
    private Map<Long, Integer> additionalOptionalVotes = Maps.newHashMap();
    private SortedSet<Long> controlVotes = Sets.newTreeSet();
    private Map<Long, Integer> additionalVillainousChoices = Maps.newHashMap();
    private NavigableMap<Long, Player> declaresAttackers = Maps.newTreeMap();
    private NavigableMap<Long, Player> declaresBlockers = Maps.newTreeMap();
    private final AchievementTracker achievementTracker = new AchievementTracker();
    private final PlayerView view;

    public Player(String name0, Game game0, int id0) {
        super(id0);
        this.game = game0;
        for (ZoneType z : ALL_ZONES) {
            PlayerZone toPut = z == ZoneType.Battlefield ? new PlayerZoneBattlefield(z, this) : new PlayerZone(z, this);
            this.zones.put(z, toPut);
        }
        this.view = new PlayerView(id0, this.game.getTracker());
        this.view.updateMaxHandSize(this);
        this.view.updateKeywords(this);
        this.view.updateMaxLandPlay(this);
        this.view.setDraftNotes(this.getDraftNotes());
        this.setName(this.chooseName(name0));
        if (id0 >= 0) {
            this.game.addPlayer(this.id, this);
        }
    }

    public final AchievementTracker getAchievementTracker() {
        return this.achievementTracker;
    }

    public final PlayerOutcome getOutcome() {
        return this.stats.getOutcome();
    }

    private String chooseName(String originalName) {
        String nameCandidate = originalName;
        for (int i = 2; i <= 8; ++i) {
            boolean haveDuplicates = false;
            for (Player p : this.game.getPlayers()) {
                if (!p.getName().equals(nameCandidate)) continue;
                haveDuplicates = true;
                break;
            }
            if (!haveDuplicates) {
                return nameCandidate;
            }
            nameCandidate = Lang.getInstance().getOrdinal(i) + " " + originalName;
        }
        return nameCandidate;
    }

    @Override
    public Game getGame() {
        return this.game;
    }

    public final PlayerStatistics getStats() {
        return this.stats;
    }

    public final int getTeam() {
        return this.teamNumber;
    }

    public final void setTeam(int iTeam) {
        this.teamNumber = iTeam;
    }

    public boolean isArchenemy() {
        return this.getZone(ZoneType.SchemeDeck).size() > 0;
    }

    public Card getActiveScheme() {
        return this.activeScheme;
    }

    public void setSchemeInMotion(SpellAbility cause) {
        if (StaticAbilityCantSetSchemesInMotion.any(this.getGame())) {
            return;
        }
        if (this.game.getReplacementHandler().run(ReplacementType.SetInMotion, AbilityKey.mapFromAffected(this)) != ReplacementResult.NotReplaced) {
            return;
        }
        EnumMap<AbilityKey, CardCollectionView> moveParams = AbilityKey.newMap();
        moveParams.put(AbilityKey.LastStateBattlefield, this.game.getLastStateBattlefield());
        moveParams.put(AbilityKey.LastStateGraveyard, this.game.getLastStateGraveyard());
        this.activeScheme = this.getZone(ZoneType.SchemeDeck).get(0);
        this.game.getAction().moveToCommand(this.activeScheme, cause);
        EnumMap<AbilityKey, Object> runParams = AbilityKey.newMap();
        runParams.put(AbilityKey.Scheme, this.activeScheme);
        this.game.getTriggerHandler().runTrigger(TriggerType.SetInMotion, runParams, false);
    }

    public final PlayerCollection getOpponents() {
        return this.game.getPlayersInTurnOrder(this).filter(PlayerPredicates.isOpponentOf(this));
    }

    public final PlayerCollection getRegisteredOpponents() {
        return this.game.getRegisteredPlayers().filter(PlayerPredicates.isOpponentOf(this));
    }

    public void updateOpponentsForView() {
        this.view.updateOpponents(this);
    }

    public void updateFlashbackForView() {
        this.view.updateFlashbackForPlayer(this);
    }

    public Player getSingleOpponent() {
        if (this.game.getRegisteredPlayers().size() == 2) {
            for (Player p : this.game.getRegisteredPlayers()) {
                if (!p.isOpponentOf(this)) continue;
                return p;
            }
        }
        return null;
    }

    public final int getOpponentsSmallestLifeTotal() {
        return Aggregates.min(this.getOpponents(), Player::getLife);
    }

    public final int getOpponentsGreatestLifeTotal() {
        return Aggregates.max(this.getOpponents(), Player::getLife);
    }

    public final int getOpponentsTotalPoisonCounters() {
        return Aggregates.sum(this.getOpponents(), Player::getPoisonCounters);
    }

    public final PlayerCollection getAllies() {
        return this.getAllOtherPlayers().filter(Predicates.not(PlayerPredicates.isOpponentOf(this)));
    }

    public final PlayerCollection getTeamMates(boolean inclThis) {
        PlayerCollection col = new PlayerCollection();
        if (inclThis) {
            col.add(this);
        }
        col.addAll(this.getAllOtherPlayers().filter(PlayerPredicates.sameTeam(this)));
        return col;
    }

    public final PlayerCollection getYourTeam() {
        return this.getTeamMates(true);
    }

    public final PlayerCollection getAllOtherPlayers() {
        PlayerCollection result = new PlayerCollection(this.game.getPlayers());
        result.remove(this);
        return result;
    }

    public final Player getWeakestOpponent() {
        return this.getOpponents().min(PlayerPredicates.compareByLife());
    }

    public final Player getStrongestOpponent() {
        return this.getOpponents().max(PlayerPredicates.compareByLife());
    }

    public boolean isOpponentOf(Player other) {
        return other != this && other != null && (other.teamNumber < 0 || other.teamNumber != this.teamNumber);
    }

    public boolean isOpponentOf(String other) {
        Player otherPlayer = null;
        for (Player p : this.game.getPlayers()) {
            if (!p.getName().equals(other)) continue;
            otherPlayer = p;
            break;
        }
        return this.isOpponentOf(otherPlayer);
    }

    public final boolean setLife(int newLife, SpellAbility sa) {
        boolean change = false;
        change = this.life > newLife ? this.loseLife(this.life - newLife, false, false) > 0 : (newLife > this.life ? this.gainLife(newLife - this.life, sa == null ? null : sa.getHostCard(), sa) : false);
        return change;
    }

    public final int getStartingLife() {
        return this.startingLife;
    }

    public final void setStartingLife(int startLife) {
        this.startingLife = startLife;
        this.life = startLife;
        this.view.updateLife(this);
    }

    public final int getLife() {
        return this.life;
    }

    public final boolean gainLife(int lifeGain, Card source, SpellAbility sa) {
        if (!this.canGainLife()) {
            return false;
        }
        Map<AbilityKey, Object> repParams = AbilityKey.mapFromAffected(this);
        repParams.put(AbilityKey.LifeGained, lifeGain);
        repParams.put(AbilityKey.SourceSA, sa);
        switch (this.getGame().getReplacementHandler().run(ReplacementType.GainLife, repParams)) {
            case NotReplaced: {
                break;
            }
            case Updated: {
                if (this.equals(repParams.get((Object)AbilityKey.Affected))) {
                    lifeGain = (Integer)repParams.get((Object)AbilityKey.LifeGained);
                    if (lifeGain > 0) break;
                    return false;
                }
                return false;
            }
            default: {
                return false;
            }
        }
        if (lifeGain > 0) {
            int oldLife = this.life;
            this.life += lifeGain;
            this.view.updateLife(this);
            boolean firstGain = this.lifeGainedTimesThisTurn == 0;
            this.lifeGainedThisTurn += lifeGain;
            ++this.lifeGainedTimesThisTurn;
            for (Player p : this.getTeamMates(true)) {
                p.addLifeGainedByTeamThisTurn(lifeGain);
            }
            Map<AbilityKey, Object> runParams = AbilityKey.mapFromPlayer(this);
            runParams.put(AbilityKey.LifeAmount, lifeGain);
            runParams.put(AbilityKey.Source, source);
            runParams.put(AbilityKey.SourceSA, sa);
            runParams.put(AbilityKey.FirstTime, firstGain);
            this.game.getTriggerHandler().runTrigger(TriggerType.LifeGained, runParams, false);
            this.game.getTriggerHandler().runTrigger(TriggerType.LifeChanged, runParams, false);
            this.game.fireEvent(new GameEventPlayerLivesChanged(this, oldLife, this.life));
            return true;
        }
        System.out.println("Player - trying to gain negative or 0 life");
        return false;
    }

    public final boolean canGainLife() {
        return this.isInGame() && !StaticAbilityCantGainLosePayLife.anyCantGainLife(this);
    }

    public final int loseLife(int toLose, boolean damage, boolean manaBurn) {
        if (toLose <= 0 || !this.canLoseLife()) {
            return 0;
        }
        int oldLife = this.life;
        Map<AbilityKey, Object> repParams = AbilityKey.mapFromAffected(this);
        repParams.put(AbilityKey.Amount, toLose);
        repParams.put(AbilityKey.IsDamage, damage);
        switch (this.getGame().getReplacementHandler().run(ReplacementType.LifeReduced, repParams)) {
            case NotReplaced: {
                break;
            }
            case Updated: {
                if (this.equals(repParams.get((Object)AbilityKey.Affected))) {
                    toLose = (Integer)repParams.get((Object)AbilityKey.Amount);
                    if (toLose > 0) break;
                    return 0;
                }
                return 0;
            }
            default: {
                return 0;
            }
        }
        this.life -= toLose;
        this.view.updateLife(this);
        if (manaBurn) {
            this.game.fireEvent(new GameEventManaBurn(this, toLose, true));
        } else {
            this.game.fireEvent(new GameEventPlayerLivesChanged(this, oldLife, this.life));
        }
        boolean firstLost = this.lifeLostThisTurn == 0;
        this.lifeLostThisTurn += toLose;
        Map<AbilityKey, Object> runParams = AbilityKey.mapFromPlayer(this);
        runParams.put(AbilityKey.LifeAmount, toLose);
        runParams.put(AbilityKey.FirstTime, firstLost);
        this.game.getTriggerHandler().runTrigger(TriggerType.LifeLost, runParams, false);
        this.game.getTriggerHandler().runTrigger(TriggerType.LifeChanged, runParams, false);
        return toLose;
    }

    public final boolean canLoseLife() {
        return this.isInGame() && !StaticAbilityCantGainLosePayLife.anyCantLoseLife(this);
    }

    public final boolean canPayLife(int lifePayment, boolean effect, SpellAbility cause) {
        if (lifePayment > 0 && this.life < lifePayment) {
            return false;
        }
        return lifePayment <= 0 || !StaticAbilityCantGainLosePayLife.anyCantPayLife(this, effect, cause);
    }

    public final boolean payLife(int lifePayment, SpellAbility cause, boolean effect) {
        return this.payLife(lifePayment, cause, effect, null);
    }

    public final boolean payLife(int lifePayment, SpellAbility cause, boolean effect, Map<AbilityKey, Object> params) {
        if (lifePayment <= 0) {
            cause.setPaidLife(0);
            return true;
        }
        if (!this.canPayLife(lifePayment, effect, cause)) {
            return false;
        }
        Map<AbilityKey, Object> replaceParams = AbilityKey.mapFromAffected(this);
        replaceParams.put(AbilityKey.Amount, lifePayment);
        replaceParams.put(AbilityKey.Cause, cause);
        replaceParams.put(AbilityKey.EffectOnly, effect);
        if (cause.isReplacementAbility() && effect) {
            replaceParams.putAll(cause.getReplacingObjects());
        }
        if (params != null) {
            replaceParams.putAll(params);
        }
        switch (this.getGame().getReplacementHandler().run(ReplacementType.PayLife, replaceParams)) {
            case Replaced: {
                return true;
            }
            case Prevented: 
            case Skipped: {
                return false;
            }
        }
        int lost = this.loseLife(lifePayment, false, false);
        cause.setPaidLife(lifePayment);
        Map<AbilityKey, Object> runParams = AbilityKey.mapFromPlayer(this);
        runParams.put(AbilityKey.LifeAmount, lifePayment);
        this.game.getTriggerHandler().runTrigger(TriggerType.PayLife, runParams, false);
        if (lost > 0) {
            boolean runAll = false;
            Map<Player, Integer> lossMap = cause.getLoseLifeMap();
            if (lossMap == null) {
                lossMap = Maps.newHashMap();
                runAll = true;
            }
            lossMap.put(this, lost);
            if (runAll) {
                Map<AbilityKey, Object> runParams2 = AbilityKey.mapFromPIMap(lossMap);
                this.game.getTriggerHandler().runTrigger(TriggerType.LifeLostAll, runParams2, false);
            }
        }
        return true;
    }

    public final boolean canPayEnergy(int energyPayment) {
        int cnt = this.getCounters(CounterEnumType.ENERGY);
        return cnt >= energyPayment;
    }

    public final boolean loseEnergy(int lostEnergy) {
        int cnt = this.getCounters(CounterEnumType.ENERGY);
        if (lostEnergy > cnt) {
            return false;
        }
        this.subtractCounter(CounterEnumType.ENERGY, lostEnergy, this);
        return true;
    }

    public final boolean payEnergy(int energyPayment, Card source) {
        if (energyPayment <= 0) {
            return true;
        }
        return this.canPayEnergy(energyPayment) && this.loseEnergy(energyPayment);
    }

    public final boolean canPayShards(int shardPayment) {
        int cnt = this.getNumManaShards();
        return cnt >= shardPayment;
    }

    public final int loseShards(int lostShards) {
        int cnt = this.getNumManaShards();
        if (lostShards > cnt) {
            return -1;
        }
        this.setNumManaShards(cnt -= lostShards);
        return cnt;
    }

    public final boolean payShards(int shardPayment, Card source) {
        if (shardPayment <= 0) {
            return true;
        }
        return this.canPayShards(shardPayment) && this.loseShards(shardPayment) > -1;
    }

    @Override
    public final int addDamageAfterPrevention(int amount, Card source, SpellAbility cause, boolean isCombat, GameEntityCounterTable counterTable) {
        if (amount <= 0 || this.hasLost()) {
            return 0;
        }
        boolean infect = source.hasKeyword(Keyword.INFECT) || this.hasKeyword("All damage is dealt to you as though its source had infect.");
        int poisonCounters = 0;
        if (infect) {
            poisonCounters += amount;
        } else {
            this.simultaneousDamage += amount;
        }
        if (isCombat) {
            poisonCounters += source.getKeywordMagnitude(Keyword.TOXIC);
        }
        if (poisonCounters > 0) {
            this.addPoisonCounters(poisonCounters, source.getController(), counterTable);
        }
        if (source.isCommander() && isCombat && !this.getGame().getRules().hasAppliedVariant(GameType.Oathbreaker) && !this.getGame().getRules().hasAppliedVariant(GameType.TinyLeaders) && !this.getGame().getRules().hasAppliedVariant(GameType.Brawl)) {
            Card realCommander = source.getRealCommander();
            this.addCommanderDamage(realCommander, amount);
            this.view.updateCommanderDamage(this);
            if (realCommander != source) {
                this.view.updateMergedCommanderDamage(source, realCommander);
            }
        }
        EnumMap<AbilityKey, Object> runParams = AbilityKey.newMap();
        runParams.put(AbilityKey.DamageSource, source);
        runParams.put(AbilityKey.DamageTarget, this);
        runParams.put(AbilityKey.Cause, cause);
        runParams.put(AbilityKey.DamageAmount, Integer.valueOf(amount));
        runParams.put(AbilityKey.IsCombatDamage, Boolean.valueOf(isCombat));
        runParams.put(AbilityKey.DefendingPlayer, this.game.getCombat() != null ? this.game.getCombat().getDefendingPlayerRelatedTo(source) : null);
        this.game.getTriggerHandler().runTrigger(TriggerType.DamageDone, runParams, isCombat);
        this.game.fireEvent(new GameEventPlayerDamaged(this, source, amount, isCombat, infect));
        return amount;
    }

    @Override
    public final int staticReplaceDamage(int damage, Card source, boolean isCombat) {
        int restDamage = damage;
        for (Card c : this.game.getCardsIn(ZoneType.Battlefield)) {
            if (c.getName().equals("Sulfuric Vapors")) {
                if (!source.isSpell() || !source.isRed()) continue;
                ++restDamage;
                continue;
            }
            if (c.getName().equals("Pyromancer's Swath")) {
                if (!c.getController().equals(source.getController()) || !source.isInstant() && !source.isSorcery()) continue;
                restDamage += 2;
                continue;
            }
            if (c.getName().equals("Pyromancer's Gauntlet")) {
                if (!c.getController().equals(source.getController()) || !source.isRed() || !source.isInstant() && !source.isSorcery() && !source.isPlaneswalker()) continue;
                restDamage += 2;
                continue;
            }
            if (c.getName().equals("Furnace of Rath") || c.getName().equals("Dictate of the Twin Gods")) {
                restDamage *= 2;
                continue;
            }
            if (c.getName().equals("Gratuitous Violence")) {
                if (!c.getController().equals(source.getController()) || !source.isCreature()) continue;
                restDamage *= 2;
                continue;
            }
            if (c.getName().equals("Fire Servant")) {
                if (!c.getController().equals(source.getController()) || !source.isRed() || !source.isInstant() && !source.isSorcery()) continue;
                restDamage *= 2;
                continue;
            }
            if (c.getName().equals("Curse of Bloodletting")) {
                if (!c.getEntityAttachedTo().equals(this)) continue;
                restDamage *= 2;
                continue;
            }
            if (c.getName().equals("Gisela, Blade of Goldnight")) {
                if (c.getController().equals(this)) continue;
                restDamage *= 2;
                continue;
            }
            if (c.getName().equals("Inquisitor's Flail")) {
                if (!isCombat || c.getEquipping() == null || !c.getEquipping().equals(source)) continue;
                restDamage *= 2;
                continue;
            }
            if (c.getName().equals("Ghosts of the Innocent")) {
                restDamage /= 2;
                continue;
            }
            if (c.getName().equals("Benevolent Unicorn")) {
                if (!source.isSpell()) continue;
                --restDamage;
                continue;
            }
            if (c.getName().equals("Divine Presence")) {
                if (restDamage <= 3) continue;
                restDamage = 3;
                continue;
            }
            if (c.getName().equals("Forethought Amulet")) {
                if (!c.getController().equals(this) || !source.isInstant() && !source.isSorcery() || restDamage <= 2) continue;
                restDamage = 2;
                continue;
            }
            if (c.getName().equals("Elderscale Wurm")) {
                if (!c.getController().equals(this) || this.getLife() < 7 || this.getLife() - restDamage >= 7 || (restDamage = this.getLife() - 7) >= 0) continue;
                restDamage = 0;
                continue;
            }
            if (!c.getName().equals("Obosh, the Preypiercer") || !c.getController().equals(source.getController()) || source.getCMC() % 2 == 0) continue;
            restDamage *= 2;
        }
        for (Card c : this.game.getCardsIn(ZoneType.Command)) {
            if (c.getName().equals("Insult Effect")) {
                if (!c.getController().equals(source.getController())) continue;
                restDamage *= 2;
                continue;
            }
            if (!c.getName().equals("Mishra") || !c.isCreature() || !c.getController().equals(source.getController())) continue;
            restDamage *= 2;
        }
        return restDamage;
    }

    public final int processDamage() {
        int lost = this.loseLife(this.simultaneousDamage, true, false);
        this.simultaneousDamage = 0;
        return lost;
    }

    public final int getOpponentsAssignedDamage() {
        return Aggregates.sum(this.getOpponents(), GameEntity::getAssignedDamage);
    }

    public final int getMaxOpponentAssignedDamage() {
        return Aggregates.max(this.getRegisteredOpponents(), GameEntity::getAssignedDamage);
    }

    @Override
    public final boolean canReceiveCounters(CounterType type) {
        if (!this.isInGame()) {
            return false;
        }
        return !StaticAbilityCantPutCounter.anyCantPutCounter(this, type);
    }

    @Override
    public final boolean canRemoveCounters(CounterType type) {
        return this.isInGame();
    }

    @Override
    public void addCounterInternal(CounterType counterType, int n, Player source, boolean fireEvents, GameEntityCounterTable table, Map<AbilityKey, Object> params) {
        int addAmount = n;
        if (addAmount <= 0 || !this.canReceiveCounters(counterType)) {
            return;
        }
        int oldValue = this.getCounters(counterType);
        int newValue = addAmount + oldValue;
        this.setCounters(counterType, (Integer)newValue, source, fireEvents);
        if (counterType.is(CounterEnumType.RAD) && newValue > 0) {
            String setCode = null;
            if (params.containsKey((Object)AbilityKey.Cause)) {
                SpellAbility cause = (SpellAbility)params.get((Object)AbilityKey.Cause);
                setCode = cause.getHostCard().getSetCode();
            }
            this.createRadiationEffect(setCode);
        }
        Map<AbilityKey, Object> runParams = AbilityKey.mapFromPlayer(this);
        runParams.put(AbilityKey.Source, source);
        runParams.put(AbilityKey.CounterType, counterType);
        if (params != null) {
            runParams.putAll(params);
        }
        for (int i = 0; i < addAmount; ++i) {
            runParams.put(AbilityKey.CounterAmount, oldValue + i + 1);
            this.getGame().getTriggerHandler().runTrigger(TriggerType.CounterAdded, AbilityKey.newMap(runParams), false);
        }
        if (addAmount > 0) {
            runParams.put(AbilityKey.CounterAmount, addAmount);
            this.getGame().getTriggerHandler().runTrigger(TriggerType.CounterAddedOnce, AbilityKey.newMap(runParams), false);
        }
        if (table != null) {
            table.put(source, this, counterType, addAmount);
        }
    }

    @Override
    public int subtractCounter(CounterType counterName, int num, Player remover) {
        int newValue;
        int oldValue = this.getCounters(counterName);
        int delta = oldValue - (newValue = Math.max(oldValue - num, 0));
        if (delta == 0) {
            return 0;
        }
        this.setCounters(counterName, (Integer)newValue, null, true);
        this.getGame().addCounterRemovedThisTurn(counterName, this, (Integer)delta);
        return delta;
    }

    @Override
    public final void clearCounters() {
        if (this.counters.isEmpty()) {
            return;
        }
        this.counters.clear();
        this.view.updateCounters(this);
        this.getGame().fireEvent(new GameEventPlayerCounters(this, null, 0, 0));
    }

    public void setCounters(CounterEnumType counterType, Integer num, Player source, boolean fireEvents) {
        this.setCounters(CounterType.get(counterType), num, source, fireEvents);
    }

    public void setCounters(CounterType counterType, Integer num, Player source, boolean fireEvents) {
        int old = this.getCounters(counterType);
        this.setCounters(counterType, num);
        this.view.updateCounters(this);
        if (fireEvents) {
            this.getGame().fireEvent(new GameEventPlayerCounters(this, counterType, old, num));
            if (counterType.is(CounterEnumType.POISON)) {
                this.getGame().fireEvent(new GameEventPlayerPoisoned(this, source, old, num - old));
            } else if (counterType.is(CounterEnumType.RAD)) {
                this.getGame().fireEvent(new GameEventPlayerRadiation(this, source, num - old));
            }
        }
        if (counterType.is(CounterEnumType.RAD) && num <= 0) {
            this.removeRadiationEffect();
        }
    }

    @Override
    public void setCounters(Map<CounterType, Integer> allCounters) {
        this.counters = allCounters;
        this.view.updateCounters(this);
        this.getGame().fireEvent(new GameEventPlayerCounters(this, null, 0, 0));
        if (this.counters.getOrDefault(CounterType.get(CounterEnumType.RAD), 0) > 0) {
            this.createRadiationEffect(null);
        } else {
            this.removeRadiationEffect();
        }
    }

    public final void addRadCounters(int num, Player source, GameEntityCounterTable table) {
        this.addCounter(CounterEnumType.RAD, num, source, table);
    }

    public final void removeRadCounters(int num) {
        this.subtractCounter(CounterEnumType.RAD, num, this);
    }

    public final int getPoisonCounters() {
        return this.getCounters(CounterEnumType.POISON);
    }

    public final void setPoisonCounters(int num, Player source) {
        this.setCounters(CounterEnumType.POISON, (Integer)num, source, true);
    }

    public final void addPoisonCounters(int num, Player source, GameEntityCounterTable table) {
        this.addCounter(CounterEnumType.POISON, num, source, table);
    }

    public final void removePoisonCounters(int num, Player source) {
        this.subtractCounter(CounterEnumType.POISON, num, source);
    }

    public final void addChangedKeywords(List<String> addKeywords, List<String> removeKeywords, Long timestamp, long staticId) {
        KeywordsChange cks;
        ArrayList<KeywordInterface> kws = Lists.newArrayList();
        if (addKeywords != null) {
            for (String kw : addKeywords) {
                kws.add(this.getKeywordForStaticAbility(kw, staticId));
            }
        }
        if (!((cks = new KeywordsChange((Iterable<KeywordInterface>)kws, (Collection<String>)removeKeywords, false)).getAbilities().isEmpty() && cks.getTriggers().isEmpty() && cks.getReplacements().isEmpty() && cks.getStaticAbilities().isEmpty())) {
            this.getKeywordCard().addChangedCardTraits(cks.getAbilities(), null, cks.getTriggers(), cks.getReplacements(), cks.getStaticAbilities(), false, false, timestamp, staticId);
        }
        this.changedKeywords.put(timestamp, staticId, cks);
        this.updateKeywords();
        this.game.fireEvent(new GameEventPlayerStatsChanged(this, true));
    }

    public final KeywordInterface getKeywordForStaticAbility(String kw, long staticId) {
        KeywordInterface result;
        if (staticId < 1L || !this.storedKeywords.contains(staticId, kw)) {
            result = Keyword.getInstance(kw);
            result.createTraits(this, false);
        } else {
            result = this.storedKeywords.get(staticId, kw);
        }
        return result;
    }

    public final KeywordsChange removeChangedKeywords(Long timestamp, long staticId) {
        KeywordsChange change = this.changedKeywords.remove(timestamp, staticId);
        if (change != null) {
            if (this.keywordEffect != null) {
                this.getKeywordCard().removeChangedCardTraits(timestamp, staticId);
            }
            this.updateKeywords();
            this.game.fireEvent(new GameEventPlayerStatsChanged(this, true));
        }
        return change;
    }

    public final void addKeyword(String keyword) {
        this.addChangedKeywords(ImmutableList.of(keyword), ImmutableList.of(), this.getGame().getNextTimestamp(), 0L);
    }

    @Override
    public final boolean hasKeyword(String keyword) {
        return this.keywords.contains(keyword);
    }

    @Override
    public final boolean hasKeyword(Keyword keyword) {
        return this.keywords.contains(keyword);
    }

    private void updateKeywords() {
        this.keywords.clear();
        for (KeywordsChange ck : this.changedKeywords.values()) {
            if (ck.isRemoveAllKeywords()) {
                this.keywords.clear();
            } else if (ck.getRemoveKeywords() != null) {
                this.keywords.removeAll(ck.getRemoveKeywords());
            }
            if (ck.getKeywords() == null) continue;
            this.keywords.insertAll(ck.getKeywords());
        }
        this.view.updateKeywords(this);
        this.updateKeywordCardAbilityText();
    }

    public final KeywordCollection.KeywordCollectionView getKeywords() {
        return this.keywords.getView();
    }

    public final FCollectionView<StaticAbility> getStaticAbilities() {
        FCollection<StaticAbility> result = new FCollection<StaticAbility>();
        for (DetachedCardEffect eff : this.staticAbilities.values()) {
            result.addAll(eff.getStaticAbilities());
        }
        return result;
    }

    public final StaticAbility addStaticAbility(Card host, String s2) {
        PlayerZone com = this.getZone(ZoneType.Command);
        if (!this.staticAbilities.containsKey(host)) {
            DetachedCardEffect effect = new DetachedCardEffect(host, host.getName() + "'s Effect");
            effect.setOwner(this);
            this.staticAbilities.put(host, effect);
        }
        if (!com.contains(this.staticAbilities.get(host))) {
            com.add(this.staticAbilities.get(host));
            this.updateZoneForView(com);
        }
        return this.staticAbilities.get(host).addStaticAbility(s2);
    }

    public final void clearStaticAbilities() {
        PlayerZone com = this.getZone(ZoneType.Command);
        for (DetachedCardEffect eff : this.staticAbilities.values()) {
            com.remove(eff);
            eff.setStaticAbilities(Lists.newArrayList());
        }
        this.updateZoneForView(com);
    }

    @Override
    public final boolean canBeTargetedBy(SpellAbility sa) {
        if (this.hasLost()) {
            return false;
        }
        return !StaticAbilityCantTarget.cantTarget(this, sa);
    }

    public void surveil(int num, SpellAbility cause, Map<AbilityKey, Object> params) {
        CardCollection topN = this.getTopXCardsFromLibrary(num += StaticAbilitySurveilNum.surveilNumMod(this));
        if (!topN.isEmpty()) {
            ImmutablePair<CardCollection, CardCollection> lists = this.getController().arrangeForSurveil(topN);
            CardCollection toTop = lists.getLeft();
            CardCollection toGrave = lists.getRight();
            int numToGrave = 0;
            int numToTop = 0;
            if (toGrave != null) {
                for (Card c : toGrave) {
                    Card moved = this.getGame().getAction().moveToGraveyard(c, cause, params);
                    moved.setSurveilled(true);
                    ++numToGrave;
                }
            }
            if (toTop != null) {
                Collections.reverse(toTop);
                for (Card c : toTop) {
                    this.getGame().getAction().moveToLibrary(c, cause, params);
                    ++numToTop;
                }
                if (cause.hasParam("RememberKept")) {
                    cause.getHostCard().addRemembered(toTop);
                }
            }
            this.getGame().fireEvent(new GameEventSurveil(this, numToTop, numToGrave));
        }
        ++this.surveilThisTurn;
        Map<AbilityKey, Object> runParams = AbilityKey.mapFromPlayer(this);
        runParams.put(AbilityKey.FirstTime, this.surveilThisTurn == 1);
        if (params != null) {
            runParams.putAll(params);
        }
        this.getGame().getTriggerHandler().runTrigger(TriggerType.Surveil, runParams, false);
    }

    public int getSurveilThisTurn() {
        return this.surveilThisTurn;
    }

    public void resetSurveilThisTurn() {
        this.surveilThisTurn = 0;
    }

    public boolean canMulligan() {
        return !this.getZone(ZoneType.Hand).isEmpty();
    }

    public final boolean canDraw() {
        return this.canDrawAmount(1);
    }

    public final boolean canDrawAmount(int amount) {
        return StaticAbilityCantDraw.canDrawThisAmount(this, amount);
    }

    public final CardCollectionView drawCard() {
        return this.drawCards(1);
    }

    public final CardCollectionView drawCards(int n) {
        return this.drawCards(n, null, AbilityKey.newMap(), this.getZone(ZoneType.Hand));
    }

    public final CardCollectionView drawCards(int n, PlayerZone zone) {
        return this.drawCards(n, null, AbilityKey.newMap(), zone);
    }

    public final CardCollectionView drawCards(int n, SpellAbility cause, Map<AbilityKey, Object> params) {
        return this.drawCards(n, cause, params, this.getZone(ZoneType.Hand));
    }

    public final CardCollectionView drawCards(int n, SpellAbility cause, Map<AbilityKey, Object> params, PlayerZone zone) {
        CardCollection drawn = new CardCollection();
        if (n <= 0) {
            return drawn;
        }
        Map<AbilityKey, Object> repRunParams = AbilityKey.mapFromAffected(this);
        repRunParams.put(AbilityKey.Number, n);
        if (params != null) {
            repRunParams.putAll(params);
        }
        if (this.game.getReplacementHandler().run(ReplacementType.DrawCards, repRunParams) != ReplacementResult.NotReplaced) {
            return drawn;
        }
        boolean gameStarted = this.game.getAge().ordinal() > GameStage.Mulligan.ordinal();
        HashMap<Player, CardCollection> toReveal = Maps.newHashMap();
        for (int i = 0; i < n; ++i) {
            if (gameStarted && !this.canDraw()) {
                return drawn;
            }
            drawn.addAll(this.doDraw(toReveal, cause, params, zone));
        }
        for (Map.Entry e : toReveal.entrySet()) {
            if (((CardCollection)e.getValue()).size() <= 1) continue;
            this.game.getAction().revealTo((CardCollectionView)e.getValue(), (Player)e.getKey(), "Revealing cards drawn from ");
        }
        return drawn;
    }

    private CardCollectionView doDraw(Map<Player, CardCollection> revealed, SpellAbility sa, Map<AbilityKey, Object> params, PlayerZone hand) {
        CardCollection drawn = new CardCollection();
        PlayerZone library = this.getZone(ZoneType.Library);
        SpellAbility cause = sa;
        if (cause != null && cause.isReplacementAbility()) {
            cause = (SpellAbility)cause.getReplacingObject(AbilityKey.Cause);
        }
        Map<AbilityKey, Object> repParams = AbilityKey.mapFromAffected(this);
        repParams.put(AbilityKey.Cause, cause);
        if (params != null) {
            repParams.putAll(params);
        }
        if (this.game.getReplacementHandler().run(ReplacementType.Draw, repParams) != ReplacementResult.NotReplaced) {
            return drawn;
        }
        if (!library.isEmpty()) {
            boolean gameStarted;
            Card c = this.hasKeyword("You draw cards from the bottom of your library instead of the top of your library.") ? library.get(library.size() - 1) : library.get(0);
            ArrayList<Player> pList = Lists.newArrayList();
            for (Player p : this.getAllOtherPlayers()) {
                if (!c.mayPlayerLook(p)) continue;
                pList.add(p);
            }
            c = this.game.getAction().moveTo(hand, c, cause, params);
            drawn.add(c);
            if (cause != null && cause.hasParam("RememberDrawn") && cause.getParam("RememberDrawn").equals("AllReplaced")) {
                cause.getHostCard().addRemembered(drawn);
            }
            for (Player p : pList) {
                if (!revealed.containsKey(p)) {
                    revealed.put(p, new CardCollection());
                }
                revealed.get(p).add(c);
            }
            boolean bl = gameStarted = this.game.getAge().ordinal() > GameStage.Mulligan.ordinal();
            if (gameStarted) {
                this.setLastDrawnCard(c);
                c.setDrawnThisTurn(true);
                ++this.numDrawnThisTurn;
                if (this.game.getPhaseHandler().is(PhaseType.DRAW)) {
                    ++this.numDrawnThisDrawStep;
                }
                this.view.updateNumDrawnThisTurn(this);
                Map<AbilityKey, Object> runParams = AbilityKey.mapFromPlayer(this);
                if (params != null) {
                    runParams.putAll(params);
                }
                if (this.game.getTopLibForPlayer(this) != null && this.getPaidForSA() != null && cause != null && this.getPaidForSA() != cause.getRootAbility()) {
                    c.turnFaceDown();
                    this.game.addFacedownWhileCasting(c, this.numDrawnThisTurn);
                    runParams.put(AbilityKey.CanReveal, false);
                }
                runParams.put(AbilityKey.Card, c);
                runParams.put(AbilityKey.Number, this.numDrawnThisTurn);
                this.game.getTriggerHandler().runTrigger(TriggerType.Drawn, runParams, false);
            }
        } else {
            this.triedToDrawFromEmptyLibrary = true;
        }
        return drawn;
    }

    public final PlayerZone getZone(ZoneType zone) {
        return this.zones.get((Object)zone);
    }

    public void updateZoneForView(PlayerZone zone) {
        this.view.updateZone(zone);
    }

    public void updateAllZonesForView() {
        for (PlayerZone zone : this.zones.values()) {
            this.updateZoneForView(zone);
        }
    }

    public final List<PlayerZone> getExtraZones() {
        return this.extraZones;
    }

    public void resetExtraZones(ZoneType type) {
        this.extraZones.removeIf(z -> z.getZoneType().equals((Object)type));
        if (this.extraZones.isEmpty()) {
            this.extraZones = null;
        }
    }

    public final CardCollectionView getCardsIn(ZoneType zoneType) {
        return this.getCardsIn(zoneType, true);
    }

    public final CardCollectionView getCardsIn(ZoneType zoneType, boolean filterOutPhasedOut) {
        if (zoneType == ZoneType.Stack) {
            CardCollection cards = new CardCollection();
            for (Card c : this.game.getStackZone().getCards()) {
                if (!c.getOwner().equals(this)) continue;
                cards.add(c);
            }
            return cards;
        }
        if (zoneType == ZoneType.Flashback) {
            return this.getCardsActivatableInExternalZones(true);
        }
        PlayerZone zone = this.getZone(zoneType);
        return zone == null ? CardCollection.EMPTY : zone.getCards(filterOutPhasedOut);
    }

    public final CardCollectionView getCardsIn(ZoneType zone, int n) {
        return new CardCollection(Iterables.limit(this.getCardsIn(zone), n));
    }

    public final CardCollectionView getCardsIn(Iterable<ZoneType> zones) {
        return this.getCardsIn(zones, true);
    }

    public final CardCollectionView getCardsIn(Iterable<ZoneType> zones, boolean filterOutPhasedOut) {
        CardCollection result = new CardCollection();
        for (ZoneType z : zones) {
            result.addAll(this.getCardsIn(z, filterOutPhasedOut));
        }
        return result;
    }

    public final CardCollectionView getCardsIn(ZoneType[] zones) {
        CardCollection result = new CardCollection();
        for (ZoneType z : zones) {
            result.addAll(this.getCardsIn(z));
        }
        return result;
    }

    public final CardCollectionView getCardsIn(ZoneType zone, String cardName) {
        return CardLists.filter((Iterable<Card>)this.getCardsIn(zone), CardPredicates.nameEquals(cardName));
    }

    public CardCollectionView getCardsActivatableInExternalZones(boolean includeCommandZone) {
        CardCollection cl = new CardCollection();
        cl.addAll(this.getZone(ZoneType.Graveyard).getCardsPlayerCanActivate(this));
        cl.addAll(this.getZone(ZoneType.Exile).getCardsPlayerCanActivate(this));
        cl.addAll(this.getZone(ZoneType.Library).getCardsPlayerCanActivate(this));
        if (includeCommandZone) {
            cl.addAll(this.getZone(ZoneType.Command).getCardsPlayerCanActivate(this));
            cl.addAll(this.getZone(ZoneType.Sideboard).getCardsPlayerCanActivate(this));
        }
        for (Player other : this.getAllOtherPlayers()) {
            cl.addAll(other.getZone(ZoneType.Exile).getCardsPlayerCanActivate(this));
            cl.addAll(other.getZone(ZoneType.Graveyard).getCardsPlayerCanActivate(this));
            cl.addAll(other.getZone(ZoneType.Library).getCardsPlayerCanActivate(this));
            cl.addAll(other.getZone(ZoneType.Hand).getCardsPlayerCanActivate(this));
        }
        cl.addAll(this.getGame().getCardsPlayerCanActivateInStack());
        return cl;
    }

    public final CardCollectionView getAllCards() {
        return CardCollection.combine(this.getCardsIn(ALL_ZONES), this.getCardsIn(ZoneType.Stack), this.inboundTokens);
    }

    public final void resetNumDrawnThisDrawStep() {
        this.numDrawnThisDrawStep = 0;
    }

    public final void resetNumDrawnThisTurn() {
        this.numDrawnThisTurn = 0;
        this.view.updateNumDrawnThisTurn(this);
    }

    public final int getNumDrawnThisTurn() {
        return this.numDrawnThisTurn;
    }

    public final int getNumDrawnLastTurn() {
        return this.numDrawnLastTurn;
    }

    public final int numDrawnThisDrawStep() {
        return this.numDrawnThisDrawStep;
    }

    public final void resetNumRollsThisTurn() {
        this.numRollsThisTurn = 0;
    }

    public final int getNumRollsThisTurn() {
        return this.numRollsThisTurn;
    }

    public void roll() {
        ++this.numRollsThisTurn;
    }

    public final Card discard(Card c, SpellAbility sa, boolean effect, Map<AbilityKey, Object> params) {
        if (!c.canBeDiscardedBy(sa, effect)) {
            return null;
        }
        this.discardedThisTurn.add(CardCopyService.getLKICopy(c));
        params.put(AbilityKey.Discard, true);
        params.put(AbilityKey.EffectOnly, effect);
        Card newCard = this.game.getAction().moveToGraveyard(c, sa, params);
        StringBuilder sb = new StringBuilder();
        sb.append(this).append(" discards ").append(c);
        sb.append(".");
        this.game.getGameLog().add(GameLogEntryType.DISCARD, sb.toString());
        newCard.setDiscarded(true);
        if (sa != null && sa.hasParam("RememberDiscarded")) {
            sa.getHostCard().addRemembered(newCard);
        }
        Map<AbilityKey, Object> runParams = AbilityKey.mapFromPlayer(this);
        runParams.put(AbilityKey.Card, c);
        runParams.put(AbilityKey.Cause, sa);
        runParams.putAll(params);
        this.game.getTriggerHandler().runTrigger(TriggerType.Discarded, runParams, false);
        return newCard;
    }

    public final void addTokensCreatedThisTurn(Card token) {
        ++this.numTokenCreatedThisTurn;
        Map<AbilityKey, Object> runParams = AbilityKey.mapFromPlayer(this);
        runParams.put(AbilityKey.Num, this.numTokenCreatedThisTurn);
        runParams.put(AbilityKey.Card, token);
        this.game.getTriggerHandler().runTrigger(TriggerType.TokenCreated, runParams, false);
    }

    public final int getNumTokenCreatedThisTurn() {
        return this.numTokenCreatedThisTurn;
    }

    public final void resetNumTokenCreatedThisTurn() {
        this.numTokenCreatedThisTurn = 0;
    }

    public final int getNumForetoldThisTurn() {
        return this.numForetoldThisTurn;
    }

    public final void addForetoldThisTurn() {
        ++this.numForetoldThisTurn;
        Map<AbilityKey, Object> runParams = AbilityKey.mapFromPlayer(this);
        runParams.put(AbilityKey.Num, this.numForetoldThisTurn);
        this.game.getTriggerHandler().runTrigger(TriggerType.Foretell, runParams, false);
    }

    public final void resetNumForetoldThisTurn() {
        this.numForetoldThisTurn = 0;
    }

    public final List<Card> getDiscardedThisTurn() {
        return this.discardedThisTurn;
    }

    public final void resetDiscardedThisTurn() {
        this.discardedThisTurn.clear();
    }

    public final int getNumExploredThisTurn() {
        return this.numExploredThisTurn;
    }

    public final void addExploredThisTurn() {
        ++this.numExploredThisTurn;
    }

    public final void resetNumExploredThisTurn() {
        this.numExploredThisTurn = 0;
    }

    public int getNumCardsInHandStartedThisTurnWith() {
        return this.numCardsInHandStartedThisTurnWith;
    }

    public void setNumCardsInHandStartedThisTurnWith(int num) {
        this.numCardsInHandStartedThisTurnWith = num;
    }

    public int getLifeStartedThisTurnWith() {
        return this.lifeStartedThisTurnWith;
    }

    public void setLifeStartedThisTurnWith(int l) {
        this.lifeStartedThisTurnWith = l;
    }

    public void addNoteForName(String notedFor, String noted) {
        if (!this.notes.containsKey(notedFor)) {
            this.notes.put(notedFor, new FCollection());
        }
        this.notes.get(notedFor).add(noted);
    }

    public FCollection<String> getNotesForName(String notedFor) {
        if (!this.notes.containsKey(notedFor)) {
            this.notes.put(notedFor, new FCollection());
        }
        return this.notes.get(notedFor);
    }

    public void clearNotesForName(String notedFor) {
        if (this.notes.containsKey(notedFor)) {
            this.notes.get(notedFor).clear();
        }
    }

    public void noteNumberForName(String notedFor, int noted) {
        this.notedNum.put(notedFor, noted);
    }

    public int getNotedNumberForName(String notedFor) {
        if (!this.notedNum.containsKey(notedFor)) {
            return 0;
        }
        return this.notedNum.get(notedFor);
    }

    public final CardCollectionView mill(int n, ZoneType destination, SpellAbility sa, Map<AbilityKey, Object> params) {
        Map<AbilityKey, Object> repRunParams = AbilityKey.mapFromAffected(this);
        repRunParams.put(AbilityKey.Number, n);
        if (params != null) {
            repRunParams.putAll(params);
        }
        if (destination == ZoneType.Graveyard) {
            switch (this.getGame().getReplacementHandler().run(ReplacementType.Mill, repRunParams)) {
                case NotReplaced: {
                    break;
                }
                case Updated: {
                    if (this.equals(repRunParams.get((Object)AbilityKey.Affected))) {
                        n = (Integer)repRunParams.get((Object)AbilityKey.Number);
                        break;
                    }
                    return CardCollection.EMPTY;
                }
                default: {
                    return CardCollection.EMPTY;
                }
            }
        }
        Iterable<Card> milledView = this.getCardsIn(ZoneType.Library);
        if (sa.getRootAbility().getReplacingObject(AbilityKey.SimultaneousETB) != null) {
            milledView = Iterables.filter(milledView, c -> !((CardCollection)sa.getRootAbility().getReplacingObject(AbilityKey.SimultaneousETB)).contains(c));
        }
        CardCollectionView milled = new CardCollection(Iterables.limit(milledView, n));
        if (destination == ZoneType.Graveyard) {
            milled = GameActionUtil.orderCardsByTheirOwners(this.game, milled, ZoneType.Graveyard, sa);
        }
        for (Card m4 : milled) {
            Card moved = this.game.getAction().moveTo(destination, m4, sa, params);
            moved.setMilled(true);
            Map<AbilityKey, Object> runParams = AbilityKey.mapFromPlayer(this);
            runParams.put(AbilityKey.Card, m4);
            this.game.getTriggerHandler().runTrigger(TriggerType.Milled, runParams, false);
        }
        if (!milled.isEmpty()) {
            Map<AbilityKey, Object> runParams = AbilityKey.mapFromPlayer(this);
            runParams.put(AbilityKey.Cards, milled);
            this.game.getTriggerHandler().runTrigger(TriggerType.MilledOnce, runParams, false);
        }
        return milled;
    }

    public final CardCollection getTopXCardsFromLibrary(int amount) {
        CardCollection topCards = new CardCollection();
        PlayerZone lib = this.getZone(ZoneType.Library);
        int maxCards = lib.size();
        maxCards = Math.min(maxCards, amount);
        for (int j = 0; j < maxCards; ++j) {
            topCards.add(lib.get(j));
        }
        return topCards;
    }

    public final void shuffle(SpellAbility sa) {
        CardCollection list = new CardCollection(this.getCardsIn(ZoneType.Library));
        Collections.shuffle(list, MyRandom.getRandom());
        this.getZone(ZoneType.Library).setCards(this.getController().cheatShuffle(list));
        Map<AbilityKey, Object> runParams = AbilityKey.mapFromPlayer(this);
        runParams.put(AbilityKey.Source, sa);
        this.game.getTriggerHandler().runTrigger(TriggerType.Shuffled, runParams, false);
        this.game.fireEvent(new GameEventShuffle(this));
    }

    public final boolean playLand(Card land, boolean ignoreZoneAndTiming, SpellAbility cause) {
        if (this.canPlayLand(land, ignoreZoneAndTiming, cause)) {
            this.playLandNoCheck(land, null);
            return true;
        }
        this.game.getStack().unfreezeStack();
        return false;
    }

    public final Card playLandNoCheck(Card land, SpellAbility cause) {
        land.setController(this, 0L);
        if (land.isFaceDown()) {
            land.turnFaceUp(null);
            if (cause.isLandAbility()) {
                land.changeToState(cause.getCardStateName());
            }
        }
        Map<AbilityKey, Object> runParams = AbilityKey.mapFromCard(land);
        runParams.put(AbilityKey.Origin, land.getZone().getZoneType().name());
        this.game.copyLastState();
        Card c = this.game.getAction().moveTo(this.getZone(ZoneType.Battlefield), land, cause);
        this.game.updateLastStateForCard(c);
        this.game.fireEvent(new GameEventLandPlayed(this, land));
        runParams.put(AbilityKey.SpellAbility, cause);
        this.game.getTriggerHandler().runTrigger(TriggerType.LandPlayed, runParams, false);
        this.game.getStack().unfreezeStack();
        this.addLandPlayedThisTurn();
        return c;
    }

    public final boolean canPlayLand(Card land, boolean ignoreZoneAndTiming, SpellAbility landSa) {
        if (!ignoreZoneAndTiming) {
            if (!this.game.getPhaseHandler().isPlayerTurn(this)) {
                return false;
            }
            if (!(this.canCastSorcery() || landSa != null && landSa.withFlash(land, this))) {
                return false;
            }
        }
        if (StaticAbilityCantBeCast.cantPlayLandAbility(landSa, land, this)) {
            return false;
        }
        if (land != null && !ignoreZoneAndTiming) {
            boolean mayPlay;
            boolean bl = landSa == null ? !land.mayPlay(this).isEmpty() : (mayPlay = landSa.getMayPlay() != null);
            if (land.getOwner() != this && !mayPlay) {
                return false;
            }
            Zone zone = this.game.getZoneOf(land);
            if (zone != null && (zone.is(ZoneType.Battlefield) || !zone.is(ZoneType.Hand) && !mayPlay)) {
                return false;
            }
        }
        if (this.getMaxLandPlaysInfinite()) {
            return true;
        }
        return this.getLandsPlayedThisTurn() < this.getMaxLandPlays();
    }

    public final int getMaxLandPlays() {
        int adjMax = 1;
        for (Integer i : this.adjustLandPlays.values()) {
            adjMax += i.intValue();
        }
        return adjMax;
    }

    public final void addMaxLandPlays(long timestamp, int value) {
        this.adjustLandPlays.put(timestamp, value);
        this.getView().updateMaxLandPlay(this);
        this.getGame().fireEvent(new GameEventPlayerStatsChanged(this, false));
    }

    public final boolean removeMaxLandPlays(long timestamp) {
        boolean changed;
        boolean bl = changed = this.adjustLandPlays.remove(timestamp) != null;
        if (changed) {
            this.getView().updateMaxLandPlay(this);
            this.getGame().fireEvent(new GameEventPlayerStatsChanged(this, false));
        }
        return changed;
    }

    public final void addMaxLandPlaysInfinite(long timestamp) {
        this.adjustLandPlaysInfinite.add(timestamp);
        this.getView().updateUnlimitedLandPlay(this);
        this.getGame().fireEvent(new GameEventPlayerStatsChanged(this, false));
    }

    public final boolean removeMaxLandPlaysInfinite(long timestamp) {
        boolean changed = this.adjustLandPlaysInfinite.remove(timestamp);
        if (changed) {
            this.getView().updateUnlimitedLandPlay(this);
            this.getGame().fireEvent(new GameEventPlayerStatsChanged(this, false));
        }
        return changed;
    }

    public final boolean getMaxLandPlaysInfinite() {
        if (this.getController().canPlayUnlimitedLands()) {
            return true;
        }
        return !this.adjustLandPlaysInfinite.isEmpty();
    }

    public final void addMaingameCardMapping(Card subgameCard, Card maingameCard) {
        this.maingameCardsMap.put(subgameCard, maingameCard);
    }

    public final Card getMappingMaingameCard(Card subgameCard) {
        return this.maingameCardsMap.get(subgameCard);
    }

    public final ManaPool getManaPool() {
        return this.manaPool;
    }

    public void updateManaForView() {
        this.view.updateMana(this);
    }

    public final int getNumPowerSurgeLands() {
        return this.numPowerSurgeLands;
    }

    public final int setNumPowerSurgeLands(int n) {
        this.numPowerSurgeLands = n;
        return this.numPowerSurgeLands;
    }

    public final Card getLastDrawnCard() {
        return this.lastDrawnCard;
    }

    private Card setLastDrawnCard(Card c) {
        this.lastDrawnCard = c;
        return this.lastDrawnCard;
    }

    public final Card getRingBearer() {
        return this.ringBearer;
    }

    public final Card getTheRing() {
        return this.theRing;
    }

    public final void clearTheRing() {
        this.theRing = null;
    }

    public final void setRingBearer(Card bearer) {
        if (bearer == null) {
            return;
        }
        this.clearRingBearer();
        this.ringBearer = bearer;
        this.ringBearer.setRingBearer(true);
    }

    public void clearRingBearer() {
        if (this.ringBearer == null) {
            return;
        }
        this.ringBearer.setRingBearer(false);
        this.ringBearer = null;
    }

    public final String getNamedCard() {
        return this.namedCard;
    }

    public final void setNamedCard(String s2) {
        this.namedCard = s2;
    }

    public final int getTurn() {
        return this.stats.getTurnsPlayed();
    }

    public final void incrementTurn() {
        this.stats.nextTurn();
    }

    public boolean hasTappedLandForManaThisTurn() {
        return this.tappedLandForManaThisTurn;
    }

    public void setTappedLandForManaThisTurn(boolean tappedLandForManaThisTurn) {
        this.tappedLandForManaThisTurn = tappedLandForManaThisTurn;
    }

    public final boolean hasBeenDealtCombatDamageSinceLastTurn() {
        return this.beenDealtCombatDamageSinceLastTurn;
    }

    public final void setBeenDealtCombatDamageSinceLastTurn(boolean b) {
        this.beenDealtCombatDamageSinceLastTurn = b;
    }

    public final boolean getActivateLoyaltyAbilityThisTurn() {
        return this.activateLoyaltyAbilityThisTurn;
    }

    public final void setActivateLoyaltyAbilityThisTurn(boolean b) {
        this.activateLoyaltyAbilityThisTurn = b;
    }

    public final List<Card> getCreaturesAttackedThisTurn() {
        ArrayList<Card> result = Lists.newArrayList(Iterables.concat(this.attackedThisTurn.values()));
        return result;
    }

    public final List<Card> getCreaturesAttackedThisTurn(GameEntity e) {
        return this.attackedThisTurn.getOrDefault(e, Lists.newArrayList());
    }

    public final void addCreaturesAttackedThisTurn(Card c, GameEntity e) {
        List creatures = this.attackedThisTurn.getOrDefault(e, Lists.newArrayList());
        creatures.add(c);
        this.attackedThisTurn.putIfAbsent(e, creatures);
        if (e instanceof Player && !this.attackedPlayersThisCombat.contains(e)) {
            this.attackedPlayersThisCombat.add((Player)e);
        }
    }

    public final Iterable<Player> getAttackedPlayersMyTurn() {
        return Iterables.filter(this.attackedThisTurn.keySet(), Player.class);
    }

    public final List<Player> getAttackedPlayersMyLastTurn() {
        return this.attackedPlayersLastTurn;
    }

    public final void clearAttackedMyTurn() {
        this.attackedThisTurn.clear();
    }

    public final void setAttackedPlayersMyLastTurn(Iterable<Player> players) {
        this.attackedPlayersLastTurn.clear();
        Iterables.addAll(this.attackedPlayersLastTurn, players);
    }

    public final List<Player> getAttackedPlayersMyCombat() {
        return this.attackedPlayersThisCombat;
    }

    public final void clearAttackedPlayersMyCombat() {
        this.attackedPlayersThisCombat.clear();
    }

    public final int getVenturedThisTurn() {
        return this.venturedThisTurn;
    }

    public final void incrementVenturedThisTurn() {
        ++this.venturedThisTurn;
    }

    public final void resetVenturedThisTurn() {
        this.venturedThisTurn = 0;
    }

    public final List<Card> getCompletedDungeons() {
        return this.completedDungeons;
    }

    public void addCompletedDungeon(Card dungeon) {
        this.completedDungeons.add(dungeon);
    }

    public void resetCompletedDungeons() {
        this.completedDungeons.clear();
    }

    public final int getNumRingTemptedYou() {
        return this.numRingTemptedYou;
    }

    public final void incrementRingTemptedYou() {
        ++this.numRingTemptedYou;
    }

    public final void setNumRingTemptedYou(int value) {
        this.numRingTemptedYou = value;
    }

    public final void resetRingTemptedYou() {
        this.numRingTemptedYou = 0;
    }

    public final List<Card> getPlaneswalkedToThisTurn() {
        return this.planeswalkedToThisTurn;
    }

    public final void altWinBySpellEffect(String sourceName) {
        if (this.cantWin()) {
            return;
        }
        this.setOutcome(PlayerOutcome.altWin(sourceName));
    }

    public final boolean loseConditionMet(GameLossReason state, String spellName) {
        if (state != GameLossReason.OpponentWon) {
            Map<AbilityKey, Object> repParams = AbilityKey.mapFromAffected(this);
            repParams.put(AbilityKey.LoseReason, (Object)state);
            if (this.game.getReplacementHandler().run(ReplacementType.GameLoss, repParams) != ReplacementResult.NotReplaced) {
                return false;
            }
        }
        this.setOutcome(PlayerOutcome.loss(state, spellName));
        return true;
    }

    public final void concede() {
        this.setOutcome(PlayerOutcome.concede());
    }

    public final void intentionalDraw() {
        this.setOutcome(PlayerOutcome.draw());
    }

    public final boolean conceded() {
        return this.getOutcome() != null && this.getOutcome().lossState == GameLossReason.Conceded;
    }

    public final boolean cantLose() {
        if (this.conceded()) {
            return false;
        }
        return this.cantLoseCheck(null);
    }

    public final boolean cantLoseForZeroOrLessLife() {
        if (this.conceded()) {
            return false;
        }
        return this.cantLoseCheck(GameLossReason.LifeReachedZero);
    }

    public final boolean cantLoseCheck(GameLossReason state) {
        Map<AbilityKey, Object> repParams = AbilityKey.mapFromAffected(this);
        repParams.put(AbilityKey.LoseReason, (Object)state);
        return this.game.getReplacementHandler().cantHappenCheck(ReplacementType.GameLoss, repParams);
    }

    public final boolean cantWin() {
        return this.game.getReplacementHandler().cantHappenCheck(ReplacementType.GameWin, AbilityKey.mapFromAffected(this));
    }

    public final boolean checkLoseCondition() {
        boolean hasNoLife;
        if (this.hasLost()) {
            return true;
        }
        if (this.triedToDrawFromEmptyLibrary) {
            this.triedToDrawFromEmptyLibrary = false;
            if (this.loseConditionMet(GameLossReason.Milled, null)) {
                return true;
            }
        }
        boolean bl = hasNoLife = this.getLife() <= 0;
        if (hasNoLife && this.loseConditionMet(GameLossReason.LifeReachedZero, null)) {
            return true;
        }
        if (this.getCounters(CounterEnumType.POISON) >= 10 && this.loseConditionMet(GameLossReason.Poisoned, null)) {
            return true;
        }
        if (this.game.getRules().hasAppliedVariant(GameType.Commander)) {
            for (Map.Entry<Card, Integer> entry : this.getCommanderDamage()) {
                if (entry.getValue() < 21 || !this.loseConditionMet(GameLossReason.CommanderDamage, null)) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean hasLost() {
        return this.getOutcome() != null && this.getOutcome().lossState != null;
    }

    public final boolean hasWon() {
        if (this.cantWin()) {
            return false;
        }
        return this.getOutcome() != null && this.getOutcome().lossState == null;
    }

    public final boolean isInGame() {
        return this.getOutcome() == null;
    }

    public final boolean hasMetalcraft() {
        return CardLists.count(this.getCardsIn(ZoneType.Battlefield), CardPredicates.Presets.ARTIFACTS) >= 3;
    }

    public final boolean hasDesert() {
        return Iterables.any(this.getCardsIn(Arrays.asList(ZoneType.Battlefield, ZoneType.Graveyard)), CardPredicates.isType("Desert"));
    }

    public final boolean hasThreshold() {
        return this.getZone(ZoneType.Graveyard).size() >= 7;
    }

    public final boolean hasHellbent() {
        return this.getZone(ZoneType.Hand).isEmpty();
    }

    public final boolean hasRevolt() {
        return this.revolt;
    }

    public final void setRevolt(boolean val) {
        this.revolt = val;
    }

    public final int getDescended() {
        return this.descended;
    }

    public final void descend() {
        ++this.descended;
    }

    public final void setDescended(int n) {
        this.descended = n;
    }

    public final boolean hasDelirium() {
        return CardFactoryUtil.getCardTypesFromList(this.getCardsIn(ZoneType.Graveyard)) >= 4;
    }

    public final boolean hasLandfall() {
        return Iterables.any(this.getZone(ZoneType.Battlefield).getCardsAddedThisTurn(null), CardPredicates.Presets.LANDS);
    }

    public boolean hasFerocious() {
        return !CardLists.filterPower(this.getCreaturesInPlay(), 4).isEmpty();
    }

    public final boolean hasSurge() {
        return !CardLists.filterControlledBy(this.game.getStack().getSpellsCastThisTurn(), this.getYourTeam()).isEmpty();
    }

    public final boolean hasBloodthirst() {
        for (Player p : this.getRegisteredOpponents()) {
            if (p.getAssignedDamage() <= 0) continue;
            return true;
        }
        return false;
    }

    public final int getBloodthirstAmount() {
        return Aggregates.sum(this.getRegisteredOpponents(), GameEntity::getAssignedDamage);
    }

    public final int getOpponentLostLifeThisTurn() {
        int lost = 0;
        for (Player opp : this.getRegisteredOpponents()) {
            lost += opp.getLifeLostThisTurn();
        }
        return lost;
    }

    public final boolean hasProwl(SpellAbility sa) {
        return !this.game.getDamageDoneThisTurn(true, true, "Card.YouCtrl+sharesCreatureTypeWith", "Player", sa.getHostCard(), this, sa).isEmpty();
    }

    public final boolean hasFreerunning() {
        return !this.game.getDamageDoneThisTurn(true, true, "Card.Assassin+YouCtrl,Card.IsCommander+YouCtrl", "Player", null, this, null).isEmpty();
    }

    public final void setLibrarySearched(int l) {
        this.numLibrarySearchedOwn = l;
    }

    public final int getLibrarySearched() {
        return this.numLibrarySearchedOwn;
    }

    public final void incLibrarySearched() {
        ++this.numLibrarySearchedOwn;
    }

    public final void setNumManaConversion(int l) {
        this.numManaConversion = l;
    }

    public final boolean hasManaConversion() {
        return this.numManaConversion < this.keywords.getAmount("You may spend mana as though it were mana of any type to cast a spell this turn.");
    }

    public final void incNumManaConversion() {
        ++this.numManaConversion;
    }

    public final void decNumManaConversion() {
        --this.numManaConversion;
    }

    @Override
    public final boolean isValid(String restriction, Player sourceController, Card source, CardTraitBase spellAbility) {
        String[] incR = restriction.split("\\.", 2);
        if (incR[0].equals("Opponent") ? this.equals(sourceController) || !this.isOpponentOf(sourceController) : (incR[0].equals("You") ? !this.equals(sourceController) : !incR[0].equals("Any") && !incR[0].equals("Player"))) {
            return false;
        }
        if (incR.length > 1) {
            String[] exR;
            String excR = incR[1];
            for (String s2 : exR = excR.split("\\+")) {
                if (this.hasProperty(s2, sourceController, source, spellAbility)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public final boolean hasProperty(String property, Player sourceController, Card source, CardTraitBase spellAbility) {
        if (property.startsWith("!")) {
            return !PlayerProperty.playerHasProperty(this, property.substring(1), sourceController, source, spellAbility);
        }
        return PlayerProperty.playerHasProperty(this, property, sourceController, source, spellAbility);
    }

    public final int getMaxHandSize() {
        return this.maxHandSize;
    }

    public final void setMaxHandSize(int size) {
        if (this.maxHandSize == size) {
            return;
        }
        this.maxHandSize = size;
        this.view.updateMaxHandSize(this);
    }

    public boolean isUnlimitedHandSize() {
        return this.unlimitedHandSize;
    }

    public void setUnlimitedHandSize(boolean unlimited) {
        if (this.unlimitedHandSize == unlimited) {
            return;
        }
        this.unlimitedHandSize = unlimited;
        this.view.updateUnlimitedHandSize(this);
    }

    public final int getLandsPlayedThisTurn() {
        return this.landsPlayedThisTurn;
    }

    public final int getLandsPlayedLastTurn() {
        return this.landsPlayedLastTurn;
    }

    public final void addLandPlayedThisTurn() {
        ++this.landsPlayedThisTurn;
        ++this.achievementTracker.landsPlayed;
        this.view.updateNumLandThisTurn(this);
    }

    public final void resetLandsPlayedThisTurn() {
        this.landsPlayedThisTurn = 0;
        this.view.updateNumLandThisTurn(this);
    }

    public final void setLandsPlayedThisTurn(int num) {
        this.landsPlayedThisTurn = num;
        this.view.updateNumLandThisTurn(this);
    }

    public final void setLandsPlayedLastTurn(int num) {
        this.landsPlayedLastTurn = num;
    }

    public final void setNumDrawnLastTurn(int num) {
        this.numDrawnLastTurn = num;
    }

    public final int getInvestigateNumThisTurn() {
        return this.investigatedThisTurn;
    }

    public final void addInvestigatedThisTurn() {
        ++this.investigatedThisTurn;
        Map<AbilityKey, Object> runParams = AbilityKey.mapFromPlayer(this);
        runParams.put(AbilityKey.FirstTime, this.investigatedThisTurn == 1);
        this.game.getTriggerHandler().runTrigger(TriggerType.Investigated, runParams, false);
    }

    public final void resetInvestigatedThisTurn() {
        this.investigatedThisTurn = 0;
    }

    public final void addSacrificedThisTurn(Card cpy, SpellAbility source) {
        this.game.fireEvent(new GameEventCardSacrificed());
        this.sacrificedThisTurn.add(cpy);
        Map<AbilityKey, Object> runParams = AbilityKey.mapFromPlayer(this);
        runParams.put(AbilityKey.Card, cpy);
        runParams.put(AbilityKey.Cause, source);
        runParams.put(AbilityKey.CostStack, this.game.costPaymentStack);
        runParams.put(AbilityKey.IndividualCostPaymentInstance, this.game.costPaymentStack.peek());
        this.game.getTriggerHandler().runTrigger(TriggerType.Sacrificed, runParams, false);
    }

    public final List<Card> getSacrificedThisTurn() {
        return this.sacrificedThisTurn;
    }

    public final void resetSacrificedThisTurn() {
        this.sacrificedThisTurn.clear();
    }

    public final List<Card> getSpellsCastSinceBegOfYourLastTurn() {
        ArrayList<Card> all = new ArrayList<Card>(this.game.getStack().getSpellsCastThisTurn());
        all.addAll(this.spellsCastSinceBeginningOfLastTurn);
        return all;
    }

    public final void resetSpellCastSinceBegOfYourLastTurn() {
        this.spellsCastSinceBeginningOfLastTurn = Lists.newArrayList();
    }

    public final void setSpellCastSinceBegOfYourLastTurn(List<Card> spells) {
        this.spellsCastSinceBeginningOfLastTurn = new ArrayList<Card>(spells);
    }

    public final void addSpellCastSinceBegOfYourLastTurn(List<Card> spells) {
        this.spellsCastSinceBeginningOfLastTurn.addAll(spells);
    }

    public final int getSpellsCastThisTurn() {
        return this.spellsCastThisTurn;
    }

    public final int getSpellsCastLastTurn() {
        return this.spellsCastLastTurn;
    }

    public final void addSpellCastThisTurn() {
        ++this.spellsCastThisTurn;
        ++this.spellsCastThisGame;
        ++this.achievementTracker.spellsCast;
        if (this.spellsCastThisTurn > this.achievementTracker.maxStormCount) {
            this.achievementTracker.maxStormCount = this.spellsCastThisTurn;
        }
    }

    public final void resetSpellsCastThisTurn() {
        this.spellsCastThisTurn = 0;
    }

    public final void setSpellsCastLastTurn(int num) {
        this.spellsCastLastTurn = num;
    }

    public final int getSpellsCastThisGame() {
        return this.spellsCastThisGame;
    }

    public final void resetSpellCastThisGame() {
        this.spellsCastThisGame = 0;
    }

    public final int getLifeGainedByTeamThisTurn() {
        return this.lifeGainedByTeamThisTurn;
    }

    public final void addLifeGainedByTeamThisTurn(int val) {
        this.lifeGainedByTeamThisTurn += val;
    }

    public final int getLifeGainedThisTurn() {
        return this.lifeGainedThisTurn;
    }

    public final void setLifeGainedThisTurn(int n) {
        this.lifeGainedThisTurn = n;
    }

    public final int getLifeGainedTimesThisTurn() {
        return this.lifeGainedTimesThisTurn;
    }

    public final int getLifeLostThisTurn() {
        return this.lifeLostThisTurn;
    }

    public final void setLifeLostThisTurn(int n) {
        this.lifeLostThisTurn = n;
    }

    public final int getLifeLostLastTurn() {
        return this.lifeLostLastTurn;
    }

    public final void setLifeLostLastTurn(int n) {
        this.lifeLostLastTurn = n;
    }

    public final int getNumManaShards() {
        return this.numManaShards;
    }

    public final void setNumManaShards(int n) {
        int old = this.numManaShards;
        this.numManaShards = n;
        this.view.updateNumManaShards(this);
        this.game.fireEvent(new GameEventPlayerShardsChanged(this, old, this.numManaShards));
    }

    @Override
    public int compareTo(Player o) {
        if (o == null) {
            return 1;
        }
        return this.getName().compareTo(o.getName());
    }

    public void setDraftNotes(Map<String, String> notes) {
        this.draftNotes.clear();
        this.draftNotes.putAll(notes);
    }

    public Map<String, String> getDraftNotes() {
        return this.draftNotes;
    }

    public final LobbyPlayer getLobbyPlayer() {
        return this.getController().getLobbyPlayer();
    }

    public final LobbyPlayer getOriginalLobbyPlayer() {
        return this.controller.getLobbyPlayer();
    }

    public final RegisteredPlayer getRegisteredPlayer() {
        return this.game.getMatch().getPlayers().get(this.game.getRegisteredPlayers().indexOf(this));
    }

    private void setOutcome(PlayerOutcome outcome) {
        this.stats.setOutcome(outcome);
    }

    public void onGameOver() {
        if (null == this.stats.getOutcome()) {
            this.setOutcome(PlayerOutcome.win());
        }
    }

    public CardCollection getCreaturesInPlay() {
        return CardLists.filter((Iterable<Card>)this.getCardsIn(ZoneType.Battlefield), CardPredicates.Presets.CREATURES);
    }

    public CardCollection getPlaneswalkersInPlay() {
        return CardLists.filter((Iterable<Card>)this.getCardsIn(ZoneType.Battlefield), CardPredicates.Presets.PLANESWALKERS);
    }

    public CardCollection getBattlesInPlay() {
        return CardLists.filter((Iterable<Card>)this.getCardsIn(ZoneType.Battlefield), CardPredicates.Presets.BATTLES);
    }

    public CardCollection getTokensInPlay() {
        return CardLists.filter((Iterable<Card>)this.getCardsIn(ZoneType.Battlefield), CardPredicates.Presets.TOKEN);
    }

    public CardCollection getLandsInPlay() {
        return CardLists.filter((Iterable<Card>)this.getCardsIn(ZoneType.Battlefield), CardPredicates.Presets.LANDS);
    }

    public boolean isCardInPlay(String cardName) {
        return this.getZone(ZoneType.Battlefield).contains(CardPredicates.nameEquals(cardName));
    }

    public boolean isCardInCommand(String cardName) {
        return this.getZone(ZoneType.Command).contains(CardPredicates.nameEquals(cardName));
    }

    public CardCollectionView getColoredCardsInPlay(String color) {
        return this.getColoredCardsInPlay(MagicColor.fromName(color));
    }

    public CardCollectionView getColoredCardsInPlay(byte color) {
        return CardLists.getColor(this.getCardsIn(ZoneType.Battlefield), color);
    }

    public final int getAmountOfKeyword(String k) {
        return this.keywords.getAmount(k);
    }

    public final int getLastTurnNr() {
        return this.lastTurnNr;
    }

    public void onCleanupPhase() {
        for (Card c : this.getCardsIn(ZoneType.Hand)) {
            c.setDrawnThisTurn(false);
        }
        for (PlayerZone pz : this.zones.values()) {
            pz.resetCardsAddedThisTurn();
        }
        this.setNumDrawnLastTurn(this.getNumDrawnThisTurn());
        this.resetNumDrawnThisTurn();
        this.resetNumRollsThisTurn();
        this.resetNumExploredThisTurn();
        this.resetNumForetoldThisTurn();
        this.resetNumTokenCreatedThisTurn();
        this.setNumCardsInHandStartedThisTurnWith(this.getCardsIn(ZoneType.Hand).size());
        this.setActivateLoyaltyAbilityThisTurn(false);
        this.setTappedLandForManaThisTurn(false);
        this.setLandsPlayedLastTurn(this.getLandsPlayedThisTurn());
        this.resetLandsPlayedThisTurn();
        this.resetInvestigatedThisTurn();
        this.resetSurveilThisTurn();
        this.resetDiscardedThisTurn();
        this.resetSacrificedThisTurn();
        this.resetVenturedThisTurn();
        this.setRevolt(false);
        this.setDescended(0);
        this.setSpellsCastLastTurn(this.getSpellsCastThisTurn());
        this.resetSpellsCastThisTurn();
        this.setLifeLostLastTurn(this.getLifeLostThisTurn());
        this.setLifeLostThisTurn(0);
        this.setLifeGainedThisTurn(0);
        this.lifeGainedTimesThisTurn = 0;
        this.lifeGainedByTeamThisTurn = 0;
        this.setLifeStartedThisTurnWith(this.getLife());
        this.setLibrarySearched(0);
        this.setNumManaConversion(0);
        this.setCommitedCrimeThisTurn(0);
        this.setExpentThisTurn(0);
        this.damageReceivedThisTurn.clear();
        this.planeswalkedToThisTurn.clear();
        if (this.game.getPhaseHandler().isPlayerTurn(this)) {
            this.setBeenDealtCombatDamageSinceLastTurn(false);
            this.setAttackedPlayersMyLastTurn(this.getAttackedPlayersMyTurn());
            this.clearAttackedMyTurn();
            this.lastTurnNr = this.game.getPhaseHandler().getTurn();
        }
    }

    public boolean canCastSorcery() {
        PhaseHandler now = this.game.getPhaseHandler();
        return now.isPlayerTurn(this) && now.getPhase().isMain() && this.game.getStack().isEmpty();
    }

    public final PlayerController getController() {
        if (!this.controlledBy.isEmpty()) {
            return this.controlledBy.lastEntry().getValue().getValue();
        }
        return this.controller;
    }

    public final Player getControllingPlayer() {
        if (!this.controlledBy.isEmpty()) {
            return this.controlledBy.lastEntry().getValue().getKey();
        }
        return null;
    }

    public final boolean isControlled() {
        Player ctrlPlayer = this.getControllingPlayer();
        return ctrlPlayer != null && ctrlPlayer != this;
    }

    public void addController(long timestamp, Player pl) {
        IGameEntitiesFactory master = (IGameEntitiesFactory)((Object)pl.getLobbyPlayer());
        this.addController(timestamp, pl, master.createMindSlaveController(pl, this), true);
    }

    public void addController(long timestamp, Player pl, PlayerController pc, boolean event) {
        LobbyPlayer oldLobbyPlayer = this.getLobbyPlayer();
        PlayerController oldController = this.getController();
        this.controlledBy.put(timestamp, Pair.of(pl, pc));
        this.getView().updateMindSlaveMaster(this);
        if (event) {
            this.game.fireEvent(new GameEventPlayerControl(this, oldLobbyPlayer, oldController, this.getLobbyPlayer(), this.getController()));
        }
    }

    public void removeController(long timestamp) {
        this.removeController(timestamp, true);
    }

    public void removeController(long timestamp, boolean event) {
        LobbyPlayer oldLobbyPlayer = this.getLobbyPlayer();
        PlayerController oldController = this.getController();
        this.controlledBy.remove(timestamp);
        this.getView().updateMindSlaveMaster(this);
        if (event) {
            this.game.fireEvent(new GameEventPlayerControl(this, oldLobbyPlayer, oldController, this.getLobbyPlayer(), this.getController()));
        }
    }

    public void clearController() {
        this.controlledBy.clear();
        this.game.fireEvent(new GameEventPlayerControl(this, null, null, this.getLobbyPlayer(), this.getController()));
    }

    public Map.Entry<Long, Player> getControlledWhileSearching() {
        if (this.controlledWhileSearching.isEmpty()) {
            return null;
        }
        return this.controlledWhileSearching.lastEntry();
    }

    public void addControlledWhileSearching(long timestamp, Player pl) {
        this.controlledWhileSearching.put(timestamp, pl);
    }

    public void removeControlledWhileSearching(long timestamp) {
        this.controlledWhileSearching.remove(timestamp);
    }

    public final void setFirstController(PlayerController ctrlr) {
        if (this.controller != null) {
            throw new IllegalStateException("Controller creator already assigned");
        }
        this.dangerouslySetController(ctrlr);
    }

    public final void dangerouslySetController(PlayerController ctrlr) {
        this.controller = ctrlr;
        this.updateAvatar();
        this.updateSleeve();
        this.view.updateIsAI(this);
        this.view.updateLobbyPlayerName(this);
    }

    public void updateAvatar() {
        this.view.updateAvatarIndex(this);
        this.view.updateAvatarCardImageKey(this);
        this.view.setAvatarLifeDifference(0);
        this.view.setHasLost(false);
    }

    public void updateSleeve() {
        this.view.updateSleeveIndex(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWithController(Runnable proc, PlayerController tempController) {
        long ts = this.game.getNextTimestamp();
        this.addController(ts, this, tempController, false);
        try {
            proc.run();
        }
        finally {
            this.removeController(ts, false);
        }
    }

    public boolean isSkippingCombat() {
        return !this.isInGame();
    }

    public int getStartingHandSize() {
        return this.startingHandSize;
    }

    public void setStartingHandSize(int shs) {
        this.startingHandSize = shs;
    }

    public void planeswalk(SpellAbility sa) {
        this.planeswalkTo(sa, new CardCollection(this.getZone(ZoneType.PlanarDeck).get(0)));
    }

    public void planeswalkTo(SpellAbility sa, CardCollectionView destinations) {
        System.out.println(this.getName() + " planeswalks to " + destinations.toString());
        this.game.getView().updatePlanarPlayer(this.getView());
        for (Card c : destinations) {
            this.currentPlanes.add(this.game.getAction().moveTo(this.getZone(ZoneType.Command), c, sa, AbilityKey.newMap()));
            this.planeswalkedToThisTurn.add(c);
        }
        this.game.setActivePlanes(this.currentPlanes);
        EnumMap<AbilityKey, Object> runParams = AbilityKey.newMap();
        runParams.put(AbilityKey.Cards, destinations);
        this.game.getTriggerHandler().runTrigger(TriggerType.PlaneswalkedTo, runParams, false);
        this.view.updateCurrentPlaneName(this.currentPlanes.toString().replaceAll(" \\(.*", "").replace("[", ""));
    }

    public void leaveCurrentPlane() {
        EnumMap<AbilityKey, Object> runParams = AbilityKey.newMap();
        runParams.put(AbilityKey.Cards, new CardCollection(this.currentPlanes));
        this.game.getTriggerHandler().runTrigger(TriggerType.PlaneswalkedFrom, runParams, false);
        for (Card plane : this.currentPlanes) {
            plane.clearControllers();
            this.game.getAction().moveTo(ZoneType.PlanarDeck, plane, -1, null, AbilityKey.newMap());
        }
        this.currentPlanes.clear();
    }

    public void removeCurrentPlane(Card c) {
        this.currentPlanes.remove(c);
    }

    public void initPlane() {
        if (this.game.isGameOver()) {
            return;
        }
        this.view.updateCurrentPlaneName("");
        this.game.getView().updatePlanarPlayer(this.getView());
        PlayerZone planarDeck = this.getZone(ZoneType.PlanarDeck);
        while (!planarDeck.isEmpty()) {
            Card firstPlane = planarDeck.get(0);
            planarDeck.remove(firstPlane);
            if (firstPlane.getType().isPhenomenon()) {
                planarDeck.add(firstPlane);
                continue;
            }
            this.currentPlanes.add(firstPlane);
            this.getZone(ZoneType.Command).add(firstPlane);
            break;
        }
        this.game.setActivePlanes(this.currentPlanes);
        this.view.updateCurrentPlaneName(this.currentPlanes.toString().replaceAll(" \\(.*", "").replace("[", ""));
    }

    public CardCollectionView getInboundTokens() {
        return this.inboundTokens;
    }

    public void addInboundToken(Card c) {
        this.inboundTokens.add(c);
    }

    public void removeInboundToken(Card c) {
        this.inboundTokens.remove(c);
    }

    public void onMulliganned() {
        this.game.fireEvent(new GameEventMulligan(this));
        int newHand = this.getCardsIn(ZoneType.Hand).size();
        this.stats.notifyHasMulliganed();
        this.stats.notifyOpeningHandSize(newHand);
        this.achievementTracker.mulliganTo = newHand;
    }

    public List<Card> getCommanders() {
        return this.commanders;
    }

    public void setCommanders(List<Card> commanders) {
        boolean needsUpdate = false;
        for (Card oldCommander : this.commanders) {
            if (commanders.contains(oldCommander)) continue;
            needsUpdate = true;
            this.commanders.remove(oldCommander);
            oldCommander.setCommander(false);
        }
        if (this.commanderEffect == null && !commanders.isEmpty()) {
            this.createCommanderEffect();
        }
        for (Card newCommander : commanders) {
            assert (this.equals(newCommander.getOwner()));
            if (this.commanders.contains(newCommander)) continue;
            needsUpdate = true;
            this.commanders.add(newCommander);
            newCommander.setCommander(true);
        }
        if (needsUpdate) {
            this.view.updateCommander(this);
        }
    }

    public void copyCommandersToSnapshot(Player toPlayer, Function<Card, Card> mapper) {
        Card commander;
        toPlayer.resetCommanderStats();
        toPlayer.commanders.clear();
        for (Card card : this.getCommanders()) {
            Card newCommander = mapper.apply(card);
            if (newCommander == null) {
                throw new RuntimeException("Unable to find commander in game snapshot: " + card);
            }
            toPlayer.commanders.add(newCommander);
            newCommander.setCommander(true);
        }
        for (Map.Entry entry : this.commanderCast.entrySet()) {
            commander = mapper.apply((Card)entry.getKey());
            toPlayer.commanderCast.put(commander, (Integer)entry.getValue());
        }
        for (Map.Entry entry : this.getCommanderDamage()) {
            commander = mapper.apply((Card)entry.getKey());
            if (commander == null) continue;
            int damage = (Integer)entry.getValue();
            toPlayer.addCommanderDamage(commander, damage);
        }
        if (this.commanderEffect != null) {
            Card commanderEffect = mapper.apply(this.commanderEffect);
            toPlayer.commanderEffect = (DetachedCardEffect)commanderEffect;
        }
    }

    public void addCommander(Card commander) {
        assert (this.equals(commander.getOwner()));
        if (this.commanders.contains(commander)) {
            return;
        }
        this.commanders.add(commander);
        if (this.commanderEffect == null) {
            this.createCommanderEffect();
        }
        commander.setCommander(true);
        this.view.updateCommander(this);
    }

    public void removeCommander(Card commander) {
        if (!this.commanders.remove(commander)) {
            return;
        }
        commander.setCommander(false);
        this.view.updateCommander(this);
    }

    public void setCommanderReplacementSuppressed(boolean suppress) {
        if (this.commanderEffect == null) {
            return;
        }
        for (ReplacementEffect re : this.commanderEffect.getReplacementEffects()) {
            re.setSuppressed(suppress);
        }
    }

    public Iterable<Map.Entry<Card, Integer>> getCommanderDamage() {
        return this.commanderDamage.entrySet();
    }

    public int getCommanderDamage(Card commander) {
        Integer damage = this.commanderDamage.get(commander);
        return damage == null ? 0 : damage;
    }

    public void addCommanderDamage(Card commander, int damage) {
        this.commanderDamage.merge(commander, damage, Integer::sum);
    }

    public ColorSet getCommanderColorID() {
        if (this.commanders.isEmpty()) {
            return null;
        }
        int ci = 0;
        for (Card c : this.commanders) {
            ci = (byte)(ci | c.getRules().getColorIdentity().getColor());
        }
        ColorSet identity = ColorSet.fromMask(ci);
        return identity;
    }

    public ColorSet getNotCommanderColorID() {
        if (this.commanders.isEmpty()) {
            return null;
        }
        ColorSet identity = this.getCommanderColorID();
        return identity.inverse();
    }

    public int getCommanderCast(Card commander) {
        return this.commanderCast.getOrDefault(commander, 0);
    }

    public void incCommanderCast(Card commander) {
        this.commanderCast.put(commander, this.getCommanderCast(commander) + 1);
        this.getView().updateCommanderCast(this, commander);
        this.getGame().fireEvent(new GameEventPlayerStatsChanged(this, false));
    }

    public void resetCommanderStats() {
        this.commanderCast.clear();
        this.commanderDamage.clear();
    }

    public void updateMergedCommanderInfo(Card target, Card commander) {
        this.getView().updateMergedCommanderCast(this, target, commander);
        this.getView().updateMergedCommanderDamage(target, commander);
    }

    public int getTotalCommanderCast() {
        int result = 0;
        for (Integer i : this.commanderCast.values()) {
            result += i.intValue();
        }
        return result;
    }

    public boolean isExtraTurn() {
        return this.view.getIsExtraTurn();
    }

    public void setExtraTurn(boolean b) {
        this.view.setIsExtraTurn(b);
    }

    public void setHasLost(boolean b) {
        this.view.setHasLost(b);
    }

    public void setAvatarLifeDifference(int val) {
        this.view.setAvatarLifeDifference(val);
    }

    public int getExtraTurnCount() {
        return this.view.getExtraTurnCount();
    }

    public void setExtraTurnCount(int val) {
        this.view.setExtraTurnCount(val);
    }

    public void setHasPriority(boolean val) {
        this.view.setHasPriority(val);
    }

    public boolean isAI() {
        return this.view.isAI();
    }

    public void initVariantsZones(RegisteredPlayer registeredPlayer) {
        Iterable<? extends IPaperCard> iterable;
        PlayerZone bf = this.getZone(ZoneType.Battlefield);
        Iterable<? extends IPaperCard> cards = registeredPlayer.getCardsOnBattlefield();
        if (cards != null) {
            for (IPaperCard iPaperCard : cards) {
                Card card = Card.fromPaperCard(iPaperCard, this);
                bf.add(card);
                card.setCollectible(false);
                card.setSickness(true);
                card.setStartsGameInPlay(true);
                if (!registeredPlayer.hasEnableETBCountersEffect()) continue;
                for (KeywordInterface keywordInterface : card.getKeywords()) {
                    String string = keywordInterface.getOriginal();
                    try {
                        if (!string.startsWith("etbCounter")) continue;
                        String[] stringArray = string.split(":");
                        card.addCounterInternal(CounterType.getType(stringArray[1]), Integer.parseInt(stringArray[2]), null, false, null, null);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
        PlayerZone com = this.getZone(ZoneType.Command);
        if (registeredPlayer.getVanguardAvatars() != null) {
            for (PaperCard paperCard : registeredPlayer.getVanguardAvatars()) {
                Card card = Card.fromPaperCard(paperCard, this);
                card.setCollectible(true);
                com.add(card);
            }
        }
        CardCollection cardCollection = new CardCollection();
        for (IPaperCard iPaperCard : registeredPlayer.getSchemes()) {
            cardCollection.add(Card.fromPaperCard(iPaperCard, this));
        }
        if (!cardCollection.isEmpty()) {
            for (Card card : cardCollection) {
                card.setCollectible(true);
                this.getZone(ZoneType.SchemeDeck).add(card);
            }
            this.getZone(ZoneType.SchemeDeck).shuffle();
        }
        CardCollection cardCollection2 = new CardCollection();
        for (IPaperCard iPaperCard : registeredPlayer.getPlanes()) {
            cardCollection2.add(Card.fromPaperCard(iPaperCard, this));
        }
        if (!cardCollection2.isEmpty()) {
            for (Card card : cardCollection2) {
                card.setCollectible(true);
                this.getZone(ZoneType.PlanarDeck).add(card);
            }
            this.getZone(ZoneType.PlanarDeck).shuffle();
        }
        if (!registeredPlayer.getCommanders().isEmpty()) {
            for (PaperCard paperCard : registeredPlayer.getCommanders()) {
                Card card = Card.fromPaperCard(paperCard, this);
                boolean bl = false;
                for (StaticAbility stAb : card.getStaticAbilities()) {
                    if (!stAb.hasParam("Description") || !stAb.getParam("Description").contains("If CARDNAME is your commander, choose a color before the game begins.")) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    Player p = card.getController();
                    ArrayList<String> colorChoices = new ArrayList<String>(MagicColor.Constant.ONLY_COLORS);
                    String prompt = Localizer.getInstance().getMessage("lblChooseAColorFor", card.getName());
                    SpellAbility.EmptySa cmdColorsa = new SpellAbility.EmptySa(ApiType.ChooseColor, card, p);
                    List<String> chosenColors = p.getController().chooseColors(prompt, cmdColorsa, 1, 1, colorChoices);
                    card.setChosenColors(chosenColors);
                    p.getGame().getAction().notifyOfValue(cmdColorsa, card, Localizer.getInstance().getMessage("lblPlayerPickedChosen", p.getName(), Lang.joinHomogenous(chosenColors)), p);
                }
                card.setCollectible(true);
                com.add(card);
                this.addCommander(card);
            }
        } else if (registeredPlayer.getPlaneswalker() != null) {
            Card card = Card.fromPaperCard(registeredPlayer.getPlaneswalker(), this);
            card.setCollectible(true);
            card.setCommander(true);
            com.add(card);
            this.addCommander(card);
        }
        for (IPaperCard iPaperCard : registeredPlayer.getConspiracies()) {
            Card card = Card.fromPaperCard(iPaperCard, this);
            if ((card.hasKeyword("Hidden agenda") || card.hasKeyword("Double agenda")) && !CardFactoryUtil.handleHiddenAgenda(this, card)) continue;
            if (Objects.equals(card.getName(), "Backup Plan")) {
                PlayerZone playerZone = new PlayerZone(ZoneType.ExtraHand, this);
                if (this.extraZones == null) {
                    this.extraZones = new ArrayList<PlayerZone>();
                }
                this.extraZones.add(playerZone);
            }
            com.add(card);
        }
        PlayerZone playerZone = this.getZone(ZoneType.AttractionDeck);
        for (IPaperCard iPaperCard : registeredPlayer.getAttractions()) {
            Card card = Card.fromPaperCard(iPaperCard, this);
            card.setCollectible(true);
            playerZone.add(card);
        }
        if (!playerZone.isEmpty()) {
            playerZone.shuffle();
        }
        if ((iterable = registeredPlayer.getExtraCardsInCommandZone()) != null) {
            for (IPaperCard iPaperCard : iterable) {
                Card c = Card.fromPaperCard(iPaperCard, this);
                com.add(c);
                c.setStartsGameInPlay(true);
            }
        }
        for (Card card : this.getCardsIn(ZoneType.Library)) {
            for (KeywordInterface inst : card.getKeywords()) {
                String kw = inst.getOriginal();
                if (!kw.startsWith("MayEffectFromOpeningDeck")) continue;
                String[] split = kw.split(":");
                String effName = split[1];
                SpellAbility effect = AbilityFactory.getAbility(card.getSVar(effName), card);
                effect.setActivatingPlayer(this);
                this.getController().playSpellAbilityNoStack(effect, true);
            }
        }
    }

    public boolean allCardsUniqueManaSymbols() {
        for (Card c : this.getCardsIn(ZoneType.Library)) {
            EnumSet<CardStateName> cardStateNames = c.isSplitCard() ? EnumSet.of(CardStateName.LeftSplit, CardStateName.RightSplit) : EnumSet.of(CardStateName.Original);
            HashSet<ManaCostShard> coloredManaSymbols = new HashSet<ManaCostShard>();
            HashSet<Integer> genericManaSymbols = new HashSet<Integer>();
            for (CardStateName cardStateName : cardStateNames) {
                ManaCost manaCost = c.getState(cardStateName).getManaCost();
                for (ManaCostShard manaSymbol : manaCost) {
                    if (coloredManaSymbols.add(manaSymbol)) continue;
                    return false;
                }
                int generic = manaCost.getGenericCost();
                if (generic <= 0 && manaCost.getCMC() != 0 || genericManaSymbols.add(generic)) continue;
                return false;
            }
        }
        return true;
    }

    public Card assignCompanion(Game game, PlayerController player) {
        ArrayList<Card> legalCompanions = Lists.newArrayList();
        boolean uniqueNames = true;
        HashSet<String> cardNames = new HashSet<String>();
        EnumSet<CardType.CoreType> cardTypes = EnumSet.allOf(CardType.CoreType.class);
        CardCollection nonLandInDeck = CardLists.getNotType(this.getCardsIn(ZoneType.Library), "Land");
        for (Card c : nonLandInDeck) {
            if (uniqueNames) {
                if (cardNames.contains(c.getName())) {
                    uniqueNames = false;
                } else {
                    cardNames.add(c.getName());
                }
            }
            cardTypes.retainAll((Collection)c.getPaperCard().getRules().getType().getCoreTypes());
        }
        int deckSize = this.getCardsIn(ZoneType.Library).size();
        int minSize = game.getMatch().getRules().getGameType().getDeckFormat().getMainRange().getMinimum();
        game.getAction().checkStaticAbilities(false);
        for (Card c : this.getCardsIn(ZoneType.Sideboard)) {
            for (KeywordInterface inst : c.getKeywords(Keyword.COMPANION)) {
                if (!(inst instanceof Companion)) continue;
                Companion kwInstance = (Companion)inst;
                if (kwInstance.hasSpecialRestriction()) {
                    String specialRules = kwInstance.getSpecialRules();
                    if (specialRules.equals("UniqueNames")) {
                        if (!uniqueNames) continue;
                        legalCompanions.add(c);
                        continue;
                    }
                    if (specialRules.equals("UniqueManaSymbols")) {
                        if (!this.allCardsUniqueManaSymbols()) continue;
                        legalCompanions.add(c);
                        continue;
                    }
                    if (specialRules.equals("DeckSizePlus20")) {
                        if (deckSize < minSize + 20) continue;
                        legalCompanions.add(c);
                        continue;
                    }
                    if (!specialRules.equals("SharesCardType") || cardTypes.isEmpty()) continue;
                    legalCompanions.add(c);
                    continue;
                }
                String restriction = kwInstance.getDeckRestriction();
                if (!this.deckMatchesDeckRestriction(c, restriction)) continue;
                legalCompanions.add(c);
            }
        }
        if (legalCompanions.isEmpty()) {
            return null;
        }
        CardCollectionView view = CardCollection.getView(legalCompanions);
        SpellAbility.EmptySa fakeSa = new SpellAbility.EmptySa(ApiType.CompanionChoose, (Card)legalCompanions.get(0), this);
        return player.chooseSingleEntityForEffect(view, fakeSa, Localizer.getInstance().getMessage("lblChooseACompanion", new Object[0]), true, null);
    }

    public boolean deckMatchesDeckRestriction(Card source, String restriction) {
        for (Card c : this.getCardsIn(ZoneType.Library)) {
            if (c.isValid(restriction.split(","), this, source, null)) continue;
            return false;
        }
        return true;
    }

    public static DetachedCardEffect createCompanionEffect(Game game, Card companion) {
        String name = Lang.getInstance().getPossesive(companion.getName()) + " Companion Effect";
        DetachedCardEffect eff = new DetachedCardEffect(companion, name);
        String addToHandAbility = "Mode$ Continuous | EffectZone$ Command | Affected$ Card.YouOwn+EffectSource | AffectedZone$ Command | AddAbility$ MoveToHand";
        String moveToHand = "ST$ ChangeZone | Cost$ 3 | Defined$ Self | Origin$ Command | Destination$ Hand | SorcerySpeed$ True | ActivationZone$ Command | SpellDescription$ Companion - Put CARDNAME in to your hand";
        StaticAbility stAb = StaticAbility.create(addToHandAbility, eff, eff.getCurrentState(), true);
        stAb.setSVar("MoveToHand", moveToHand);
        eff.addStaticAbility(stAb);
        return eff;
    }

    public void createCommanderEffect() {
        ReplacementEffect re;
        String moved;
        String effStr;
        PlayerZone com = this.getZone(ZoneType.Command);
        if (this.commanderEffect != null) {
            com.remove(this.commanderEffect);
        }
        DetachedCardEffect eff = new DetachedCardEffect(this, "Commander Effect");
        String validCommander = "Card.IsCommander+YouOwn";
        if (this.game.getRules().hasAppliedVariant(GameType.Oathbreaker)) {
            effStr = "DB$ ChangeZone | Origin$ Stack | Destination$ Command | Defined$ ReplacedCard";
            moved = "Event$ Moved | ValidCard$ Spell.IsCommander+YouOwn | Secondary$ True | Destination$ Graveyard,Exile,Hand,Library | Description$ If a signature spell would be put into another zone from the stack, put it into the command zone instead.";
            re = ReplacementHandler.parseReplacement(moved, eff, true);
            re.setOverridingAbility(AbilityFactory.getAbility(effStr, eff));
            eff.addReplacementEffect(re);
            validCommander = "Permanent.IsCommander+YouOwn";
            String castRestriction = "Mode$ CantBeCast | ValidCard$ Spell.IsCommander+YouOwn | EffectZone$ Command | IsPresent$ Permanent.IsCommander+YouOwn+YouCtrl | PresentZone$ Battlefield | PresentCompare$ EQ0 | Description$ Signature spell can only be cast if your oathbreaker is on the battlefield under your control.";
            eff.addStaticAbility(castRestriction);
        }
        effStr = "DB$ ChangeZone | Origin$ Battlefield,Graveyard,Exile,Library,Hand | Destination$ Command | Defined$ ReplacedCard";
        moved = "Event$ Moved | ValidCard$ " + validCommander + " | Secondary$ True | Optional$ True | OptionalDecider$ You | CommanderMoveReplacement$ True ";
        moved = this.game.getRules().hasAppliedVariant(GameType.TinyLeaders) ? moved + " | Destination$ Graveyard,Exile | Description$ If a commander would be put into its owner's graveyard or exile from anywhere, that player may put it into the command zone instead." : (this.game.getRules().hasAppliedVariant(GameType.Oathbreaker) ? moved + " | Destination$ Graveyard,Exile,Hand,Library | Description$ If a commander would be exiled or put into hand, graveyard, or library from anywhere, that player may put it into the command zone instead." : moved + " | Destination$ Hand,Library | Description$ If a commander would be put into its owner's hand or library from anywhere, its owner may put it into the command zone instead.");
        re = ReplacementHandler.parseReplacement(moved, eff, true);
        re.setOverridingAbility(AbilityFactory.getAbility(effStr, eff));
        eff.addReplacementEffect(re);
        String mayBePlayedAbility = "Mode$ Continuous | EffectZone$ Command | MayPlay$ True | Affected$ Card.IsCommander+YouOwn | AffectedZone$ Command";
        if (this.game.getRules().hasAppliedVariant(GameType.Planeswalker)) {
            mayBePlayedAbility = mayBePlayedAbility + " | MayPlayIgnoreColor$ True";
        }
        eff.addStaticAbility(mayBePlayedAbility);
        this.commanderEffect = eff;
        com.add(eff);
    }

    public void createPlanechaseEffects(Game game) {
        PlayerZone com = this.getZone(ZoneType.Command);
        String name = "Planar Dice";
        Card eff = new Card(game.nextCardId(), game);
        eff.setGameTimestamp(game.getNextTimestamp());
        eff.setName("Planar Dice");
        eff.setOwner(this);
        eff.setGamePieceType(GamePieceType.EFFECT);
        String image = ImageKeys.getTokenKey("planechase");
        eff.setImageKey(image);
        String trigger = "Mode$ PlanarDice | Result$ Planeswalk | TriggerZones$ Command | ValidPlayer$ You | Secondary$ True | TriggerDescription$ Whenever you roll the Planeswalker symbol on the planar die, planeswalk.";
        String rolledWalk = "DB$ Planeswalk | Cause$ PlanarDie";
        Trigger planesWalkTrigger = TriggerHandler.parseTrigger(trigger, eff, true);
        planesWalkTrigger.setOverridingAbility(AbilityFactory.getAbility(rolledWalk, eff));
        eff.addTrigger(planesWalkTrigger);
        String specialA = "ST$ RollPlanarDice | Cost$ X | SorcerySpeed$ True | Activator$ Player | SpecialAction$ True | ActivationZone$ Command | SpellDescription$ Roll the planar dice. X is equal to the number of times you have previously taken this action this turn. | CostDesc$ {X}: ";
        SpellAbility planarRoll = AbilityFactory.getAbility(specialA, eff);
        planarRoll.setSVar("X", "Count$PlanarDiceSpecialActionThisTurn");
        eff.addSpellAbility(planarRoll);
        eff.updateStateForView();
        com.add(eff);
        this.updateZoneForView(com);
    }

    public void createTheRing(Card host) {
        PlayerZone com = this.getZone(ZoneType.Command);
        if (this.theRing == null) {
            this.theRing = new Card(this.game.nextCardId(), null, this.game);
            this.theRing.setOwner(this);
            this.theRing.setGamePieceType(GamePieceType.EFFECT);
            String image = ImageKeys.getTokenKey("the_ring");
            if (host != null) {
                this.theRing.setImageKey("t:the_ring_" + host.getSetCode().toLowerCase());
                this.theRing.setSetCode(host.getSetCode());
            } else {
                this.theRing.setImageKey(image);
            }
            this.theRing.setName("The Ring");
            this.theRing.updateStateForView();
            com.add(this.theRing);
            this.updateZoneForView(com);
        }
    }

    public void setRingLevel(int level) {
        if (this.getTheRing() == null) {
            this.createTheRing(null);
        }
        if (level == 1) {
            String legendary = "Mode$ Continuous | EffectZone$ Command | Affected$ Card.YouCtrl+IsRingbearer | AddType$ Legendary | Description$ Your Ring-bearer is legendary.";
            String cantBeBlocked = "Mode$ CantBlockBy | EffectZone$ Command | ValidAttacker$ Card.YouCtrl+IsRingbearer | ValidBlockerRelative$ Creature.powerGTX | Description$ Your Ring-bearer can't be blocked by creatures with greater power.";
            this.getTheRing().addStaticAbility(legendary);
            StaticAbility st = this.getTheRing().addStaticAbility(cantBeBlocked);
            st.setSVar("X", "Count$CardPower");
        } else if (level == 2) {
            String attackTrig = "Mode$ Attacks | ValidCard$ Card.YouCtrl+IsRingbearer | TriggerDescription$ Whenever your ring-bearer attacks, draw a card, then discard a card. | TriggerZones$ Command";
            String drawEffect = "DB$ Draw | Defined$ You | NumCards$ 1";
            String discardEffect = "DB$ Discard | Defined$ You | NumCards$ 1 | Mode$ TgtChoose";
            Trigger attackTrigger = TriggerHandler.parseTrigger("Mode$ Attacks | ValidCard$ Card.YouCtrl+IsRingbearer | TriggerDescription$ Whenever your ring-bearer attacks, draw a card, then discard a card. | TriggerZones$ Command", this.getTheRing(), true);
            SpellAbility drawExecute = AbilityFactory.getAbility("DB$ Draw | Defined$ You | NumCards$ 1", this.getTheRing());
            AbilitySub discardExecute = (AbilitySub)AbilityFactory.getAbility("DB$ Discard | Defined$ You | NumCards$ 1 | Mode$ TgtChoose", this.getTheRing());
            drawExecute.setSubAbility(discardExecute);
            attackTrigger.setOverridingAbility(drawExecute);
            this.getTheRing().addTrigger(attackTrigger);
        } else if (level == 3) {
            String becomesBlockedTrig = "Mode$ AttackerBlockedByCreature | ValidCard$ Card.YouCtrl+IsRingbearer| ValidBlocker$ Creature | TriggerZones$ Command | TriggerDescription$ Whenever your Ring-bearer becomes blocked a creature, that creature's controller sacrifices it at the end of combat.";
            String endOfCombatTrig = "DB$ DelayedTrigger | Mode$ Phase | Phase$ EndCombat | RememberObjects$ TriggeredBlockerLKICopy | TriggerDescription$ At end of combat, the controller of the creature that blocked CARDNAME sacrifices that creature.";
            String sacBlockerEffect = "DB$ SacrificeAll | Defined$ DelayTriggerRememberedLKI";
            Trigger becomesBlockedTrigger = TriggerHandler.parseTrigger("Mode$ AttackerBlockedByCreature | ValidCard$ Card.YouCtrl+IsRingbearer| ValidBlocker$ Creature | TriggerZones$ Command | TriggerDescription$ Whenever your Ring-bearer becomes blocked a creature, that creature's controller sacrifices it at the end of combat.", this.getTheRing(), true);
            SpellAbility endCombatExecute = AbilityFactory.getAbility("DB$ DelayedTrigger | Mode$ Phase | Phase$ EndCombat | RememberObjects$ TriggeredBlockerLKICopy | TriggerDescription$ At end of combat, the controller of the creature that blocked CARDNAME sacrifices that creature.", this.getTheRing());
            AbilitySub sacExecute = (AbilitySub)AbilityFactory.getAbility("DB$ SacrificeAll | Defined$ DelayTriggerRememberedLKI", this.getTheRing());
            endCombatExecute.setAdditionalAbility("Execute", sacExecute);
            becomesBlockedTrigger.setOverridingAbility(endCombatExecute);
            this.getTheRing().addTrigger(becomesBlockedTrigger);
        } else if (level == 4) {
            String damageTrig = "Mode$ DamageDone | ValidSource$ Card.YouCtrl+IsRingbearer | ValidTarget$ Player | CombatDamage$ True | TriggerZones$ Command | TriggerDescription$ Whenever your Ring-bearer deals combat damage to a player, each opponent loses 3 life.";
            String loseEffect = "DB$ LoseLife | Defined$ Opponent | LifeAmount$ 3";
            Trigger damageTrigger = TriggerHandler.parseTrigger("Mode$ DamageDone | ValidSource$ Card.YouCtrl+IsRingbearer | ValidTarget$ Player | CombatDamage$ True | TriggerZones$ Command | TriggerDescription$ Whenever your Ring-bearer deals combat damage to a player, each opponent loses 3 life.", this.getTheRing(), true);
            SpellAbility loseExecute = AbilityFactory.getAbility("DB$ LoseLife | Defined$ Opponent | LifeAmount$ 3", this.getTheRing());
            damageTrigger.setOverridingAbility(loseExecute);
            this.getTheRing().addTrigger(damageTrigger);
        }
        this.getTheRing().updateStateForView();
    }

    public void changeOwnership(Card card) {
        Player oldOwner = card.getOwner();
        if (this.equals(oldOwner)) {
            return;
        }
        card.setOwner(this);
        if (!card.isCollectible()) {
            return;
        }
        if (this.lostOwnership.contains(card)) {
            this.lostOwnership.remove(card);
        } else {
            this.gainedOwnership.add(card);
        }
        if (oldOwner.gainedOwnership.contains(card)) {
            oldOwner.gainedOwnership.remove(card);
        } else {
            oldOwner.lostOwnership.add(card);
        }
    }

    public CardCollectionView getLostOwnership() {
        return this.lostOwnership;
    }

    public CardCollectionView getGainedOwnership() {
        return this.gainedOwnership;
    }

    @Override
    public PlayerView getView() {
        return this.view;
    }

    public SpellAbility getPaidForSA() {
        return this.paidForStack.peek();
    }

    public void pushPaidForSA(SpellAbility sa) {
        this.paidForStack.push(sa);
    }

    public void popPaidForSA() {
        this.paidForStack.poll();
    }

    public void clearPaidForSA() {
        this.paidForStack.clear();
    }

    public boolean isStartingPlayer() {
        return this.equals(this.game.getStartingPlayer());
    }

    public boolean isMonarch() {
        return this.equals(this.game.getMonarch());
    }

    public void createMonarchEffect(String set) {
        PlayerZone com = this.getZone(ZoneType.Command);
        if (this.monarchEffect == null) {
            this.monarchEffect = new Card(this.game.nextCardId(), null, this.game);
            this.monarchEffect.setOwner(this);
            this.monarchEffect.setGamePieceType(GamePieceType.EFFECT);
            if (set != null) {
                this.monarchEffect.setImageKey("t:monarch_" + set.toLowerCase());
                this.monarchEffect.setSetCode(set);
            } else {
                this.monarchEffect.setImageKey("t:monarch");
            }
            this.monarchEffect.setName("The Monarch");
            String drawTrig = "Mode$ Phase | Phase$ End of Turn | TriggerZones$ Command | ValidPlayer$ You |  TriggerDescription$ At the beginning of your end step, draw a card.";
            String drawEff = "DB$ Draw | Defined$ You";
            Trigger drawTrigger = TriggerHandler.parseTrigger("Mode$ Phase | Phase$ End of Turn | TriggerZones$ Command | ValidPlayer$ You |  TriggerDescription$ At the beginning of your end step, draw a card.", this.monarchEffect, true);
            drawTrigger.setOverridingAbility(AbilityFactory.getAbility("DB$ Draw | Defined$ You", this.monarchEffect));
            this.monarchEffect.addTrigger(drawTrigger);
            String damageTrig = "Mode$ DamageDone | ValidSource$ Creature | ValidTarget$ You | CombatDamage$ True | TriggerZones$ Command | TriggerDescription$ Whenever a creature deals combat damage to you, its controller becomes the monarch.";
            String damageEff = "DB$ BecomeMonarch | Defined$ TriggeredSourceController";
            Trigger damageTrigger = TriggerHandler.parseTrigger("Mode$ DamageDone | ValidSource$ Creature | ValidTarget$ You | CombatDamage$ True | TriggerZones$ Command | TriggerDescription$ Whenever a creature deals combat damage to you, its controller becomes the monarch.", this.monarchEffect, true);
            damageTrigger.setOverridingAbility(AbilityFactory.getAbility("DB$ BecomeMonarch | Defined$ TriggeredSourceController", this.monarchEffect));
            this.monarchEffect.addTrigger(damageTrigger);
            this.monarchEffect.updateStateForView();
        }
        com.add(this.monarchEffect);
        this.updateZoneForView(com);
    }

    public void removeMonarchEffect() {
        PlayerZone com = this.getZone(ZoneType.Command);
        if (this.monarchEffect != null) {
            com.remove(this.monarchEffect);
            this.updateZoneForView(com);
        }
    }

    public boolean canBecomeMonarch() {
        return !StaticAbilityCantBecomeMonarch.anyCantBecomeMonarch(this);
    }

    public void createInitiativeEffect(String set) {
        PlayerZone com = this.getZone(ZoneType.Command);
        if (this.initiativeEffect == null) {
            this.initiativeEffect = new Card(this.game.nextCardId(), null, this.game);
            this.initiativeEffect.setOwner(this);
            this.initiativeEffect.setGamePieceType(GamePieceType.EFFECT);
            if (set != null) {
                this.initiativeEffect.setImageKey("t:initiative_" + set.toLowerCase());
                this.initiativeEffect.setSetCode(set);
            } else {
                this.initiativeEffect.setImageKey("t:initiative");
            }
            this.initiativeEffect.setName("The Initiative");
            String damageTrig = "Mode$ DamageDoneOnceByController | ValidSource$ Player | ValidTarget$ You | CombatDamage$ True | TriggerZones$ Command | TriggerDescription$ Whenever one or more creatures a player controls deal combat damage to you, that player takes the initiative.";
            String damageEff = "DB$ TakeInitiative | Defined$ TriggeredSource";
            Trigger damageTrigger = TriggerHandler.parseTrigger("Mode$ DamageDoneOnceByController | ValidSource$ Player | ValidTarget$ You | CombatDamage$ True | TriggerZones$ Command | TriggerDescription$ Whenever one or more creatures a player controls deal combat damage to you, that player takes the initiative.", this.initiativeEffect, true);
            damageTrigger.setOverridingAbility(AbilityFactory.getAbility("DB$ TakeInitiative | Defined$ TriggeredSource", this.initiativeEffect));
            this.initiativeEffect.addTrigger(damageTrigger);
            String ventureTakeTrig = "Mode$ TakesInitiative | ValidPlayer$ You | TriggerZones$ Command | TriggerDescription$ Whenever you take the initiative and at the beginning of your upkeep, venture into Undercity. (If you're in a dungeon, advance to the next room. If not, enter Undercity. You can take the initiative even if you already have it.)";
            String ventureUpkpTrig = "Mode$ Phase | Phase$ Upkeep | TriggerZones$ Command | ValidPlayer$ You | TriggerDescription$ Whenever you take the initiative and at the beginning of your upkeep, venture into Undercity. (If you're in a dungeon, advance to the next room. If not, enter Undercity. You can take the initiative even if you already have it.) | Secondary$ True";
            String ventureEff = "DB$ Venture | Dungeon$ Undercity";
            Trigger ventureUTrigger = TriggerHandler.parseTrigger("Mode$ Phase | Phase$ Upkeep | TriggerZones$ Command | ValidPlayer$ You | TriggerDescription$ Whenever you take the initiative and at the beginning of your upkeep, venture into Undercity. (If you're in a dungeon, advance to the next room. If not, enter Undercity. You can take the initiative even if you already have it.) | Secondary$ True", this.initiativeEffect, true);
            ventureUTrigger.setOverridingAbility(AbilityFactory.getAbility("DB$ Venture | Dungeon$ Undercity", this.initiativeEffect));
            this.initiativeEffect.addTrigger(ventureUTrigger);
            Trigger ventureTTrigger = TriggerHandler.parseTrigger("Mode$ TakesInitiative | ValidPlayer$ You | TriggerZones$ Command | TriggerDescription$ Whenever you take the initiative and at the beginning of your upkeep, venture into Undercity. (If you're in a dungeon, advance to the next room. If not, enter Undercity. You can take the initiative even if you already have it.)", this.initiativeEffect, true);
            ventureTTrigger.setOverridingAbility(AbilityFactory.getAbility("DB$ Venture | Dungeon$ Undercity", this.initiativeEffect));
            this.initiativeEffect.addTrigger(ventureTTrigger);
            this.initiativeEffect.updateStateForView();
        }
        TriggerHandler triggerHandler = this.game.getTriggerHandler();
        com.add(this.initiativeEffect);
        triggerHandler.clearActiveTriggers(this.initiativeEffect, null);
        triggerHandler.registerActiveTrigger(this.initiativeEffect, false);
        this.updateZoneForView(com);
    }

    public boolean hasInitiative() {
        return this.equals(this.game.getHasInitiative());
    }

    public void removeInitiativeEffect() {
        PlayerZone com = this.getZone(ZoneType.Command);
        if (this.initiativeEffect != null) {
            com.remove(this.initiativeEffect);
            this.updateZoneForView(com);
        }
    }

    public final Card getRadiationEffect() {
        return this.radiationEffect;
    }

    public void createRadiationEffect(String setCode) {
        PlayerZone com = this.getZone(ZoneType.Command);
        if (this.radiationEffect == null) {
            this.radiationEffect = new Card(this.game.nextCardId(), null, this.game);
            this.radiationEffect.setOwner(this);
            this.radiationEffect.setGamePieceType(GamePieceType.EFFECT);
            this.radiationEffect.setImageKey("t:radiation");
            this.radiationEffect.setName("Radiation");
            if (setCode != null) {
                this.radiationEffect.setSetCode(setCode);
            }
            String trigStr = "Mode$ Phase | Phase$ Main1 | ValidPlayer$ You | TriggerZones$ Command | TriggerDescription$ At the beginning of your precombat main phase, if you have any rad counters, mill that many cards. For each nonland card milled this way, you lose 1 life and a rad counter.";
            Trigger tr = TriggerHandler.parseTrigger(trigStr, this.radiationEffect, true);
            SpellAbility sa = AbilityFactory.getAbility("DB$ InternalRadiation", this.radiationEffect);
            tr.setOverridingAbility(sa);
            this.radiationEffect.addTrigger(tr);
            this.radiationEffect.updateStateForView();
        }
        com.add(this.radiationEffect);
        this.updateZoneForView(com);
    }

    public void removeRadiationEffect() {
        PlayerZone com = this.getZone(ZoneType.Command);
        if (this.radiationEffect != null) {
            com.remove(this.radiationEffect);
            this.radiationEffect = null;
            this.updateZoneForView(com);
        }
    }

    public boolean hasRadiationEffect() {
        return this.radiationEffect != null;
    }

    public void updateKeywordCardAbilityText() {
        if (this.getKeywordCard() == null) {
            return;
        }
        PlayerZone com = this.getZone(ZoneType.Command);
        this.keywordEffect.setText("");
        this.keywordEffect.updateAbilityTextForView();
        boolean headerAdded = false;
        StringBuilder kw = new StringBuilder();
        for (KeywordInterface k : this.keywords) {
            if (!headerAdded) {
                headerAdded = true;
                kw.append(this.getName()).append(" has: \n");
            }
            kw.append(k).append("\n");
        }
        if (!kw.toString().isEmpty()) {
            this.keywordEffect.setText(this.trimKeywords(kw.toString()));
            this.keywordEffect.updateAbilityTextForView();
        }
        this.updateZoneForView(com);
    }

    public String trimKeywords(String keywordTexts) {
        if (keywordTexts.contains("Protection:")) {
            List<String> lines = Arrays.asList(keywordTexts.split("\n"));
            for (String line : lines) {
                List<String> parts;
                if (!line.startsWith("Protection:") || (parts = Arrays.asList(line.split(":"))).size() <= 2) continue;
                keywordTexts = TextUtil.fastReplace(keywordTexts, line, parts.get(2));
            }
        }
        keywordTexts = TextUtil.fastReplace(keywordTexts, ":Card.named", " from ");
        keywordTexts = TextUtil.fastReplace(keywordTexts, ":Card.Black:", " from ");
        keywordTexts = TextUtil.fastReplace(keywordTexts, ":Card.Blue:", " from ");
        keywordTexts = TextUtil.fastReplace(keywordTexts, ":Card.Red:", " from ");
        keywordTexts = TextUtil.fastReplace(keywordTexts, ":Card.Green:", " from ");
        keywordTexts = TextUtil.fastReplace(keywordTexts, ":Card.White:", " from ");
        keywordTexts = TextUtil.fastReplace(keywordTexts, ":Card.MonoColor:", " from ");
        keywordTexts = TextUtil.fastReplace(keywordTexts, ":Card.MultiColor:", " from ");
        keywordTexts = TextUtil.fastReplace(keywordTexts, ":Card.Colorless:", " from ");
        return keywordTexts;
    }

    public void checkKeywordCard() {
        if (this.keywordEffect == null) {
            return;
        }
        PlayerZone com = this.getZone(ZoneType.Command);
        if (this.keywordEffect.getAbilityText().isEmpty()) {
            com.remove(this.keywordEffect);
            this.updateZoneForView(com);
            this.keywordEffect = null;
        }
    }

    public boolean hasBlessing() {
        return this.blessingEffect != null;
    }

    public void setBlessing(boolean bless) {
        if (this.blessingEffect != null == bless) {
            return;
        }
        PlayerZone com = this.getZone(ZoneType.Command);
        if (bless) {
            this.blessingEffect = new Card(this.game.nextCardId(), null, this.game);
            this.blessingEffect.setOwner(this);
            this.blessingEffect.setImageKey("t:blessing");
            this.blessingEffect.setName("City's Blessing");
            this.blessingEffect.setGamePieceType(GamePieceType.EFFECT);
            this.blessingEffect.updateStateForView();
            com.add(this.blessingEffect);
        } else {
            com.remove(this.blessingEffect);
            this.blessingEffect = null;
        }
        this.updateZoneForView(com);
    }

    public final boolean sameTeam(Player other) {
        if (this.equals(other)) {
            return true;
        }
        if (this.teamNumber < 0 || other.getTeam() < 0) {
            return false;
        }
        return this.teamNumber == other.getTeam();
    }

    public final int countExaltedBonus() {
        return CardLists.getAmountOfKeyword((Iterable<Card>)this.getCardsIn(ZoneType.Battlefield), Keyword.EXALTED);
    }

    public final boolean isCursed() {
        return CardLists.count(this.getAttachedCards(), CardPredicates.Presets.CURSE) > 0;
    }

    public boolean canDiscardBy(SpellAbility sa, boolean effect) {
        if (sa == null) {
            return true;
        }
        return !StaticAbilityCantDiscard.cantDiscard(this, sa, effect);
    }

    public boolean canSearchLibraryWith(SpellAbility sa, Player targetPlayer) {
        if (sa == null) {
            return true;
        }
        if (this.hasKeyword("CantSearchLibrary")) {
            return false;
        }
        return targetPlayer == null || !targetPlayer.equals(sa.getActivatingPlayer()) || !this.hasKeyword("Spells and abilities you control can't cause you to search your library.");
    }

    public Card getKeywordCard() {
        if (this.keywordEffect != null) {
            return this.keywordEffect;
        }
        PlayerZone com = this.getZone(ZoneType.Command);
        this.keywordEffect = new Card(this.game.nextCardId(), null, this.game);
        this.keywordEffect.setGamePieceType(GamePieceType.EFFECT);
        this.keywordEffect.setOwner(this);
        this.keywordEffect.setName("Keyword Effects");
        this.keywordEffect.setImageKey("hidden");
        this.keywordEffect.updateStateForView();
        com.add(this.keywordEffect);
        this.updateZoneForView(com);
        return this.keywordEffect;
    }

    public void addAdditionalVote(long timestamp, int value) {
        this.additionalVotes.put(timestamp, value);
        this.getView().updateAdditionalVote(this);
        this.getGame().fireEvent(new GameEventPlayerStatsChanged(this, false));
    }

    public void removeAdditionalVote(long timestamp) {
        if (this.additionalVotes.remove(timestamp) != null) {
            this.getView().updateAdditionalVote(this);
            this.getGame().fireEvent(new GameEventPlayerStatsChanged(this, false));
        }
    }

    public int getAdditionalVotesAmount() {
        int value = 0;
        for (Integer i : this.additionalVotes.values()) {
            value += i.intValue();
        }
        return value;
    }

    public void addAdditionalOptionalVote(long timestamp, int value) {
        this.additionalOptionalVotes.put(timestamp, value);
        this.getView().updateOptionalAdditionalVote(this);
        this.getGame().fireEvent(new GameEventPlayerStatsChanged(this, false));
    }

    public void removeAdditionalOptionalVote(long timestamp) {
        if (this.additionalOptionalVotes.remove(timestamp) != null) {
            this.getView().updateOptionalAdditionalVote(this);
            this.getGame().fireEvent(new GameEventPlayerStatsChanged(this, false));
        }
    }

    public int getAdditionalOptionalVotesAmount() {
        int value = 0;
        for (Integer i : this.additionalOptionalVotes.values()) {
            value += i.intValue();
        }
        return value;
    }

    public boolean addControlVote(long timestamp) {
        if (this.controlVotes.add(timestamp)) {
            this.updateControlVote();
            return true;
        }
        return false;
    }

    public boolean removeControlVote(long timestamp) {
        if (this.controlVotes.remove(timestamp)) {
            this.updateControlVote();
            return true;
        }
        return false;
    }

    void updateControlVote() {
        Player control = this.getGame().getControlVote();
        for (Player pl : this.getGame().getPlayers()) {
            pl.getView().updateControlVote(pl.equals(control));
            this.getGame().fireEvent(new GameEventPlayerStatsChanged(pl, false));
        }
    }

    public Set<Long> getControlVote() {
        return this.controlVotes;
    }

    public void setControlVote(Set<Long> value) {
        this.controlVotes.clear();
        this.controlVotes.addAll(value);
        this.updateControlVote();
    }

    public Long getHighestControlVote() {
        if (this.controlVotes.isEmpty()) {
            return null;
        }
        return this.controlVotes.last();
    }

    public void addAdditionalVillainousChoices(long timestamp, int value) {
        this.additionalVillainousChoices.put(timestamp, value);
        this.getView().updateAdditionalVillainousChoices(this);
        this.getGame().fireEvent(new GameEventPlayerStatsChanged(this, false));
    }

    public void removeAdditionalVillainousChoices(long timestamp) {
        if (this.additionalVillainousChoices.remove(timestamp) != null) {
            this.getView().updateAdditionalVillainousChoices(this);
            this.getGame().fireEvent(new GameEventPlayerStatsChanged(this, false));
        }
    }

    public int getAdditionalVillainousChoices() {
        int value = 0;
        for (Integer i : this.additionalVillainousChoices.values()) {
            value += i.intValue();
        }
        return value;
    }

    public void addCycled(SpellAbility sp) {
        Map<AbilityKey, Object> cycleParams = AbilityKey.mapFromCard(CardCopyService.getLKICopy(this.game.getCardState(sp.getHostCard())));
        cycleParams.put(AbilityKey.Cause, sp);
        cycleParams.put(AbilityKey.Player, this);
        cycleParams.put(AbilityKey.FirstTime, CardUtil.getThisTurnActivated("Activated.Cycling+YouCtrl", sp.getHostCard(), sp, this).size() == 1);
        this.game.getTriggerHandler().runTrigger(TriggerType.Cycled, cycleParams, false);
    }

    public boolean hasUrzaLands() {
        CardCollectionView landsControlled = this.getCardsIn(ZoneType.Battlefield);
        return Iterables.any(landsControlled, Predicates.and(CardPredicates.isType("Urza's"), CardPredicates.isType("Mine"))) && Iterables.any(landsControlled, Predicates.and(CardPredicates.isType("Urza's"), CardPredicates.isType("Power-Plant"))) && Iterables.any(landsControlled, Predicates.and(CardPredicates.isType("Urza's"), CardPredicates.isType("Tower")));
    }

    public void revealFaceDownCards() {
        List<List> revealZones = Arrays.asList(Arrays.asList(ZoneType.Battlefield, ZoneType.Merged), Arrays.asList(ZoneType.Exile));
        PlayerCollection otherPlayers = new PlayerCollection(this.game.getRegisteredPlayers());
        otherPlayers.remove(this);
        for (List z : revealZones) {
            CardCollection revealCards = new CardCollection();
            for (Card c : this.game.getCardsInOwnedBy(z, this)) {
                if (!c.isRealFaceDown()) continue;
                Card lki = CardCopyService.getLKICopy(c);
                lki.forceTurnFaceUp();
                lki.setZone(c.getZone());
                revealCards.add(lki);
            }
            this.game.getAction().revealTo(revealCards, otherPlayers, Localizer.getInstance().getMessage("lblRevealFaceDownCards", new Object[0]), true);
        }
    }

    public void learnLesson(SpellAbility sa, Map<AbilityKey, Object> params) {
        if (this.hasLost()) {
            return;
        }
        Map<AbilityKey, Object> repParams = AbilityKey.mapFromAffected(this);
        repParams.put(AbilityKey.Cause, sa);
        repParams.putAll(params);
        if (this.game.getReplacementHandler().run(ReplacementType.Learn, repParams) != ReplacementResult.NotReplaced) {
            return;
        }
        CardCollection list = new CardCollection();
        if (!this.isControlled()) {
            list.addAll(CardLists.getType(this.getZone(ZoneType.Sideboard), "Lesson"));
        }
        list.addAll(this.getZone(ZoneType.Hand));
        if (list.isEmpty()) {
            return;
        }
        Card c = this.getController().chooseSingleCardForZoneChange(ZoneType.Hand, ImmutableList.of(ZoneType.Sideboard, ZoneType.Hand), sa, list, null, Localizer.getInstance().getMessage("lblLearnALesson", new Object[0]), true, this);
        if (c == null) {
            return;
        }
        if (c.isInZone(ZoneType.Sideboard)) {
            this.game.getAction().reveal(new CardCollection(c), c.getOwner(), true);
            this.game.getAction().moveTo(ZoneType.Hand, c, sa, params);
        } else if (c.isInZone(ZoneType.Hand)) {
            ArrayList<Card> discardedBefore = Lists.newArrayList(this.getDiscardedThisTurn());
            Card moved = this.discard(c, sa, true, params);
            if (moved != null) {
                Map<AbilityKey, Object> runParams = AbilityKey.mapFromPlayer(this);
                runParams.put(AbilityKey.Cards, new CardCollection(moved));
                runParams.put(AbilityKey.Cause, sa);
                runParams.put(AbilityKey.DiscardedBefore, discardedBefore);
                if (params != null) {
                    runParams.putAll(params);
                }
                this.getGame().getTriggerHandler().runTrigger(TriggerType.DiscardedAll, runParams, false);
                this.drawCards(1, sa, params);
            }
        }
    }

    public void commitCrime() {
        ++this.committedCrimeThisTurn;
        Map<AbilityKey, Object> runParams = AbilityKey.mapFromPlayer(this);
        this.game.getTriggerHandler().runTrigger(TriggerType.CommitCrime, runParams, false);
    }

    public int getCommittedCrimeThisTurn() {
        return this.committedCrimeThisTurn;
    }

    public void setCommitedCrimeThisTurn(int v) {
        this.committedCrimeThisTurn = v;
    }

    public int getExpentThisTurn() {
        return this.expentThisTurn;
    }

    public void setExpentThisTurn(int v) {
        this.expentThisTurn = v;
    }

    public void visitAttractions(int light) {
        CardCollection attractions = CardLists.filter((Iterable<Card>)this.getCardsIn(ZoneType.Battlefield), CardPredicates.isAttractionWithLight(light));
        for (Card c : attractions) {
            c.visitAttraction(this);
        }
    }

    public void rollToVisitAttractions() {
        this.visitAttractions(RollDiceEffect.rollDiceForPlayerToVisitAttractions(this));
    }

    public void addDeclaresAttackers(long ts, Player p) {
        this.declaresAttackers.put(ts, p);
    }

    public void removeDeclaresAttackers(long ts) {
        this.declaresAttackers.remove(ts);
    }

    public Player getDeclaresAttackers() {
        Map.Entry<Long, Player> e = this.declaresAttackers.lastEntry();
        return e == null ? null : e.getValue();
    }

    public void addDeclaresBlockers(long ts, Player p) {
        this.declaresBlockers.put(ts, p);
    }

    public void removeDeclaresBlockers(long ts) {
        this.declaresBlockers.remove(ts);
    }

    public Player getDeclaresBlockers() {
        Map.Entry<Long, Player> e = this.declaresBlockers.lastEntry();
        return e == null ? null : e.getValue();
    }

    public List<String> getUnlockedDoors() {
        return StreamSupport.stream(this.getCardsIn(ZoneType.Battlefield).spliterator(), false).filter(Card::isRoom).map(Card::getUnlockedRoomNames).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

