/*
 * Decompiled with CFR 0.152.
 */
package forge.game.player;

import forge.card.ColorSet;
import forge.game.card.Card;
import forge.game.keyword.Keyword;
import forge.game.spellability.SpellAbility;
import java.util.HashSet;
import java.util.Set;

public class AchievementTracker {
    public final Set<String> activatedUltimates = new HashSet<String>();
    public final Set<String> activatedNonPWUltimates = new HashSet<String>();
    public final Set<String> challengesCompleted = new HashSet<String>();
    public int mulliganTo = 7;
    public int spellsCast = 0;
    public int maxStormCount = 0;
    public int landsPlayed = 0;

    public void onSpellAbilityPlayed(SpellAbility sa) {
        Card card = sa.getHostCard();
        if (sa.hasParam("Ultimate")) {
            if (sa.isPwAbility()) {
                this.activatedUltimates.add(card.getName());
            } else {
                this.activatedNonPWUltimates.add(card.getName());
            }
        }
        if (card.getColor().equals(ColorSet.ALL_COLORS)) {
            this.challengesCompleted.add("Chromatic");
        }
    }

    public void onSpellResolve(SpellAbility spell) {
        Card card = spell.getHostCard();
        if (card.hasKeyword(Keyword.EPIC)) {
            this.challengesCompleted.add("Epic");
        }
    }
}

