/*
 * Decompiled with CFR 0.152.
 */
package forge.game.phase;

import com.google.common.collect.Maps;
import forge.util.Localizer;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public enum PhaseType {
    UNTAP("lblUntapStep", "Untap"),
    UPKEEP("lblUpkeepStep", "Upkeep"),
    DRAW("lblDrawStep", "Draw"),
    MAIN1("lblMainPhase1", "Main1"),
    COMBAT_BEGIN("lblCombatBeginStep", "BeginCombat"),
    COMBAT_DECLARE_ATTACKERS("lblCombatDeclareAttackersStep", "Declare Attackers"),
    COMBAT_DECLARE_BLOCKERS("lblCombatDeclareBlockersStep", "Declare Blockers"),
    COMBAT_FIRST_STRIKE_DAMAGE("lblCombatFirstStrikeDamageStep", "First Strike Damage"),
    COMBAT_DAMAGE("lblCombatDamageStep", "Combat Damage"),
    COMBAT_END("lblCombatEndStep", "EndCombat"),
    MAIN2("lblMainPhase2", "Main2"),
    END_OF_TURN("lblEndStep", "End of Turn"),
    CLEANUP("lblCleanupStep", "Cleanup");

    public static final List<List<PhaseType>> PHASE_GROUPS;
    private static final Map<PhaseType, Integer> PHASE_INDEX;
    public final String nameForUi;
    public final String nameForScripts;

    private static Map<PhaseType, Integer> initializePhaseIndex() {
        EnumMap<PhaseType, Integer> phaseIndex = Maps.newEnumMap(PhaseType.class);
        phaseIndex.put(UNTAP, 0);
        phaseIndex.put(UPKEEP, 0);
        phaseIndex.put(DRAW, 0);
        phaseIndex.put(MAIN1, 1);
        phaseIndex.put(COMBAT_BEGIN, 2);
        phaseIndex.put(COMBAT_DECLARE_ATTACKERS, 2);
        phaseIndex.put(COMBAT_DECLARE_BLOCKERS, 2);
        phaseIndex.put(COMBAT_FIRST_STRIKE_DAMAGE, 2);
        phaseIndex.put(COMBAT_DAMAGE, 2);
        phaseIndex.put(COMBAT_END, 2);
        phaseIndex.put(MAIN2, 3);
        phaseIndex.put(END_OF_TURN, 4);
        phaseIndex.put(CLEANUP, 5);
        return phaseIndex;
    }

    private PhaseType(String name, String name_for_scripts) {
        this.nameForUi = Localizer.getInstance().getMessage(name, new Object[0]);
        this.nameForScripts = name_for_scripts;
    }

    public final boolean isAfter(PhaseType phase) {
        return this.isBefore(phase, true);
    }

    public final boolean isMain() {
        return this == MAIN1 || this == MAIN2;
    }

    public final boolean isBefore(PhaseType phase) {
        return this.isBefore(phase, false);
    }

    public final boolean isBefore(PhaseType phase, boolean isTopsy) {
        int cmpPhaseIndex;
        int thisPhaseIndex = PHASE_INDEX.get((Object)this);
        if (thisPhaseIndex == (cmpPhaseIndex = PHASE_INDEX.get((Object)phase).intValue())) {
            List<PhaseType> phaseGroup = PHASE_GROUPS.get(thisPhaseIndex);
            return isTopsy ? phaseGroup.indexOf((Object)this) > phaseGroup.indexOf((Object)phase) : phaseGroup.indexOf((Object)this) < phaseGroup.indexOf((Object)phase);
        }
        return isTopsy ? thisPhaseIndex > cmpPhaseIndex : thisPhaseIndex < cmpPhaseIndex;
    }

    public static PhaseType smartValueOf(String value) {
        if (value == null) {
            return null;
        }
        if ("All".equals(value)) {
            return null;
        }
        String valToCompate = value.trim();
        for (PhaseType v : PhaseType.values()) {
            if (!v.nameForScripts.equalsIgnoreCase(valToCompate) && !v.name().equalsIgnoreCase(valToCompate)) continue;
            return v;
        }
        throw new IllegalArgumentException("No element named " + value + " in enum PhaseType");
    }

    public static Set<PhaseType> parseRange(String values) {
        EnumSet<PhaseType> result = EnumSet.noneOf(PhaseType.class);
        for (String s2 : values.split(",")) {
            int idxArrow = s2.indexOf("->");
            if (idxArrow >= 0) {
                PhaseType from = PhaseType.smartValueOf(s2.substring(0, idxArrow));
                String sTo = s2.substring(idxArrow + 2);
                PhaseType to = StringUtils.isBlank(sTo) ? CLEANUP : PhaseType.smartValueOf(sTo);
                result.addAll(EnumSet.range(from, to));
                continue;
            }
            if (s2.equals("Main")) {
                result.add(MAIN1);
                result.add(MAIN2);
                continue;
            }
            result.add(PhaseType.smartValueOf(s2));
        }
        return result;
    }

    public static boolean isLast(PhaseType current, boolean isTopsy) {
        if (current == null) {
            return true;
        }
        return current == CLEANUP;
    }

    public static PhaseType getNext(PhaseType current, boolean isTopsy) {
        if (current == null) {
            return PHASE_GROUPS.get(0).get(0);
        }
        int phaseIndex = PHASE_INDEX.get((Object)current);
        List<PhaseType> phaseGroup = PHASE_GROUPS.get(phaseIndex);
        int nextStepIndex = phaseGroup.indexOf((Object)current) + 1;
        if (nextStepIndex >= phaseGroup.size()) {
            nextStepIndex = 0;
            if (!isTopsy) {
                if (++phaseIndex >= PHASE_GROUPS.size()) {
                    phaseIndex = 0;
                }
            } else if (--phaseIndex < 0) {
                phaseIndex = PHASE_GROUPS.size() - 1;
            }
        }
        return PHASE_GROUPS.get(phaseIndex).get(nextStepIndex);
    }

    static {
        PHASE_GROUPS = Arrays.asList(Arrays.asList(UNTAP, UPKEEP, DRAW), Arrays.asList(MAIN1), Arrays.asList(COMBAT_BEGIN, COMBAT_DECLARE_ATTACKERS, COMBAT_DECLARE_BLOCKERS, COMBAT_FIRST_STRIKE_DAMAGE, COMBAT_DAMAGE, COMBAT_END), Arrays.asList(MAIN2), Arrays.asList(END_OF_TURN), Arrays.asList(CLEANUP));
        PHASE_INDEX = PhaseType.initializePhaseIndex();
    }
}

