/*
 * Decompiled with CFR 0.152.
 */
package forge.game.phase;

import com.google.common.collect.Lists;
import forge.GameCommand;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Phase
implements Serializable {
    private static final long serialVersionUID = 4665309652476851977L;
    protected final PhaseType type;
    protected final List<GameCommand> at = new ArrayList<GameCommand>();
    private final List<GameCommand> until = new ArrayList<GameCommand>();
    private final HashMap<Player, ArrayList<GameCommand>> untilMap = new HashMap();
    private final HashMap<Player, ArrayList<GameCommand>> untilEndMap = new HashMap();
    private final HashMap<Player, ArrayList<GameCommand>> registerMap = new HashMap();

    public Phase(PhaseType type) {
        this.type = type;
    }

    public void clearCommands() {
        this.at.clear();
        this.until.clear();
        this.untilMap.clear();
        this.untilEndMap.clear();
        this.registerMap.clear();
    }

    public final void addAt(GameCommand c) {
        this.at.add(0, c);
    }

    public void executeAt() {
        this.execute(this.at);
    }

    public final void addUntil(GameCommand c) {
        this.until.add(0, c);
    }

    public final void executeUntil() {
        this.execute(this.until);
    }

    public final void addUntil(Player p, GameCommand c) {
        if (this.untilMap.containsKey(p)) {
            this.untilMap.get(p).add(0, c);
        } else {
            this.untilMap.put(p, Lists.newArrayList(c));
        }
    }

    public final void executeUntil(Player p) {
        if (this.untilMap.containsKey(p)) {
            this.execute((List<GameCommand>)this.untilMap.get(p));
        }
    }

    public final void registerUntilEnd(Player p, GameCommand c) {
        if (this.registerMap.containsKey(p)) {
            this.registerMap.get(p).add(0, c);
        } else {
            this.registerMap.put(p, Lists.newArrayList(c));
        }
    }

    public final void addUntilEnd(Player p, GameCommand c) {
        if (this.untilEndMap.containsKey(p)) {
            this.untilEndMap.get(p).add(0, c);
        } else {
            this.untilEndMap.put(p, Lists.newArrayList(c));
        }
    }

    public final void registerUntilEndCommand(Player p) {
        if (this.registerMap.containsKey(p)) {
            this.untilEndMap.put(p, this.registerMap.get(p));
            this.registerMap.remove(p);
        }
    }

    public final void executeUntilEndOfPhase(Player p) {
        if (this.untilEndMap.containsKey(p)) {
            this.execute((List<GameCommand>)this.untilEndMap.get(p));
        }
    }

    protected void execute(List<GameCommand> c) {
        int length = c.size();
        for (int i = 0; i < length; ++i) {
            c.remove(0).run();
        }
    }
}

