/*
 * Decompiled with CFR 0.152.
 */
package forge.game.mana;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import forge.card.mana.ManaAtom;
import forge.card.mana.ManaCostShard;
import forge.game.Game;
import forge.game.ability.AbilityKey;
import forge.game.cost.CostPayment;
import forge.game.event.EventValueChangeType;
import forge.game.event.GameEventManaPool;
import forge.game.mana.Mana;
import forge.game.mana.ManaConversionMatrix;
import forge.game.mana.ManaCostBeingPaid;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.replacement.ReplacementLayer;
import forge.game.replacement.ReplacementType;
import forge.game.spellability.AbilityManaPart;
import forge.game.spellability.SpellAbility;
import forge.game.staticability.StaticAbilityUnspentMana;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ManaPool
extends ManaConversionMatrix
implements Iterable<Mana> {
    private final Player owner;
    private final ArrayListMultimap<Byte, Mana> floatingMana = ArrayListMultimap.create();

    public ManaPool(Player player) {
        this.owner = player;
        this.restoreColorReplacements();
    }

    public final int getAmountOfColor(byte color) {
        List ofColor = this.floatingMana.get((Object)color);
        return ofColor == null ? 0 : ofColor.size();
    }

    public void addMana(Mana mana) {
        this.addMana(mana, true);
    }

    public void addMana(Mana mana, boolean updateView) {
        this.floatingMana.put((Object)mana.getColor(), (Object)mana);
        if (updateView) {
            this.owner.updateManaForView();
            this.owner.getGame().fireEvent(new GameEventManaPool(this.owner, EventValueChangeType.Added, mana));
        }
    }

    public final void add(Iterable<Mana> manaList) {
        for (Mana m4 : manaList) {
            this.addMana(m4);
        }
    }

    public final boolean willManaBeLostAtEndOfPhase() {
        if (this.floatingMana.isEmpty()) {
            return false;
        }
        Map<AbilityKey, Object> runParams = AbilityKey.mapFromAffected(this.owner);
        if (!this.owner.getGame().getReplacementHandler().getReplacementList(ReplacementType.LoseMana, runParams, ReplacementLayer.Other).isEmpty()) {
            return false;
        }
        int safeMana = 0;
        for (byte c : StaticAbilityUnspentMana.getManaToKeep(this.owner)) {
            safeMana += this.getAmountOfColor(c);
        }
        return this.totalMana() != safeMana;
    }

    public final boolean hasBurn() {
        Game game = this.owner.getGame();
        return game.getRules().hasManaBurn() || StaticAbilityUnspentMana.hasManaBurn(this.owner);
    }

    public final void resetPool() {
        this.floatingMana.clear();
    }

    public final List<Mana> clearPool(boolean isEndOfPhase) {
        ArrayList<Mana> cleared = Lists.newArrayList();
        if (this.floatingMana.isEmpty()) {
            return cleared;
        }
        Byte convertTo = null;
        Map<AbilityKey, Object> runParams = AbilityKey.mapFromAffected(this.owner);
        runParams.put(AbilityKey.Mana, "C");
        switch (this.owner.getGame().getReplacementHandler().run(ReplacementType.LoseMana, runParams)) {
            case NotReplaced: {
                break;
            }
            case Skipped: {
                return cleared;
            }
            default: {
                convertTo = ManaAtom.fromName((String)runParams.get((Object)AbilityKey.Mana));
            }
        }
        ArrayList<Byte> keys = Lists.newArrayList(this.floatingMana.keySet());
        if (isEndOfPhase) {
            keys.removeAll(StaticAbilityUnspentMana.getManaToKeep(this.owner));
        }
        if (convertTo != null) {
            keys.remove(convertTo);
        }
        for (Byte b : keys) {
            List cm = this.floatingMana.get((Object)b);
            ArrayList<Mana> pMana = Lists.newArrayList();
            if (isEndOfPhase && !this.owner.getGame().getPhaseHandler().is(PhaseType.CLEANUP)) {
                for (Mana mana : cm) {
                    if (mana.getManaAbility() == null || !mana.getManaAbility().isPersistentMana()) continue;
                    pMana.add(mana);
                }
            }
            cm.removeAll(pMana);
            if (convertTo != null) {
                this.convertManaColor(b, convertTo);
                cm.addAll(pMana);
                continue;
            }
            cleared.addAll(cm);
            cm.clear();
            this.floatingMana.putAll((Object)b, pMana);
        }
        this.owner.updateManaForView();
        this.owner.getGame().fireEvent(new GameEventManaPool(this.owner, EventValueChangeType.Cleared, null));
        return cleared;
    }

    private void convertManaColor(byte originalColor, byte toColor) {
        ArrayList<Mana> convert = Lists.newArrayList();
        List cm = this.floatingMana.get((Object)originalColor);
        for (Mana m4 : cm) {
            convert.add(new Mana(toColor, m4.getSourceCard(), m4.getManaAbility()));
        }
        cm.clear();
        this.floatingMana.putAll((Object)toColor, convert);
        this.owner.updateManaForView();
    }

    public boolean removeMana(Mana mana) {
        return this.removeMana(mana, true);
    }

    public boolean removeMana(Mana mana, boolean updateView) {
        boolean result = this.floatingMana.remove(mana.getColor(), mana);
        if (result && updateView) {
            this.owner.updateManaForView();
            this.owner.getGame().fireEvent(new GameEventManaPool(this.owner, EventValueChangeType.Removed, mana));
        }
        return result;
    }

    public final void payManaFromAbility(SpellAbility saPaidFor, ManaCostBeingPaid manaCost, SpellAbility saPayment) {
        List<SpellAbility> paidAbs = saPaidFor.getPayingManaAbilities();
        paidAbs.add(saPayment);
        for (AbilityManaPart mp : saPayment.getAllManaParts()) {
            for (Mana mana : mp.getLastManaProduced()) {
                if (!saPaidFor.allowsPayingWithShard(mp.getSourceCard(), mana.getColor()) || !this.tryPayCostWithMana(saPaidFor, manaCost, mana, false)) continue;
                saPaidFor.getPayingMana().add(mana);
            }
        }
    }

    public boolean tryPayCostWithColor(byte colorCode, SpellAbility saPaidFor, ManaCostBeingPaid manaCost, List<Mana> manaSpentToPay) {
        Mana manaFound = null;
        List cm = this.floatingMana.get((Object)colorCode);
        for (Mana mana : cm) {
            if (mana.getManaAbility() != null && !mana.getManaAbility().meetsManaRestrictions(saPaidFor) || !saPaidFor.allowsPayingWithShard(mana.getSourceCard(), colorCode)) continue;
            manaFound = mana;
            break;
        }
        if (manaFound != null && this.tryPayCostWithMana(saPaidFor, manaCost, manaFound, false)) {
            manaSpentToPay.add(manaFound);
            return true;
        }
        return false;
    }

    public boolean tryPayCostWithMana(SpellAbility sa, ManaCostBeingPaid manaCost, Mana mana, boolean test) {
        if (!manaCost.isNeeded(mana, this)) {
            return false;
        }
        if (!this.removeMana(mana)) {
            return false;
        }
        manaCost.payMana(mana, this);
        return true;
    }

    public final boolean isEmpty() {
        return this.floatingMana.isEmpty();
    }

    public final int totalMana() {
        return this.floatingMana.values().size();
    }

    public boolean accountFor(AbilityManaPart ma) {
        if (ma == null) {
            return false;
        }
        if (this.floatingMana.isEmpty()) {
            return false;
        }
        ArrayList<Mana> removeFloating = Lists.newArrayList();
        boolean manaNotAccountedFor = false;
        for (Mana mana : ma.getLastManaProduced()) {
            List poolLane = this.floatingMana.get((Object)mana.getColor());
            if (poolLane != null && poolLane.contains(mana)) {
                removeFloating.add(mana);
                continue;
            }
            manaNotAccountedFor = true;
            break;
        }
        if (manaNotAccountedFor) {
            return false;
        }
        for (Mana m4 : removeFloating) {
            this.removeMana(m4);
        }
        return true;
    }

    public void refundMana(List<Mana> manaSpent) {
        this.add(manaSpent);
        manaSpent.clear();
    }

    public boolean canPayForShardWithColor(ManaCostShard shard, byte color) {
        if (shard.isOfKind(32) && color == 64) {
            return false;
        }
        byte line = this.getPossibleColorUses(color);
        for (byte outColor : ManaAtom.MANATYPES) {
            if ((line & outColor) == 0 || !shard.canBePaidWithManaOfColor(outColor)) continue;
            return true;
        }
        return shard.canBePaidWithManaOfColor((byte)0);
    }

    public boolean payManaCostFromPool(ManaCostBeingPaid cost, SpellAbility sa, boolean test, List<Mana> manaSpentToPay) {
        boolean hasConverge = sa.getHostCard().hasConverge();
        List<ManaCostShard> unpaidShards = cost.getUnpaidShards();
        Collections.sort(unpaidShards);
        for (ManaCostShard part : unpaidShards) {
            Mana mana;
            if (part == ManaCostShard.X || cost.isPaid() || (mana = CostPayment.getMana(this.owner, part, sa, hasConverge ? (byte)cost.getColorsPaid() : (byte)-1, cost.getXManaCostPaidByColor())) == null || !this.tryPayCostWithMana(sa, cost, mana, test)) continue;
            manaSpentToPay.add(mana);
        }
        if (cost.isPaid()) {
            if (test) {
                this.refundMana(manaSpentToPay);
            }
            return true;
        }
        return false;
    }

    @Override
    public Iterator<Mana> iterator() {
        return this.floatingMana.values().iterator();
    }
}

