/*
 * Decompiled with CFR 0.152.
 */
package forge.game.mana;

import forge.card.mana.ManaAtom;
import java.util.Arrays;

public class ManaConversionMatrix {
    static byte[] identityMatrix = new byte[]{1, 2, 4, 8, 16, 32};
    protected byte[] colorConversionMatrix = new byte[ManaAtom.MANATYPES.length];
    protected byte[] colorRestrictionMatrix = new byte[ManaAtom.MANATYPES.length];
    protected boolean snowForColor = false;

    public boolean isSnowForColor() {
        return this.snowForColor;
    }

    public void setSnowForColor(boolean value) {
        this.snowForColor = value;
    }

    public byte getPossibleColorUses(byte color) {
        int rowIdx = ManaAtom.getIndexOfFirstManaType(color);
        int matrixIdx = rowIdx < 0 ? identityMatrix.length - 1 : rowIdx;
        byte colorUse = this.colorConversionMatrix[matrixIdx];
        colorUse = (byte)(colorUse & this.colorRestrictionMatrix[matrixIdx]);
        return colorUse;
    }

    public void adjustColorReplacement(byte originalColor, byte replacementColor, boolean additive) {
        int rowIdx = ManaAtom.getIndexOfFirstManaType(originalColor);
        int n = rowIdx = rowIdx < 0 ? identityMatrix.length - 1 : rowIdx;
        if (additive) {
            int n2 = rowIdx;
            this.colorConversionMatrix[n2] = (byte)(this.colorConversionMatrix[n2] | replacementColor);
        } else {
            int n3 = rowIdx;
            this.colorRestrictionMatrix[n3] = (byte)(this.colorRestrictionMatrix[n3] & replacementColor);
        }
    }

    public void applyCardMatrix(ManaConversionMatrix extraMatrix) {
        int i;
        for (i = 0; i < this.colorConversionMatrix.length; ++i) {
            int n = i;
            this.colorConversionMatrix[n] = (byte)(this.colorConversionMatrix[n] | extraMatrix.colorConversionMatrix[i]);
        }
        for (i = 0; i < this.colorRestrictionMatrix.length; ++i) {
            int n = i;
            this.colorRestrictionMatrix[n] = (byte)(this.colorRestrictionMatrix[n] & extraMatrix.colorRestrictionMatrix[i]);
        }
        this.setSnowForColor(extraMatrix.isSnowForColor());
    }

    public void restoreColorReplacements() {
        System.arraycopy(identityMatrix, 0, this.colorConversionMatrix, 0, this.colorConversionMatrix.length);
        Arrays.fill(this.colorRestrictionMatrix, (byte)63);
        this.snowForColor = false;
    }
}

